/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.master;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.RadiologyMethodValue;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;
import open.dolphin.security.EncryptUtil;
import open.dolphin.service.ISystemService;
import open.dolphin.service.remote.RemoteSystemService;
import open.dolphin.utils.HibernateUtil;
import org.apache.log4j.BasicConfigurator;

public class DatabaseInitializer {
    private static final String MEMBER_TYPE = "FACILITY_USER";
    private static final String DEFAULT_FACILITY_OID = "1.3.6.1.4.1.9414.10.1";
    private static final String PROFILE_RESOURCE = "/open/dolphin/master/profile_ja.properties";
    private static final String RAD_METHOD_RESOURCE = "/open/dolphin/master/radiology_method_data.cvs";
    private final String delimiter = ",";
    private ISystemService service;
    private final String licenseName = "doctor";
    private final String licenseDesc = "\u533b\u5e2b";
    private final String licenseCodeSys = "MML0026";
    private final String department = "01";
    private final String departmentDesc = "\u5185\u79d1";
    private final String departmentCodeSys = "MML0028";
    private final String defaultEmailAddress = "someone@example.com";

    public DatabaseInitializer(String userId, String password) {
        LogWriter.info(this.getClass(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30b9\u30ad\u30fc\u30de\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u307e\u3059");
        this.createSchema();
        LogWriter.info(this.getClass(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u521d\u671f\u5316\u3092\u958b\u59cb\u3057\u307e\u3059");
        this.addDatabaseAdmin(userId, password);
        this.addDolphinMaster();
        LogWriter.info(this.getClass(), "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
    }

    private void createSchema() {
        HibernateUtil.createSchema();
    }

    private Properties importProfileResoruce() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream(PROFILE_RESOURCE));
        }
        catch (IOException ex) {
            LogWriter.error(this.getClass(), "\u7ba1\u7406\u8005\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " + ex.toString());
            System.exit(-1);
        }
        LogWriter.info(this.getClass(), "\u7ba1\u7406\u8005\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3057\u305f");
        return properties;
    }

    private boolean isEmpty(String str) {
        return str == null | str.equals("");
    }

    public void addDatabaseAdmin(String userId, String password) {
        try {
            Properties properties = this.importProfileResoruce();
            Date date = new Date();
            FacilityModel facility = new FacilityModel();
            this.setupFacility(facility, properties);
            facility.setRegisteredDate(date);
            UserModel admin = new UserModel();
            this.seupAdminUser(admin, properties, userId, password);
            admin.setRegisteredDate(date);
            admin.setFacility(facility);
            this.service = new RemoteSystemService();
            this.service.addFacilityAdmin(admin);
            LogWriter.info(this.getClass(), "\u7ba1\u7406\u8005\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), "\u7ba1\u7406\u8005\u60c5\u5831\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
        }
    }

    private void seupAdminUser(UserModel admin, Properties properties, String userId, String password) {
        admin.setUserId(properties.getProperty("admin.login.id", userId));
        password = properties.getProperty("admin.login.password", password);
        admin.setPassword(EncryptUtil.createPasswordHash(password));
        admin.setSirName(properties.getProperty("admin.sir.name"));
        admin.setGivenName(properties.getProperty("admin.given.name"));
        admin.setCommonName(admin.getSirName() + " " + admin.getGivenName());
        this.setLicenseToUser(admin);
        this.setDepartmentToUser(admin);
        admin.setEmail(properties.getProperty("admin.email", "someone@example.com"));
        admin.setMemberType(MEMBER_TYPE);
    }

    private void setDepartmentToUser(UserModel admin) {
        DepartmentModel dept = new DepartmentModel();
        dept.setDepartment("01");
        dept.setDepartmentDesc("\u5185\u79d1");
        dept.setDepartmentCodeSys("MML0028");
        admin.setDepartmentModel(dept);
    }

    private void setLicenseToUser(UserModel admin) {
        LicenseModel license = new LicenseModel();
        license.setLicense("doctor");
        license.setLicenseDesc("\u533b\u5e2b");
        license.setLicenseCodeSys("MML0026");
        admin.setLicenseModel(license);
    }

    private void setupFacility(FacilityModel facility, Properties properties) {
        facility.setFacilityId(DEFAULT_FACILITY_OID);
        facility.setFacilityName(properties.getProperty("facility.name"));
        facility.setZipCode(properties.getProperty("facility.zipcode"));
        facility.setAddress(properties.getProperty("facility.address"));
        facility.setTelephone(properties.getProperty("facility.telephone"));
        facility.setUrl(properties.getProperty("facility.url"));
        facility.setMemberType(MEMBER_TYPE);
    }

    public void addDolphinMaster() {
        try {
            this.addRdMethod(RAD_METHOD_RESOURCE);
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), e);
        }
        catch (Exception ee) {
            LogWriter.error(this.getClass(), ee);
        }
    }

    private void addRdMethod(String name) throws IOException {
        ArrayList<RadiologyMethodValue> list = new ArrayList<RadiologyMethodValue>();
        for (List<String> data : this.importRadiologyData()) {
            RadiologyMethodValue radiologyMethodValue = new RadiologyMethodValue();
            radiologyMethodValue.setHierarchyCode1(data.get(0));
            radiologyMethodValue.setHierarchyCode2(data.get(1));
            radiologyMethodValue.setMethodName(data.get(2));
            list.add(radiologyMethodValue);
        }
        if (list.isEmpty()) {
            return;
        }
        this.service.putRadMethodMaster(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> importRadiologyData() throws IOException {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        InputStreamReader ir = new InputStreamReader(this.getClass().getResourceAsStream(RAD_METHOD_RESOURCE));
        BufferedReader reader = new BufferedReader(ir);
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                result.add(this.parseLine(line));
            }
        }
        catch (IOException ex) {
            LogWriter.error(this.getClass(), "\u753b\u50cf\u8a3a\u65ad\u30de\u30b9\u30bf\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        finally {
            reader.close();
            ir.close();
        }
        return result;
    }

    private List<String> parseLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, ",", true);
        String buf = "";
        while (tokenizer.hasMoreTokens()) {
            String now = tokenizer.nextToken();
            if (now.equals(",")) {
                result.add(buf.trim());
                buf = "";
                continue;
            }
            buf = now;
        }
        result.add(buf.trim());
        return result;
    }

    public static void main(String[] args) {
        GlobalVariables.createGlobalVariables();
        GlobalVariables.setDbAddress("localhost");
        GlobalVariables.setDbPassword("nyanco");
        GlobalVariables.setDbSSLState(false);
        BasicConfigurator.configure();
        if (args.length > 0) {
            new DatabaseInitializer(args[0], args[1]);
        } else {
            new DatabaseInitializer(null, null);
        }
    }
}

