/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.diagnosisdocumentpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.CalendarCardPanel;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.ClaimMessageEvent;
import open.dolphin.client.DiagnosisTransferHandler;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.client.editor.diagnosis.DiagnosisEditorDialog;
import open.dolphin.client.editor.stamp.StampEditorDialog;
import open.dolphin.component.SpinnerCellEditor;
import open.dolphin.container.NameValuePair;
import open.dolphin.dao.SqlOrcaView;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.dto.DiagnosisSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.infomodel.DiagnosisCategoryModel;
import open.dolphin.infomodel.DiagnosisOutcomeModel;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.PatientLiteModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.infomodel.StampModel;
import open.dolphin.message.DiagnosisModuleItem;
import open.dolphin.message.DiseaseHelper;
import open.dolphin.message.MessageBuilder;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.sendclaim.SendClaimImpl;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.DebugDump;
import open.dolphin.utils.GUIDGenerator;
import open.dolphin.utils.MMLDate;
import open.dolphin.utils.ReflectMonitor;
import open.dolphin.utils.StringSubstitution;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

public final class DiagnosisDocumentPanel
extends JPanel
implements PropertyChangeListener,
IChartDocument,
IChartCommandAccepter {
    public static final String TITLE = "\u50b7\u75c5\u540d";
    private static final int DIAGNOSIS_COL = 0;
    private static final int CATEGORY_COL = 1;
    private static final int OUTCOME_COL = 2;
    private static final int START_DATE_COL = 3;
    private static final int END_DATE_COL = 4;
    private NameValuePair[] extractionObjects = GlobalConstants.getNameValuePair("diagnosis.combo.period");
    private static final String RESOURCE_BASE = "/open/dolphin/resources/images/";
    private static final String DELETE_BUTTON_IMAGE = "del_16.gif";
    private static final String ADD_BUTTON_IMAGE = "add_16.gif";
    private static final String UPDATE_BUTTON_IMAGE = "save_16.gif";
    private static final String ORCA_IMPORT_IMAGE = "move_16.gif";
    private static final String ORCA_VIEW_IMAGE = "impt_16.gif";
    private static final String TABLE_BORDER_TITLE = "\u50b7\u75c5\u6b74";
    private static final String ORCA_VIEW = "ORCA View";
    private static final String ORCA_RECORD = "ORCA";
    private static final Color ODD_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.ODD);
    private static final Color EVEN_COLOR = GlobalSettings.getColors(GlobalSettings.Parts.EVEN);
    private static final Color ORCA_BACK = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_BACK);
    private JButton addButton;
    private JButton updateButton;
    private JButton deleteButton;
    private JButton importButton;
    private JButton orcaButton;
    private JTable diagTable;
    private ObjectReflectTableModel<RegisteredDiagnosisModel> tableModel;
    private JComboBox extractionCombo;
    private JTextField countField;
    private String dolphinFirstDate;
    private boolean ascend;
    List<RegisteredDiagnosisModel> addedDiagnosis;
    List<RegisteredDiagnosisModel> updatedDiagnosis;
    private int diagnosisCount;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u50b7\u75c5\u540d";
    private boolean dirty;
    private Application app;
    private ApplicationContext appCtx;
    private TaskMonitor taskMonitor;
    private TaskService taskService;
    private JComboBox categoryCombo;
    private JComboBox outcomeCombo;

    private void applyPeriodFilter() throws NumberFormatException {
        NameValuePair pair = (NameValuePair)this.extractionCombo.getSelectedItem();
        int past = Integer.parseInt(pair.getValue());
        Date date = new Date(0L);
        ListFilter filter = new ListFilter();
        switch (past) {
            case 0: {
                break;
            }
            case 1: {
                filter = new OutcomeFilter();
                break;
            }
            default: {
                GregorianCalendar today = new GregorianCalendar();
                today.add(2, past);
                today.clear(11);
                today.clear(12);
                today.clear(13);
                today.clear(14);
                date = today.getTime();
            }
        }
        this.getDiagnosisHistory(date, filter);
    }

    public DiagnosisDocumentPanel(IChart parent) {
        this.parent = parent;
        this.initComponents();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.DiagnosisDocumentPanel;
    }

    private void initComponents() {
        this.outcomeCombo = new JComboBox();
        this.categoryCombo = new JComboBox();
        this.outcomeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.outcomeCombo.setName("outcomeCombo");
        this.outcomeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiagnosisDocumentPanel.this.outcomeComboActionPerformed(evt);
            }
        });
        this.categoryCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.categoryCombo.setName("categoryCombo");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void outcomeComboActionPerformed(ActionEvent evt) {
        this.tableModel.setValueAt("", this.diagTable.getSelectedRow(), 4);
    }

    private void initialize() {
        JPanel cmdPanel = this.createButtonPanel2();
        JPanel dolphinPanel = this.createDignosisPanel();
        JPanel filterPanel = this.createFilterPanel();
        JPanel content = new JPanel(new BorderLayout(0, 7));
        content.add((Component)cmdPanel, "North");
        content.add((Component)dolphinPanel, "Center");
        content.add((Component)filterPanel, "South");
        content.setBorder(BorderFactory.createTitledBorder(TABLE_BORDER_TITLE));
        this.setLayout(new BorderLayout(0, 7));
        this.add(content);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.ascend = GlobalVariables.getPreferences().getBoolean("diagnosis.ascending", false);
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case delete: {
                return this.delete();
            }
            case print: {
                return this.print();
            }
        }
        return false;
    }

    private JPanel createButtonPanel2() {
        this.updateButton = new JButton(this.createImageIcon(UPDATE_BUTTON_IMAGE));
        this.updateButton.addActionListener(EventHandler.create(ActionListener.class, this, "onSave"));
        this.updateButton.setEnabled(false);
        this.updateButton.setToolTipText("\u8ffd\u52a0\u5909\u66f4\u3057\u305f\u50b7\u75c5\u540d\u3092\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u53cd\u6620\u3057\u307e\u3059\u3002");
        this.deleteButton = new JButton(this.createImageIcon(DELETE_BUTTON_IMAGE));
        this.deleteButton.addActionListener(EventHandler.create(ActionListener.class, this, "delete"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText("\u9078\u629e\u3057\u305f\u50b7\u75c5\u540d\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        this.addButton = new JButton(this.createImageIcon(ADD_BUTTON_IMAGE));
        this.addButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    DiagnosisDocumentPanel.this.openEditor2();
                }
            }
        });
        this.addButton.setEnabled(!this.isReadOnly());
        this.addButton.setToolTipText("\u50b7\u75c5\u540d\u3092\u8ffd\u52a0\u3057\u307e\u3059\u3002");
        this.importButton = new JButton(this.createImageIcon(ORCA_IMPORT_IMAGE));
        this.importButton.addActionListener(EventHandler.create(ActionListener.class, this, "importFromOrca"));
        this.importButton.setToolTipText("ORCA\u306b\u767b\u9332\u3057\u3066\u3042\u308b\u75c5\u540d\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002");
        this.importButton.setEnabled(false);
        this.orcaButton = new JButton(this.createImageIcon(ORCA_VIEW_IMAGE));
        this.orcaButton.addActionListener(EventHandler.create(ActionListener.class, this, "viewOrca"));
        this.orcaButton.setToolTipText("ORCA\u306b\u767b\u9332\u3057\u3066\u3042\u308b\u75c5\u540d\u3092\u53d6\u308a\u8fbc\u307f\u307e\u3059\u3002");
        JPanel panel = new JPanel(new FlowLayout(2, 5, 0));
        panel.add(this.importButton);
        panel.add(this.orcaButton);
        panel.add(this.deleteButton);
        panel.add(this.addButton);
        panel.add(this.updateButton);
        return panel;
    }

    private JPanel createDignosisPanel() {
        String[] columnNames = new String[]{"\u75be\u60a3\u540d/\u4fee\u98fe\u8a9e", "\u5206 \u985e", "\u8ee2 \u5e30", "\u75be\u60a3\u958b\u59cb\u65e5", "\u75be\u60a3\u7d42\u4e86\u65e5"};
        String[] methodNames = new String[]{"getAliasOrName", "getCategoryDesc", "getOutcomeDesc", "getStartDate", "getEndDate"};
        Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class};
        int startNumRows = 1;
        this.tableModel = new ObjectReflectTableModel<RegisteredDiagnosisModel>(columnNames, startNumRows, methodNames, columnClasses){

            @Override
            public boolean isCellEditable(int row, int col) {
                if (DiagnosisDocumentPanel.this.isReadOnly()) {
                    return false;
                }
                String old_val = (String)this.getValueAt(row, col);
                block0 : switch (col) {
                    case 1: {
                        String[] category = new String[]{"\u4e3b\u75c5\u540d", "\u7591\u3044\u75c5\u540d"};
                        for (int i = 0; i < category.length; ++i) {
                            if (!category[i].equals(old_val)) continue;
                            DiagnosisDocumentPanel.this.categoryCombo.setSelectedIndex(i + 1);
                            break block0;
                        }
                        break;
                    }
                    case 2: {
                        String[] outcome = new String[]{"\u56de\u5fa9", "\u5168\u6cbb", "\u7d9a\u767a\u75c7(\u306e\u767a\u751f)", "\u7d42\u4e86", "\u4e2d\u6b62", "\u7d99\u7d9a", "\u6b7b\u4ea1", "\u60aa\u5316", "\u4e0d\u5909", "\u8ee2\u533b", "\u8ee2\u533b(\u6025\u6027\u75c5\u9662\u3078)", "\u8ee2\u533b(\u6162\u6027\u75c5\u9662\u3078)", "\u81ea\u5b85\u3078\u9000\u9662", "\u4e0d\u660e"};
                        for (int i = 0; i < outcome.length; ++i) {
                            if (!outcome[i].equals(old_val)) continue;
                            DiagnosisDocumentPanel.this.outcomeCombo.setSelectedIndex(i + 1);
                            break block0;
                        }
                        break;
                    }
                }
                RegisteredDiagnosisModel entry = (RegisteredDiagnosisModel)this.getObject(row);
                if (entry != null && entry.getStatus() != null && entry.getStatus().equals(DiagnosisDocumentPanel.ORCA_RECORD)) {
                    DiagnosisDocumentPanel.this.importButton.setEnabled(true);
                    return false;
                }
                DiagnosisDocumentPanel.this.importButton.setEnabled(false);
                return col == 1 || col == 2 || col == 3 || col == 4;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                RegisteredDiagnosisModel entry = (RegisteredDiagnosisModel)this.getObject(row);
                if (value == null || entry == null) {
                    return;
                }
                switch (col) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String saveCategory = entry.getCategory();
                        DiagnosisCategoryModel dcm = (DiagnosisCategoryModel)value;
                        String test = dcm.getDiagnosisCategory();
                        String string = test = test != null && !test.equals("") ? test : null;
                        if (saveCategory != null) {
                            if (test != null) {
                                if (test.equals(saveCategory)) break;
                                entry.setCategory(dcm.getDiagnosisCategory());
                                entry.setCategoryDesc(dcm.getDiagnosisCategoryDesc());
                                entry.setCategoryCodeSys(dcm.getDiagnosisCategoryCodeSys());
                                this.fireTableRowsUpdated(row, row);
                                DiagnosisDocumentPanel.this.addUpdatedList(entry);
                                break;
                            }
                            entry.setDiagnosisCategoryModel(null);
                            this.fireTableRowsUpdated(row, row);
                            DiagnosisDocumentPanel.this.addUpdatedList(entry);
                            break;
                        }
                        if (test == null) break;
                        entry.setCategory(dcm.getDiagnosisCategory());
                        entry.setCategoryDesc(dcm.getDiagnosisCategoryDesc());
                        entry.setCategoryCodeSys(dcm.getDiagnosisCategoryCodeSys());
                        this.fireTableRowsUpdated(row, row);
                        DiagnosisDocumentPanel.this.addUpdatedList(entry);
                        break;
                    }
                    case 2: {
                        String saveOutcome = entry.getOutcome();
                        DiagnosisOutcomeModel dom = (DiagnosisOutcomeModel)value;
                        String test = dom.getOutcome();
                        String string = test = test != null && !test.equals("") ? test : null;
                        if (saveOutcome != null) {
                            if (test != null) {
                                if (saveOutcome.equals(test)) break;
                                this.setEndDate(entry, dom, row);
                                break;
                            }
                            entry.setDiagnosisOutcomeModel(null);
                            this.fireTableRowsUpdated(row, row);
                            DiagnosisDocumentPanel.this.addUpdatedList(entry);
                            break;
                        }
                        if (test == null) break;
                        this.setEndDate(entry, dom, row);
                        break;
                    }
                    case 3: {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD");
                        String strVal = format.format(value);
                        if (strVal.trim().equals("")) break;
                        entry.setStartDate(strVal);
                        this.fireTableRowsUpdated(row, row);
                        DiagnosisDocumentPanel.this.addUpdatedList(entry);
                        break;
                    }
                    case 4: {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD");
                        String strVal = format.format(value);
                        if (strVal.trim().equals("") && entry.getOutcome() != null && !entry.getOutcome().equals("")) break;
                        entry.setEndDate((String)value);
                        this.fireTableRowsUpdated(row, row);
                        DiagnosisDocumentPanel.this.addUpdatedList(entry);
                        break;
                    }
                }
            }

            private void setEndDate(RegisteredDiagnosisModel entry, DiagnosisOutcomeModel dom, int row) {
                String val;
                entry.setOutcome(dom.getOutcome());
                entry.setOutcomeDesc(dom.getOutcomeDesc());
                entry.setOutcomeCodeSys(dom.getOutcomeCodeSys());
                if (GlobalVariables.getPreferences().getBoolean("autoOutcomeInput", false) && ((val = entry.getEndDate()) == null || val.equals(""))) {
                    GregorianCalendar gc = new GregorianCalendar();
                    int offset = GlobalVariables.getPreferences().getInt("diagnosis.offsetOutcomeDate", -7);
                    gc.add(5, offset);
                    String today = MMLDate.getDate(gc);
                    entry.setEndDate(today);
                }
                this.fireTableRowsUpdated(row, row);
                DiagnosisDocumentPanel.this.addUpdatedList(entry);
            }
        };
        this.diagTable = new JTable(this.tableModel);
        this.diagTable.setDefaultRenderer(Object.class, new DolphinOrcaRenderer());
        this.diagTable.setSurrendersFocusOnKeystroke(true);
        this.diagTable.setSelectionMode(0);
        this.diagTable.setRowSelectionAllowed(true);
        ListSelectionModel m = this.diagTable.getSelectionModel();
        m.addListSelectionListener(EventHandler.create(ListSelectionListener.class, this, "rowSelectionChanged", ""));
        this.diagTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    JTable source = (JTable)event.getSource();
                    RegisteredDiagnosisModel entry = (RegisteredDiagnosisModel)DiagnosisDocumentPanel.this.tableModel.getObject(source.getSelectedRow());
                    if (entry != null) {
                        if (entry.getStatus() != null) {
                            if (!entry.getStatus().equals(DiagnosisDocumentPanel.ORCA_RECORD)) {
                                DiagnosisDocumentPanel.this.openDiagnosisEditor(entry);
                            }
                        } else {
                            DiagnosisDocumentPanel.this.openDiagnosisEditor(entry);
                        }
                    }
                }
            }
        });
        String[] values = new String[]{"mainDiagnosis", "suspectedDiagnosis"};
        String[] descs = new String[]{"\u4e3b\u75c5\u540d", "\u7591\u3044\u75c5\u540d"};
        String[] codeSys = new String[]{"MML0012", "MML0015"};
        DiagnosisCategoryModel[] categoryList = new DiagnosisCategoryModel[values.length + 1];
        DiagnosisCategoryModel dcm = new DiagnosisCategoryModel();
        dcm.setDiagnosisCategory("");
        dcm.setDiagnosisCategoryDesc("");
        dcm.setDiagnosisCategoryCodeSys("");
        categoryList[0] = dcm;
        for (int i = 0; i < values.length; ++i) {
            dcm = new DiagnosisCategoryModel();
            dcm.setDiagnosisCategory(values[i]);
            dcm.setDiagnosisCategoryDesc(descs[i]);
            dcm.setDiagnosisCategoryCodeSys(codeSys[i]);
            categoryList[i + 1] = dcm;
        }
        this.categoryCombo.setModel(new DefaultComboBoxModel<DiagnosisCategoryModel>(categoryList));
        TableColumn column = this.diagTable.getColumnModel().getColumn(1);
        column.setCellEditor(new DefaultCellEditor(this.categoryCombo));
        String[] ovalues = new String[]{"recovering", "fullyRecovered", "sequelae", "end", "pause", "continued", "died", "worsening", "unchanged", "transfer", "transferAcute", "transferChronic", "home", "unknown"};
        String[] odescs = new String[]{"\u56de\u5fa9", "\u5168\u6cbb", "\u7d9a\u767a\u75c7(\u306e\u767a\u751f)", "\u7d42\u4e86", "\u4e2d\u6b62", "\u7d99\u7d9a", "\u6b7b\u4ea1", "\u60aa\u5316", "\u4e0d\u5909", "\u8ee2\u533b", "\u8ee2\u533b(\u6025\u6027\u75c5\u9662\u3078)", "\u8ee2\u533b(\u6162\u6027\u75c5\u9662\u3078)", "\u81ea\u5b85\u3078\u9000\u9662", "\u4e0d\u660e"};
        String ocodeSys = "MML0016";
        DiagnosisOutcomeModel[] outcomeList = new DiagnosisOutcomeModel[ovalues.length + 1];
        DiagnosisOutcomeModel dom = new DiagnosisOutcomeModel();
        dom.setOutcome("");
        dom.setOutcomeDesc("");
        dom.setOutcomeCodeSys("");
        outcomeList[0] = dom;
        for (int i = 0; i < ovalues.length; ++i) {
            dom = new DiagnosisOutcomeModel();
            dom.setOutcome(ovalues[i]);
            dom.setOutcomeDesc(odescs[i]);
            dom.setOutcomeCodeSys(ocodeSys);
            outcomeList[i + 1] = dom;
        }
        this.outcomeCombo.setModel(new DefaultComboBoxModel<DiagnosisOutcomeModel>(outcomeList));
        column = this.diagTable.getColumnModel().getColumn(2);
        column.setCellEditor(new DefaultCellEditor(this.outcomeCombo));
        this.setCellEditor(this.diagTable.getColumnModel().getColumn(3));
        this.setCellEditor(this.diagTable.getColumnModel().getColumn(4));
        this.diagTable.setTransferHandler(new DiagnosisTransferHandler(this));
        this.diagTable.setDragEnabled(true);
        JScrollPane scroller = new JScrollPane(this.diagTable, 20, 31);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)scroller, "Center");
        return p;
    }

    private void setCellEditor(TableColumn column) {
        String datePattern = "[0-9\\-]*";
        JTextField editorControl = new JTextField();
        editorControl.setEditable(false);
        editorControl.addFocusListener(AutoRomanListener.getInstance());
        editorControl.setDocument(new RegexConstrainedDocument(datePattern));
        new PopupListener(editorControl);
        SpinnerCellEditor cellEditor = new SpinnerCellEditor();
        column.setCellEditor(cellEditor);
    }

    private JPanel createFilterPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(7));
        p.add(new JLabel("\u62bd\u51fa\u671f\u9593(\u904e\u53bb)"));
        p.add(Box.createRigidArea(new Dimension(5, 0)));
        this.extractionCombo = new JComboBox<NameValuePair>(this.extractionObjects);
        Preferences prefs = GlobalVariables.getPreferences();
        int currentDiagnosisPeriod = prefs.getInt("diagnosis.period", 0);
        int selectIndex = NameValuePair.getIndex(String.valueOf(currentDiagnosisPeriod), this.extractionObjects);
        this.extractionCombo.setSelectedIndex(selectIndex);
        this.extractionCombo.addItemListener(EventHandler.create(ItemListener.class, this, "extPeriodChanged", ""));
        JPanel comboPanel = new JPanel(new FlowLayout(0, 0, 0));
        comboPanel.add(this.extractionCombo);
        p.add(comboPanel);
        p.add(Box.createHorizontalGlue());
        this.countField = new JTextField(2);
        this.countField.setEditable(false);
        JPanel countPanel = new JPanel(new FlowLayout(2, 5, 0));
        countPanel.add(new JLabel("\u4ef6\u6570"));
        countPanel.add(this.countField);
        p.add(countPanel);
        p.add(Box.createHorizontalStrut(7));
        p.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        return p;
    }

    public void rowSelectionChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.isReadOnly()) {
                return;
            }
            int row = this.diagTable.getSelectedRow();
            RegisteredDiagnosisModel rd = this.tableModel.getObject(row);
            if (rd == null) {
                if (this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(false);
                }
                return;
            }
            if (rd.getStatus() != null && rd.getStatus().equals(ORCA_RECORD)) {
                if (this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(false);
                }
                return;
            }
            if (!this.deleteButton.isEnabled()) {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    public void extPeriodChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.applyPeriodFilter();
        }
    }

    public JTable getDiagnosisTable() {
        return this.diagTable;
    }

    @Override
    public void start() {
        this.initialize();
        this.applyPeriodFilter();
        this.enter();
    }

    @Override
    public void stop() {
        if (this.tableModel != null) {
            this.tableModel.clear();
        }
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
    }

    private void addAddedList(RegisteredDiagnosisModel added) {
        if (this.addedDiagnosis == null) {
            this.addedDiagnosis = new ArrayList<RegisteredDiagnosisModel>(5);
        }
        this.addedDiagnosis.add(added);
        this.enableUpdate();
    }

    private void addUpdatedList(RegisteredDiagnosisModel updated) {
        if (updated.getId() != 0L) {
            if (this.updatedDiagnosis == null) {
                this.updatedDiagnosis = new ArrayList<RegisteredDiagnosisModel>(5);
            }
            if (!this.updatedDiagnosis.contains(updated)) {
                this.updatedDiagnosis.add(updated);
            }
            this.enableUpdate();
        }
    }

    private void clearDiagnosisList() {
        int index;
        if (this.addedDiagnosis != null && this.addedDiagnosis.size() > 0) {
            index = 0;
            while (this.addedDiagnosis.size() > 0) {
                this.addedDiagnosis.remove(index);
            }
        }
        if (this.updatedDiagnosis != null && this.updatedDiagnosis.size() > 0) {
            index = 0;
            while (this.updatedDiagnosis.size() > 0) {
                this.updatedDiagnosis.remove(index);
            }
        }
    }

    private void disableUpdate() {
        this.setDirty(false);
        this.updateButton.setEnabled(false);
    }

    private void enableUpdate() {
        this.setDirty(true);
        this.updateButton.setEnabled(true);
    }

    public int getDiagnosisCount() {
        return this.diagnosisCount;
    }

    public void setDiagnosisCount(int cnt) {
        this.diagnosisCount = cnt;
        try {
            String val = String.valueOf(this.diagnosisCount);
            this.countField.setText(val);
        }
        catch (RuntimeException e) {
            this.countField.setText("");
        }
    }

    private ImageIcon createImageIcon(String name) {
        String res = RESOURCE_BASE + name;
        return new ImageIcon(this.getClass().getResource(res));
    }

    public void importStampList(final List<ModuleInfoBean> stampList, final int insertRow) {
        final RemoteStampDelegater sdl = new RemoteStampDelegater();
        DBTask<List<StampModel>> task = new DBTask<List<StampModel>>(this.getParentContext()){

            @Override
            protected List<StampModel> doInBackground() throws Exception {
                List<StampModel> result = sdl.getStamp(stampList);
                return result;
            }

            @Override
            protected void succeeded(List<StampModel> list) {
                if (sdl.isNoError() && list != null) {
                    for (int i = list.size() - 1; i > -1; --i) {
                        DiagnosisDocumentPanel.this.insertStamp(list.get(i), insertRow);
                    }
                }
            }
        };
        task.execute();
    }

    private void insertStamp(StampModel sm, int row) {
        if (sm != null) {
            RegisteredDiagnosisModel module = (RegisteredDiagnosisModel)sm.toInfoModel();
            GregorianCalendar gc = new GregorianCalendar();
            String today = MMLDate.getDate(gc);
            module.setStartDate(today);
            row = this.tableModel.getObjectCount() == 0 ? 0 : row;
            int cnt = this.tableModel.getObjectCount();
            if (row == 0 && cnt == 0) {
                this.tableModel.addRow(module);
            } else if (row < cnt) {
                this.tableModel.insertRow(row, module);
            } else {
                this.tableModel.addRow(module);
            }
            this.diagTable.getSelectionModel().setSelectionInterval(row, row);
            this.addAddedList(module);
        }
    }

    public void openEditor2() {
        StampEditorDialog stampEditor = new StampEditorDialog("diagnosis", null);
        stampEditor.addPropertyChangeListener("value", this);
        stampEditor.start();
    }

    private void openDiagnosisEditor(RegisteredDiagnosisModel entry) {
        DiagnosisEditorDialog diagnosisEditor = new DiagnosisEditorDialog(null, true, entry);
        diagnosisEditor.setVisible(true);
        if (diagnosisEditor.isDirty()) {
            this.addUpdatedList(entry);
            this.enableUpdate();
        } else {
            this.disableUpdate();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ArrayList list = (ArrayList)e.getNewValue();
        if (list == null || list.size() == 0) {
            return;
        }
        int len = list.size();
        GregorianCalendar gc = new GregorianCalendar();
        String today = MMLDate.getDate(gc);
        if (this.ascend) {
            for (int i = 0; i < len; ++i) {
                RegisteredDiagnosisModel module = (RegisteredDiagnosisModel)list.get(i);
                module.setStartDate(today);
                this.tableModel.addRow(module);
                this.addAddedList(module);
            }
        } else {
            for (int i = len - 1; i > -1; --i) {
                RegisteredDiagnosisModel module = (RegisteredDiagnosisModel)list.get(i);
                module.setStartDate(today);
                this.tableModel.insertRow(0, module);
                this.addAddedList(module);
            }
        }
    }

    private void showDialogForOutcome(String message) {
        JOptionPane.showMessageDialog(this.getParentContext().getFrame(), message, GlobalConstants.getFrameTitle("\u75c5\u540d\u30c1\u30a7\u30c3\u30af"), 2);
    }

    private boolean isValidOutcome(RegisteredDiagnosisModel rd) {
        if (rd.getOutcome() == null) {
            return true;
        }
        String start = rd.getStartDate();
        String end = rd.getEndDate();
        if (start == null) {
            this.showDialogForOutcome("\u75be\u60a3\u306e\u958b\u59cb\u65e5\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        if (end == null) {
            this.showDialogForOutcome("\u75be\u60a3\u306e\u7d42\u4e86\u65e5\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        Date startDate = null;
        Date endDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            start = start.replaceAll("/", "-");
            end = end.replaceAll("/", "-");
            startDate = sdf.parse(start);
            endDate = sdf.parse(end);
        }
        catch (ParseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("\u65e5\u4ed8\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
            sb.append("\n");
            sb.append("\u300cyyyy-MM-dd\u300d\u306e\u5f62\u5f0f\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            sb.append("\n");
            sb.append("\u53f3\u30af\u30ea\u30c3\u30af\u3067\u30ab\u30ec\u30f3\u30c0\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002");
            this.showDialogForOutcome(sb.toString());
            return false;
        }
        if (endDate.before(startDate)) {
            this.showDialogForOutcome("\u75be\u60a3\u306e\u7d42\u4e86\u65e5\u304c\u958b\u59cb\u65e5\u4ee5\u524d\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        return true;
    }

    @Override
    public boolean prepare() {
        boolean sendDiagnosis = GlobalVariables.getSendDiagnosis() && ((ChartWindow)this.getParentContext()).getCLAIMListener() != null;
        Date confirmed = new Date();
        if (this.addedDiagnosis != null && this.addedDiagnosis.size() > 0) {
            for (RegisteredDiagnosisModel rd : this.addedDiagnosis) {
                rd.setKarte(this.getParentContext().getKarte());
                rd.setCreator(GlobalVariables.getUserModel());
                rd.setConfirmed(confirmed);
                rd.setRecorded(confirmed);
                rd.setStatus("F");
                if (rd.getStarted() == null) {
                    rd.setStarted(confirmed);
                }
                rd.setPatientLiteModel(this.getParentContext().getPatient().patientAsLiteModel());
                rd.setUserLiteModel(GlobalVariables.getUserModel().getLiteModel());
                if (this.isValidOutcome(rd)) continue;
                return false;
            }
        }
        if (this.updatedDiagnosis != null && this.updatedDiagnosis.size() > 0) {
            for (RegisteredDiagnosisModel rd : this.updatedDiagnosis) {
                rd.setCreator(GlobalVariables.getUserModel());
                rd.setConfirmed(confirmed);
                rd.setRecorded(confirmed);
                rd.setStatus("F");
                rd.setPatientLiteModel(this.getParentContext().getPatient().patientAsLiteModel());
                rd.setUserLiteModel(GlobalVariables.getUserModel().getLiteModel());
                if (this.isValidOutcome(rd)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean save() {
        boolean sendDiagnosis = GlobalVariables.getSendDiagnosis() && ((ChartWindow)this.getParentContext()).getCLAIMListener() != null;
        RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DiagnosisPutTask task = new DiagnosisPutTask(this.getParentContext(), this.addedDiagnosis, this.updatedDiagnosis, sendDiagnosis, ddl);
        task.execute();
        this.disableUpdate();
        return true;
    }

    public void onSave() {
        if (this.prepare()) {
            this.save();
        }
    }

    private void getDiagnosisHistory(Date past, final ListFilter filter) {
        final DiagnosisSearchSpec spec = new DiagnosisSearchSpec();
        spec.setCode(0);
        spec.setKarteId(this.getParentContext().getKarte().getId());
        if (past != null) {
            spec.setFromDate(past);
        }
        final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DBTask<List> task = new DBTask<List>(this.getParentContext()){

            @Override
            protected List doInBackground() throws Exception {
                List<RegisteredDiagnosisModel> source = ddl.getDiagnosisList(spec);
                List result = filter.filter(source);
                return result;
            }

            @Override
            protected void succeeded(List list) {
                if (ddl.isNoError() && list != null && list.size() > 0) {
                    if (DiagnosisDocumentPanel.this.ascend) {
                        Collections.sort(list);
                        RegisteredDiagnosisModel rd = (RegisteredDiagnosisModel)list.get(0);
                        DiagnosisDocumentPanel.this.dolphinFirstDate = rd.getStartDate();
                    } else {
                        Collections.sort(list, Collections.reverseOrder());
                        int index = list.size() - 1;
                        RegisteredDiagnosisModel rd = (RegisteredDiagnosisModel)list.get(index);
                        DiagnosisDocumentPanel.this.dolphinFirstDate = rd.getStartDate();
                    }
                    DiagnosisDocumentPanel.this.tableModel.setObjectList(list);
                    DiagnosisDocumentPanel.this.setDiagnosisCount(list.size());
                }
            }
        };
        task.execute();
    }

    public boolean delete() {
        final int row = this.diagTable.getSelectedRow();
        final RegisteredDiagnosisModel model = this.tableModel.getObject(row);
        if (model == null) {
            return true;
        }
        if (model.getId() == 0L && this.addedDiagnosis != null && this.addedDiagnosis.contains(model)) {
            this.tableModel.deleteRow(row);
            this.setDiagnosisCount(this.tableModel.getObjectCount());
            this.addedDiagnosis.remove(model);
            this.enableUpdate();
            return true;
        }
        final ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(new Long(model.getId()));
        final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

            @Override
            protected Void doInBackground() throws Exception {
                ddl.removeDiagnosis(list);
                return null;
            }

            @Override
            protected void succeeded(Void result) {
                if (ddl.isNoError()) {
                    DiagnosisDocumentPanel.this.tableModel.deleteRow(row);
                    DiagnosisDocumentPanel.this.setDiagnosisCount(DiagnosisDocumentPanel.this.tableModel.getObjectCount());
                    if (DiagnosisDocumentPanel.this.updatedDiagnosis != null) {
                        DiagnosisDocumentPanel.this.updatedDiagnosis.remove(model);
                    }
                    DiagnosisDocumentPanel.this.enableUpdate();
                }
            }
        };
        task.execute();
        return true;
    }

    private boolean checkOutcome(RegisteredDiagnosisModel diagnosis) {
        return diagnosis.getOutcome() != null && !diagnosis.getOutcome().equals("");
    }

    private boolean findDiagnosis(RegisteredDiagnosisModel diagnosis) {
        for (RegisteredDiagnosisModel model : this.tableModel.getObjectList()) {
            RegisteredDiagnosisModel findDiagnosis = model;
            if (findDiagnosis == null || findDiagnosis.getStatus().equals(ORCA_RECORD) || !findDiagnosis.getDiagnosis().equals(diagnosis.getDiagnosis()) || this.checkOutcome(findDiagnosis)) continue;
            return true;
        }
        return false;
    }

    public void importFromOrca() {
        RegisteredDiagnosisModel model = this.tableModel.getObject(this.diagTable.getSelectedRow());
        if (model != null) {
            if (this.findDiagnosis(model) && !this.checkOutcome(model)) {
                this.diagTable.changeSelection(this.diagTable.getSelectedRow() + 1, 0, false, false);
            } else {
                boolean sendDiagnosis = GlobalVariables.getSendDiagnosis() && ((ChartWindow)this.getParentContext()).getCLAIMListener() != null;
                Date confirmed = new Date();
                model.setKarte(this.getParentContext().getKarte());
                model.setCreator(GlobalVariables.getUserModel());
                model.setConfirmed(confirmed);
                model.setRecorded(confirmed);
                model.setStatus("F");
                if (model.getStarted() == null) {
                    model.setStarted(confirmed);
                }
                model.getDiagnosis();
                model.getDiagnosisCode();
                model.setPatientLiteModel(this.getParentContext().getPatient().patientAsLiteModel());
                model.setUserLiteModel(GlobalVariables.getUserModel().getLiteModel());
                if (this.isValidOutcome(model)) {
                    ArrayList<RegisteredDiagnosisModel> _addedDiagnosis = new ArrayList<RegisteredDiagnosisModel>();
                    _addedDiagnosis.add(model);
                    RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
                    DiagnosisPutTask task = new DiagnosisPutTask(this.getParentContext(), _addedDiagnosis, null, false, ddl);
                    task.execute();
                    this.diagTable.doLayout();
                    this.diagTable.changeSelection(this.diagTable.getSelectedRow() + 1, 0, false, false);
                }
            }
        }
    }

    public void viewOrca() {
        String patientId = this.getParentContext().getPatient().getPatientId();
        NameValuePair pair = (NameValuePair)this.extractionCombo.getSelectedItem();
        int past = Integer.parseInt(pair.getValue());
        Date date = null;
        boolean isTenki = false;
        if (past != 0) {
            if (past == 1) {
                isTenki = true;
            }
            GregorianCalendar today = new GregorianCalendar();
            today.add(2, past);
            today.clear(11);
            today.clear(12);
            today.clear(13);
            today.clear(14);
            date = today.getTime();
        } else {
            date = new Date(0L);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String from = sdf.format(date);
        String to = sdf.format(new Date());
        final DiagnosisDocumentPanel comp = this;
        final SqlOrcaView dao = new SqlOrcaView();
        final ReflectMonitor rm = new ReflectMonitor();
        rm.setReflection(dao, "getOrcaDisease", new Class[]{String.class, String.class, String.class, Boolean.class, Boolean.class}, new Object[]{patientId, from, to, new Boolean(isTenki), new Boolean(this.ascend)});
        rm.setMonitor(SwingUtilities.getWindowAncestor(comp), ORCA_VIEW, "\u75c5\u540d\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...  ", 200, 60000);
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int state = (Integer)e.getNewValue();
                switch (state) {
                    case 0: {
                        if (dao.isNoError()) {
                            List list = (List)rm.getResult();
                            if (list == null || list.size() <= 0) break;
                            if (DiagnosisDocumentPanel.this.ascend) {
                                Collections.sort(list);
                            } else {
                                Collections.sort(list, Collections.reverseOrder());
                            }
                            DiagnosisDocumentPanel.this.tableModel.addRows(list);
                            break;
                        }
                        String errMsg = dao.getErrorMessage();
                        String title = GlobalConstants.getFrameTitle(DiagnosisDocumentPanel.ORCA_VIEW);
                        JOptionPane.showMessageDialog(comp, errMsg, title, 2);
                        break;
                    }
                    case 1: {
                        DiagnosisDocumentPanel.this.orcaButton.setEnabled(true);
                        break;
                    }
                    case 2: {
                        DiagnosisDocumentPanel.this.orcaButton.setEnabled(true);
                    }
                }
            }
        };
        rm.addPropertyChangeListener(pl);
        this.orcaButton.setEnabled(false);
        rm.start();
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    private boolean print() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    class DolphinOrcaRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            boolean orca;
            RegisteredDiagnosisModel rd = (RegisteredDiagnosisModel)DiagnosisDocumentPanel.this.tableModel.getObject(row);
            boolean bl = orca = rd != null && rd.getStatus() != null && rd.getStatus().equals(DiagnosisDocumentPanel.ORCA_RECORD);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                if (orca) {
                    this.setBackground(ORCA_BACK);
                } else if (row % 2 == 0) {
                    this.setBackground(EVEN_COLOR);
                } else {
                    this.setBackground(ODD_COLOR);
                }
            }
            if (value != null) {
                if (value instanceof String) {
                    if (col == 0) {
                        CombinedStringParser combindDisease = new CombinedStringParser((String)value);
                        this.setText(combindDisease.toPlainString());
                    } else {
                        this.setText((String)value);
                    }
                } else {
                    this.setText(value.toString());
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class DiagnosisPutTask
    extends DBTask<List<Long>> {
        private List<RegisteredDiagnosisModel> added;
        private List<RegisteredDiagnosisModel> updated;
        private boolean sendClaim;
        private RemoteDocumentDelegater ddl;

        public DiagnosisPutTask(IChart chart, List<RegisteredDiagnosisModel> added, List<RegisteredDiagnosisModel> updated, boolean sendClaim, RemoteDocumentDelegater ddl) {
            super(chart);
            this.added = added;
            this.updated = updated;
            this.sendClaim = sendClaim;
            this.ddl = ddl;
        }

        @Override
        protected List<Long> doInBackground() throws Exception {
            SendClaimImpl claimListener;
            ClaimMessageEvent event;
            String claimMessage;
            PatientLiteModel patient;
            DiagnosisModuleItem mItem;
            DocInfoModel docInfo;
            if (this.updated != null && this.updated.size() > 0) {
                this.ddl.updateDiagnosis(this.updated);
            }
            List<Long> result = null;
            if (this.added != null && this.added.size() > 0) {
                result = this.ddl.putDiagnosis(this.added);
                if (this.ddl.isNoError()) {
                    for (int i = 0; i < this.added.size(); ++i) {
                        long pk = result.get(i);
                        RegisteredDiagnosisModel rd = this.added.get(i);
                        rd.setId(pk);
                    }
                }
            }
            if (this.sendClaim && this.added != null && this.added.size() > 0) {
                ArrayList<DiagnosisModuleItem> moduleItems = new ArrayList<DiagnosisModuleItem>();
                for (RegisteredDiagnosisModel rd : this.added) {
                    docInfo = new DocInfoModel();
                    docInfo.setDocId(GUIDGenerator.generate(docInfo));
                    docInfo.setTitle("\u75c5\u540d\u767b\u9332");
                    docInfo.setPurpose("recode");
                    docInfo.setFirstConfirmDate(ModelUtils.getDateTimeAsObject(rd.getConfirmDate()));
                    docInfo.setConfirmDate(ModelUtils.getDateTimeAsObject(rd.getFirstConfirmDate()));
                    mItem = new DiagnosisModuleItem();
                    mItem.setDocInfo(docInfo);
                    mItem.setRegisteredDiagnosisModule(rd);
                    moduleItems.add(mItem);
                }
                String confirmDate = this.added.get(0).getConfirmDate();
                patient = this.added.get(0).getPatientLiteModel();
                DiseaseHelper dhl = new DiseaseHelper(this.context, patient.getPatientId(), confirmDate, moduleItems);
                MessageBuilder mb = new MessageBuilder();
                claimMessage = StringSubstitution.Substitution(mb.build(dhl), "\uff0d", "\u2015");
                DebugDump.dump("diagnosisClaim.log", claimMessage);
                event = new ClaimMessageEvent(this, patient, claimMessage);
                event.setTitle("\u75c5\u540d\u767b\u9332");
                event.setConfirmDate(confirmDate);
                claimListener = ((ChartWindow)this.context).getCLAIMListener();
                if (claimListener != null) {
                    claimListener.claimMessageEvent(event);
                }
            }
            if (this.sendClaim && this.updated != null && this.updated.size() > 0) {
                ArrayList<DiagnosisModuleItem> moduleItems = new ArrayList<DiagnosisModuleItem>();
                for (RegisteredDiagnosisModel rd : this.updated) {
                    docInfo = new DocInfoModel();
                    docInfo.setDocId(GUIDGenerator.generate(docInfo));
                    docInfo.setTitle("\u75c5\u540d\u767b\u9332");
                    docInfo.setPurpose("recode");
                    docInfo.setFirstConfirmDate(ModelUtils.getDateTimeAsObject(rd.getConfirmDate()));
                    docInfo.setConfirmDate(ModelUtils.getDateTimeAsObject(rd.getFirstConfirmDate()));
                    mItem = new DiagnosisModuleItem();
                    mItem.setDocInfo(docInfo);
                    mItem.setRegisteredDiagnosisModule(rd);
                    moduleItems.add(mItem);
                }
                String confirmDate = this.updated.get(0).getConfirmDate();
                patient = this.updated.get(0).getPatientLiteModel();
                DiseaseHelper diseaseHelper = new DiseaseHelper(this.context, patient.getPatientId(), confirmDate, moduleItems);
                MessageBuilder messageBuilder = new MessageBuilder();
                claimMessage = StringSubstitution.Substitution(messageBuilder.build(diseaseHelper), "\uff0d", "\u2015");
                DebugDump.dump("diagnosisClaim.log", claimMessage);
                event = new ClaimMessageEvent(this, patient, claimMessage);
                event.setTitle("\u75c5\u540d\u767b\u9332");
                event.setConfirmDate(confirmDate);
                claimListener = ((ChartWindow)this.context).getCLAIMListener();
                if (claimListener != null) {
                    claimListener.claimMessageEvent(event);
                }
            }
            return result;
        }

        @Override
        protected void succeeded(List<Long> list) {
            DiagnosisDocumentPanel.this.clearDiagnosisList();
        }
    }

    class PopupListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private JPopupMenu popup;
        private JTextField tf;

        public PopupListener(JTextField tf) {
            this.tf = tf;
            tf.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            this.popup = new JPopupMenu();
            CalendarCardPanel cc = new CalendarCardPanel(GlobalConstants.getEventColorTable());
            cc.addPropertyChangeListener("pickedDate", this);
            cc.setCalendarRange(new int[]{-960, 960});
            this.popup.insert(cc, 0);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("pickedDate")) {
                SimpleDate sd = (SimpleDate)e.getNewValue();
                this.tf.setText(SimpleDate.simpleDateToMmldate(sd));
                this.popup.setVisible(false);
                this.popup = null;
            }
        }
    }

    class OutcomeFilter
    extends ListFilter {
        OutcomeFilter() {
        }

        @Override
        public List filter(List source) {
            ArrayList result = new ArrayList();
            for (Object rd : source) {
                String outcomeDesc = ((RegisteredDiagnosisModel)rd).getOutcomeDesc();
                if (!this.isEmpty(outcomeDesc) && !this.isContinuance(outcomeDesc)) continue;
                result.add(rd);
            }
            return result;
        }

        private boolean isEmpty(String target) {
            return target == null || target.equals("");
        }

        private boolean isContinuance(String target) {
            return target.equals("\u7d99\u7d9a");
        }
    }

    class ListFilter {
        ListFilter() {
        }

        public List filter(List source) {
            return source;
        }
    }
}

