/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.caremapdocument;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.caremapdocument.AppointColors;
import open.dolphin.client.caremapdocument.SimpleCalendarPanel;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.project.GlobalSettings;
import open.dolphin.table.IMECellEditor;
import open.dolphin.table.ObjectTableModel;
import open.dolphin.table.OddEvenRowRenderer;
import open.dolphin.utils.MMLDate;

public class AppointTablePanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1013931150179503017L;
    private final String[] COLUMN_NAMES = new String[]{"\u4e88\u7d04\u65e5", "\u5185  \u5bb9", "\u30e1   \u30e2"};
    private final int[] COLUMN_WIDTH = new int[]{90, 90, 300};
    private final int NUM_ROWS = 9;
    private final int MEMO_COLUMN = 2;
    private CareTableModel tableModel;
    private JTable careTable;
    private TodayRowRenderer todayRenderer;
    private String today;
    private IChartDocument parent;
    private boolean dirty;

    public AppointTablePanel(JButton updateBtn) {
        this.initComponents();
        this.setLayout(new BorderLayout(0, 5));
        this.todayRenderer = new TodayRowRenderer();
        this.tableModel = new CareTableModel(this.COLUMN_NAMES, 9);
        this.careTable = new JTable(this.tableModel){
            private static final long serialVersionUID = -3446348785385967929L;

            @Override
            public TableCellRenderer getCellRenderer(int row, int col) {
                AppointmentModel e = (AppointmentModel)AppointTablePanel.this.tableModel.getObject(row);
                if (e != null && e.getDate().equals(AppointTablePanel.this.today)) {
                    Color c = AppointColors.getAppointColor(e.getName());
                    AppointTablePanel.this.todayRenderer.setBackground(c);
                    return AppointTablePanel.this.todayRenderer;
                }
                return super.getCellRenderer(row, col);
            }
        };
        this.careTable.setSurrendersFocusOnKeystroke(true);
        this.careTable.setRowSelectionAllowed(true);
        this.careTable.setDefaultRenderer(Object.class, new OddEvenRowRenderer());
        TableColumn column = this.careTable.getColumnModel().getColumn(2);
        column.setCellEditor(new IMECellEditor(new JTextField(), 1, true));
        if (this.COLUMN_WIDTH != null) {
            int len = this.COLUMN_WIDTH.length;
            for (int i = 0; i < len; ++i) {
                column = this.careTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(this.COLUMN_WIDTH[i]);
            }
        }
        JScrollPane scroller = new JScrollPane(this.careTable, 20, 31);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        JPanel cmd = new JPanel(new FlowLayout(2, 5, 0));
        cmd.add(updateBtn);
        updateBtn.setMargin(new Insets(2, 2, 2, 2));
        this.add((Component)cmd, "North");
        this.add((Component)scroller, "Center");
        this.today = MMLDate.getDate();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void setParent(IChartDocument doc) {
        this.parent = doc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("CALENDAR_PROP")) {
            SimpleCalendarPanel[] calendars = (SimpleCalendarPanel[])e.getNewValue();
            int len = calendars.length;
            ArrayList<AppointmentModel> list = new ArrayList<AppointmentModel>();
            for (int i = 0; i < len; ++i) {
                List<AppointmentModel> results = calendars[i].getAppointDays();
                int size = results.size();
                for (int k = 0; k < size; ++k) {
                    list.add(results.get(k));
                }
            }
            this.tableModel.setObjectList(list);
        } else if (prop.equals("APPOINT_PROP")) {
            AppointmentModel appoint = (AppointmentModel)e.getNewValue();
            this.tableModel.updateAppoint(appoint);
        } else if (prop.equals("SELECTED_DATE_PROP")) {
            this.findAppoint((String)e.getNewValue());
        }
    }

    private void findAppoint(String date) {
        int size = this.tableModel.getDataSize();
        String val = null;
        for (int i = 0; i < size; ++i) {
            val = (String)this.tableModel.getValueAt(i, 0);
            if (!val.equals(date)) continue;
            this.careTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    protected class TodayRowRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4422900791807822090L;
    }

    protected class CareTableModel
    extends ObjectTableModel {
        private static final long serialVersionUID = -5342312972368806563L;

        public CareTableModel(String[] columnNames, int numRows) {
            super(columnNames, numRows);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.isValidRow(row) && col == 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            AppointmentModel e = (AppointmentModel)this.getObject(row);
            if (e == null) {
                return null;
            }
            String ret = null;
            switch (col) {
                case 0: {
                    ret = ModelUtils.getDateAsString(e.getDate());
                    break;
                }
                case 1: {
                    ret = e.getName();
                    break;
                }
                case 2: {
                    ret = e.getMemo();
                }
            }
            return ret;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            String str = (String)val;
            if (col != 2 || str == null || str.trim().equals("")) {
                return;
            }
            AppointmentModel entry = (AppointmentModel)this.getObject(row);
            if (entry != null) {
                entry.setMemo(str);
                if (entry.getState() == 2) {
                    entry.setState(3);
                }
                this.fireTableCellUpdated(row, col);
                if (!AppointTablePanel.this.dirty) {
                    AppointTablePanel.this.dirty = true;
                    AppointTablePanel.this.parent.setDirty(AppointTablePanel.this.dirty);
                }
            }
        }

        public void updateAppoint(AppointmentModel appoint) {
            int row = this.findAppointEntry(appoint);
            int state = appoint.getState();
            if (row == -1 && state == 1) {
                this.addAppointEntry(appoint);
            } else if (row >= 0) {
                if (appoint.getName() != null) {
                    this.fireTableRowsUpdated(row, row);
                } else {
                    this.deleteRow(row);
                }
            }
        }

        public void addAppointEntry(AppointmentModel entry) {
            this.addRow(entry);
            Collections.sort(this.getObjectList());
            int index = this.getObjectCount() - 1;
            this.fireTableRowsUpdated(0, index);
        }

        private int findAppointEntry(AppointmentModel appoint) {
            List objects = this.getObjectList();
            if (objects == null) {
                return -1;
            }
            int len = objects.size();
            int row = -1;
            for (int i = 0; i < len; ++i) {
                if (appoint != (AppointmentModel)objects.get(i)) continue;
                row = i;
                break;
            }
            return row;
        }

        public Object[] getAppointEntries() {
            List list = this.getObjectList();
            return list != null ? list.toArray() : null;
        }
    }
}

