/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import open.dolphin.client.LiteCalendarPanel;
import open.dolphin.infomodel.SimpleDate;
import open.dolphin.project.GlobalSettings;

public class CalendarCardPanel
extends JPanel {
    public static final String PICKED_DATE = "pickedDate";
    private CardLayout cardLayout = new CardLayout();
    private int current;
    private int[] range;
    private Map<String, LiteCalendarPanel> calendars = new HashMap<String, LiteCalendarPanel>(12, 1.0f);
    private Map<String, Color> colorTable;
    private List<SimpleDate> markList;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private PropertyChangeListener calendarListener;
    private Color titleFore = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_FORE);
    private Color titleBack = GlobalSettings.getColors(GlobalSettings.Parts.CALENDAR_TITLE_BACK);
    private SpinnerDateModel model;
    private JSpinner spinner;
    private JSpinner.DateEditor editor;
    private JButton backBtn;
    private JPanel cardPanel;
    private JPanel cmdPanel;
    private JButton forwardBtn;
    private JButton stopBtn;
    private JLabel titleLabel;

    public CalendarCardPanel(Map<String, Color> colorTable) {
        this.initComponents();
        this.colorTable = colorTable;
        this.calendarListener = new CalendarListener(this);
        this.current = 0;
        LiteCalendarPanel lc = new LiteCalendarPanel(this.current, false);
        lc.addPropertyChangeListener("selectedDateProp", this.calendarListener);
        lc.setEventColorTable(colorTable);
        lc.setToday(SimpleDate.today());
        String name = String.valueOf(this.current);
        this.calendars.put(name, lc);
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)lc, name);
        this.titleLabel.setForeground(this.titleFore);
        this.titleLabel.setBackground(this.titleBack);
        this.updateTitle(lc, this.titleLabel);
        this.model = new SpinnerDateModel();
        this.spinner = new JSpinner(this.model);
        this.editor = new JSpinner.DateEditor(this.spinner, "yyyy.MM");
        this.spinner.setEditor(this.editor);
        this.cmdPanel.add(this.spinner);
        Date hoge = this.model.getDate();
    }

    private void initComponents() {
        this.cardPanel = new JPanel();
        this.cmdPanel = new JPanel();
        this.backBtn = new JButton();
        this.stopBtn = new JButton();
        this.forwardBtn = new JButton();
        this.titleLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.cardPanel.setName("cardPanel");
        this.cardPanel.setLayout(new CardLayout());
        this.add((Component)this.cardPanel, "Center");
        this.cmdPanel.setName("cmdPanel");
        this.cmdPanel.setLayout(new FlowLayout(1, 0, 5));
        this.backBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/pback_16.png")));
        this.backBtn.setToolTipText("\u524d\u6708");
        this.backBtn.setName("backBtn");
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarCardPanel.this.backBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.backBtn);
        this.stopBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/splay_16.gif")));
        this.stopBtn.setToolTipText("\u4eca\u6708");
        this.stopBtn.setName("stopBtn");
        this.stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarCardPanel.this.stopBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.stopBtn);
        this.forwardBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/play_16.gif")));
        this.forwardBtn.setToolTipText("\u6b21\u6708");
        this.forwardBtn.setName("forwardBtn");
        this.forwardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarCardPanel.this.forwardBtnActionPerformed(evt);
            }
        });
        this.cmdPanel.add(this.forwardBtn);
        this.titleLabel.setFont(new Font("Dialog", 0, 14));
        this.titleLabel.setText("2010\u5e7410\u6708");
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setOpaque(true);
        this.cmdPanel.add(this.titleLabel);
        this.add((Component)this.cmdPanel, "North");
    }

    private void backBtnActionPerformed(ActionEvent evt) {
        --this.current;
        this.controlNavigation();
        this.showCalendar();
    }

    private void stopBtnActionPerformed(ActionEvent evt) {
        this.current = 0;
        this.controlNavigation();
        this.showCalendar();
    }

    private void forwardBtnActionPerformed(ActionEvent evt) {
        ++this.current;
        this.controlNavigation();
        this.showCalendar();
    }

    private void updateTitle(LiteCalendarPanel lc, JLabel label) {
        label.setText(String.format("%04d\u5e74%02d\u6708", lc.getYear(), lc.getMonth() + 1));
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    public void notifyPickedDate(SimpleDate picked) {
        this.boundSupport.firePropertyChange(PICKED_DATE, null, picked);
    }

    public int[] getRange() {
        return this.range;
    }

    public void setCalendarRange(int[] range) {
        this.range = range;
        this.controlNavigation();
    }

    public void setMarkList(List<SimpleDate> newMark) {
        if (this.markList != newMark) {
            this.markList = newMark;
        }
        LiteCalendarPanel lc = this.calendars.get(String.valueOf(this.current));
        lc.getTableModel().setMarkDates(this.markList);
    }

    private void controlNavigation() {
        if (this.range != null) {
            if (this.current == this.range[0]) {
                if (this.backBtn.isEnabled()) {
                    this.backBtn.setEnabled(false);
                }
                if (!this.forwardBtn.isEnabled()) {
                    this.forwardBtn.setEnabled(true);
                }
            } else if (this.current == this.range[1]) {
                if (this.forwardBtn.isEnabled()) {
                    this.forwardBtn.setEnabled(false);
                }
                if (!this.backBtn.isEnabled()) {
                    this.backBtn.setEnabled(true);
                }
            } else {
                if (!this.backBtn.isEnabled()) {
                    this.backBtn.setEnabled(true);
                }
                if (!this.forwardBtn.isEnabled()) {
                    this.forwardBtn.setEnabled(true);
                }
            }
        }
    }

    private void showCalendar() {
        String key = String.valueOf(this.current);
        LiteCalendarPanel lc = this.calendars.get(key);
        if (lc == null) {
            lc = new LiteCalendarPanel(this.current, false);
            lc.addPropertyChangeListener("selectedDateProp", this.calendarListener);
            lc.setEventColorTable(this.colorTable);
            lc.getTableModel().setMarkDates(this.markList);
            this.calendars.put(key, lc);
            this.cardPanel.add((Component)lc, key);
        } else {
            lc.getTableModel().setMarkDates(this.markList);
        }
        this.updateTitle(lc, this.titleLabel);
        this.cardLayout.show(this.cardPanel, key);
    }

    class CalendarListener
    implements PropertyChangeListener {
        private CalendarCardPanel owner;

        public CalendarListener(CalendarCardPanel owner) {
            this.owner = owner;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selectedDateProp")) {
                SimpleDate sd = (SimpleDate)e.getNewValue();
                this.owner.notifyPickedDate(sd);
            }
        }
    }
}

