/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.imageio.plugins.DcmImageWriteParam;
import org.dcm4che.imageio.plugins.DcmMetadata;
import org.dcm4che.util.UIDGenerator;
import org.dcm4cheri.imageio.plugins.DcmImageReader;
import org.dcm4cheri.imageio.plugins.DcmImageWriteParamImpl;
import org.dcm4cheri.imageio.plugins.DcmMetadataImpl;
import org.w3c.dom.Document;

public class DcmImageWriter
extends ImageWriter {
    public static final String VERSION = "1.0";
    private static final Dataset DS_MASK = DcmObjectFactory.getInstance().newDataset();

    public DcmImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOutput(Object output) {
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) throw new IllegalArgumentException("output is not an ImageOutputStream");
            this.output = (ImageOutputStream)output;
            return;
        } else {
            this.output = null;
        }
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        if (inData instanceof DcmMetadata) {
            return inData;
        }
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new DcmImageWriteParamImpl();
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        Date now = new Date();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat timeFormatter = new SimpleDateFormat("HHmmss.SSS");
        DcmImageWriteParam dcmParam = (DcmImageWriteParam)param;
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        UIDGenerator uidGen = UIDGenerator.getInstance();
        ds.putCS(524388, "WSD");
        ds.putCS(524384, "OT");
        ds.putIS(2097171, "1");
        ds.putDA(1576978, dateFormatter.format(now));
        ds.putTM(1576980, timeFormatter.format(now));
        ds.putUI(524310, "1.2.840.10008.5.1.4.1.1.7");
        ds.putUI(524312, uidGen.createUID());
        return new DcmMetadataImpl(ds);
    }

    public void write(IIOMetadata streamMetadata, IIOImage ioImage, ImageWriteParam param) throws IOException {
        boolean writeAsMono;
        if (this.output == null) {
            throw new IllegalStateException("output == null" + this);
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new UnsupportedOperationException("output != ImageOutputStream" + this);
        }
        if (ioImage == null) {
            throw new IllegalArgumentException("image == null" + this);
        }
        if (ioImage.getRenderedImage() == null) {
            throw new IllegalArgumentException("RenderedImage == null" + this);
        }
        if (param != null && !(param instanceof DcmImageWriteParam)) {
            throw new UnsupportedOperationException("param != DcmImageWriteParam" + this);
        }
        DcmImageWriteParam dcmParam = param == null ? (DcmImageWriteParam)this.getDefaultWriteParam() : (DcmImageWriteParam)param;
        if (streamMetadata != null && !(streamMetadata instanceof DcmMetadata)) {
            throw new IllegalArgumentException("streamMetadata != DcmImageMetadata" + this);
        }
        DcmMetadata dcmMetaData = streamMetadata == null ? (DcmMetadata)this.getDefaultStreamMetadata(dcmParam) : (DcmMetadata)streamMetadata;
        dcmMetaData = new DcmMetadataImpl(dcmMetaData.getDataset().subSet(DS_MASK));
        BufferedImage bi = (BufferedImage)ioImage.getRenderedImage();
        int dataType = bi.getType();
        Dataset ds = dcmMetaData.getDataset();
        if (dcmParam.isWriteFMI()) {
            ds.setFileMetaInfo(DcmObjectFactory.getInstance().newFileMetaInfo(ds, this.getTransferSyntax(dcmParam.getDcmEncodeParameters())));
        } else {
            ds.setFileMetaInfo(null);
        }
        boolean bl = writeAsMono = (dataType == 10 || dataType == 11) && !dcmParam.isWriteAlwaysRGB();
        if (writeAsMono) {
            System.out.println("writing as monochrome...");
            this.writeAsMonochrome(bi, dcmParam, ds);
        } else {
            boolean writeAsRGB;
            boolean bl2 = writeAsRGB = dcmParam.isWriteAlwaysRGB() || dcmParam.isWriteIndexedAsRGB() || !(bi.getColorModel() instanceof IndexColorModel);
            if (writeAsRGB) {
                System.out.println("writing as rgb...");
                this.writeAsRgb(bi, dcmParam, ds);
            } else {
                System.out.println("writing as palette color...");
                this.writeAsPaletteColor(bi, dcmParam, ds);
            }
        }
    }

    private void writeAsRgb(BufferedImage sourceImage, DcmImageWriteParam dcmParam, Dataset ds) throws IOException {
        ds.putBufferedImageAsRgb(sourceImage, dcmParam.getSourceRegion());
        ds.writeFile((ImageOutputStream)this.output, dcmParam.getDcmEncodeParameters());
    }

    private void writeAsMonochrome(BufferedImage sourceImage, DcmImageWriteParam dcmParam, Dataset ds) throws IOException {
        ds.putBufferedImageAsMonochrome(sourceImage, dcmParam.getSourceRegion(), dcmParam.isMONOCHROME2());
        ds.writeFile((ImageOutputStream)this.output, dcmParam.getDcmEncodeParameters());
    }

    private void writeAsPaletteColor(BufferedImage sourceImage, DcmImageWriteParam dcmParam, Dataset ds) throws IOException {
        ds.putBufferedImageAsPaletteColor(sourceImage, dcmParam.getSourceRegion());
        ds.writeFile((ImageOutputStream)this.output, dcmParam.getDcmEncodeParameters());
    }

    private String getTransferSyntax(DcmEncodeParam dcmEncodeParams) {
        if (dcmEncodeParams.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            if (dcmEncodeParams.explicitVR) {
                return "1.2.840.10008.1.2.1";
            }
            return "1.2.840.10008.1.2";
        }
        if (dcmEncodeParams.byteOrder == ByteOrder.BIG_ENDIAN && dcmEncodeParams.explicitVR) {
            return "1.2.840.10008.1.2.2";
        }
        throw new IllegalStateException("Bad DICOM encoding parameters");
    }

    public static void main(String[] args) throws IOException {
        Document doc;
        String xml = "/home/joe/dump.xml";
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File("/home/joe/dump.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String testimg = "/home/joe/work/dicom/dicom-images/MR001.dcm";
        Iterator<Object> iter = ImageIO.getImageReadersByFormatName("DICOM");
        DcmImageReader rdr = (DcmImageReader)iter.next();
        rdr.setInput(ImageIO.createImageInputStream(new File("/home/joe/work/dicom/dicom-images/MR001.dcm")));
        BufferedImage bi = rdr.read(0);
        System.out.println("read ok");
        int dataType = bi.getType();
        System.out.println("type = " + dataType);
        iter = ImageIO.getImageWritersByFormatName("DICOM");
        DcmImageWriter writer = (DcmImageWriter)iter.next();
        writer.setOutput(ImageIO.createImageOutputStream(new File("/home/joe/work/dicom/dicom-images/MR001.dcm.out")));
        DcmImageWriteParam wparam = (DcmImageWriteParam)writer.getDefaultWriteParam();
        wparam.setWriteAlwaysRGB(true);
        wparam.setWriteIndexedAsRGB(false);
        wparam.setMONOCHROME2(true);
        DcmMetadata dcmmd = (DcmMetadata)writer.getDefaultStreamMetadata(wparam);
        dcmmd.setFromTree("dcm4che_imageio_dicom_1.0", doc);
        writer.write(dcmmd, new IIOImage(bi, null, null), wparam);
        System.out.println("write ok");
    }

    static {
        DS_MASK.putPN(0x100010);
        DS_MASK.putLO(0x100020);
        DS_MASK.putDA(0x100030);
        DS_MASK.putCS(0x100040);
        DS_MASK.putUI(0x20000D);
        DS_MASK.putDA(524320);
        DS_MASK.putTM(524336);
        DS_MASK.putPN(524432);
        DS_MASK.putSH(0x200010);
        DS_MASK.putSH(524368);
        DS_MASK.putCS(524384);
        DS_MASK.putUI(0x20000E);
        DS_MASK.putIS(0x200011);
        DS_MASK.putCS(0x200060);
        DS_MASK.putCS(524388);
        DS_MASK.putCS(524384);
        DS_MASK.putLO(0x181010);
        DS_MASK.putLO(1576982);
        DS_MASK.putLO(0x181018);
        DS_MASK.putLO(1576985);
        DS_MASK.putSH(1576994);
        DS_MASK.putLO(1576995);
        DS_MASK.putIS(2097171);
        DS_MASK.putCS(0x200020);
        DS_MASK.putDA(524323);
        DS_MASK.putTM(524339);
        DS_MASK.putUS(0x280002);
        DS_MASK.putCS(2621444);
        DS_MASK.putUS(2621456);
        DS_MASK.putUS(2621457);
        DS_MASK.putUS(2621696);
        DS_MASK.putUS(2621697);
        DS_MASK.putUS(2621698);
        DS_MASK.putUS(2621699);
        DS_MASK.putOB(2145386512);
        DS_MASK.putUS(2621446);
        DS_MASK.putIS(2621492);
        DS_MASK.putSS(2621702);
        DS_MASK.putSS(2621703);
        DS_MASK.putXX(2625793);
        DS_MASK.putXX(2625794);
        DS_MASK.putXX(2625795);
        DS_MASK.putXX(2626049);
        DS_MASK.putXX(2626050);
        DS_MASK.putXX(2626051);
        DS_MASK.putDA(1576978);
        DS_MASK.putTM(1576980);
        DS_MASK.putDS(2625618);
        DS_MASK.putDS(2625619);
        DS_MASK.putLO(2625620);
        DS_MASK.putDS(2625616);
        DS_MASK.putDS(2625617);
        DS_MASK.putLO(2625621);
        DS_MASK.putUI(524310);
        DS_MASK.putUI(524312);
    }
}

