/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWarningListener;
import fr.apteryx.imageio.dicom.Tag;
import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.util.Collection;
import javax.imageio.IIOImage;

abstract class Util {
    Util() {
    }

    static int getNumBands(Object object) {
        return Util.getSampleModel(object).getNumBands();
    }

    static SampleModel getSampleModel(Object object) {
        if (object instanceof Collection) {
            return Util.getSampleModel(((Collection)object).iterator().next());
        }
        IIOImage iIOImage = (IIOImage)object;
        return iIOImage.hasRaster() ? iIOImage.getRaster().getSampleModel() : iIOImage.getRenderedImage().getSampleModel();
    }

    static ColorModel getColorModel(Object object) {
        if (object instanceof Collection) {
            return Util.getColorModel(((Collection)object).iterator().next());
        }
        IIOImage iIOImage = (IIOImage)object;
        return iIOImage.hasRaster() ? null : iIOImage.getRenderedImage().getColorModel();
    }

    static short[] toShortArray(Object object) {
        if (object instanceof short[]) {
            return (short[])object;
        }
        if (object instanceof Number[]) {
            Number[] numberArray = (Number[])object;
            short[] sArray = new short[numberArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = numberArray[i].shortValue();
            }
            return sArray;
        }
        return null;
    }

    static SampleModel convertSampleModel(SampleModel sampleModel, int n) {
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
            sampleModel = new PixelInterleavedSampleModel(n, pixelInterleavedSampleModel.getWidth(), pixelInterleavedSampleModel.getHeight(), pixelInterleavedSampleModel.getPixelStride(), pixelInterleavedSampleModel.getScanlineStride(), pixelInterleavedSampleModel.getBandOffsets());
        } else if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            sampleModel = new BandedSampleModel(n, bandedSampleModel.getWidth(), bandedSampleModel.getHeight(), bandedSampleModel.getScanlineStride(), bandedSampleModel.getBankIndices(), bandedSampleModel.getBandOffsets());
        }
        return sampleModel;
    }

    static Raster convertRaster(Raster raster, int n) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getDataType() == n) {
            return raster;
        }
        SampleModel sampleModel2 = Util.convertSampleModel(sampleModel, n);
        DataBuffer dataBuffer = raster.getDataBuffer();
        dataBuffer = new DataBufferUShort(Util.getBankData(dataBuffer), dataBuffer.getSize(), dataBuffer.getOffsets());
        return Raster.createWritableRaster(sampleModel2, dataBuffer, new Point(raster.getMinX(), raster.getMinY()));
    }

    private static short[][] getBankData(DataBuffer dataBuffer) {
        return dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getBankData() : ((DataBufferUShort)dataBuffer).getBankData();
    }

    static void genericStatus(DataSet dataSet, DicomWarningListener dicomWarningListener) throws DicomException {
        String string;
        int n = dataSet.findInt(2304);
        String string2 = dataSet.findString(2306);
        if (string2 == null) {
            string2 = "No additionnal message";
        }
        string = (string = dataSet.findString(4096)) == null ? "SOP instance not specified" : "SOP instance " + string;
        String string3 = dataSet.findString(2);
        string3 = string3 == null ? "SOP class not specified" : "SOP class " + string3;
        String string4 = "Attribute list: " + Tag.tagListToString(dataSet.find(4101));
        switch (n) {
            case 65024: {
                throw new DicomException("ServiceError", "Canceled");
            }
            case 290: {
                throw new DicomException("ServiceRefused", "SOP class not supported (" + string2 + ')');
            }
            case 281: {
                String string5 = dataSet.findString(3);
                String string6 = dataSet.findString(4097);
                throw new DicomException("ServiceError", "Class-instance conflict" + (string5 != null && string6 != null ? " (" + string6 + " not an instance of " + string5 + ")" : ""));
            }
            case 273: {
                throw new DicomException("ServiceError", "Duplicate SOP instance (" + string + ")");
            }
            case 528: {
                throw new DicomException("ServiceError", "Duplicate invocation");
            }
            case 277: {
                throw new DicomException("ServiceError", "Invalid argument value (" + string + ", " + string3 + ")");
            }
            case 262: {
                throw new DicomException("ServiceError", "Invalid attribute value");
            }
            case 279: {
                throw new DicomException("ServiceError", "Invalid object instance (" + string + ")");
            }
            case 288: {
                throw new DicomException("ServiceError", "Missing attribute (" + string4 + ")");
            }
            case 289: {
                throw new DicomException("ServiceError", "Missing attribute value");
            }
            case 530: {
                throw new DicomException("ServiceError", "Mistyped argument");
            }
            case 276: {
                throw new DicomException("ServiceError", "No such argument (" + string3 + ")");
            }
            case 261: {
                throw new DicomException("ServiceError", "No such attribute (" + string4 + ")");
            }
            case 275: {
                throw new DicomException("ServiceError", "No such event type (" + string3 + ")");
            }
            case 274: {
                throw new DicomException("ServiceError", "No such object instance (" + string + ")");
            }
            case 280: {
                throw new DicomException("ServiceError", "No such SOP class (" + string3 + ")");
            }
            case 272: {
                Object object = dataSet.findValue(2307, Object.class);
                throw new DicomException("ServiceError", "Processing failure (" + string2 + ", " + string3 + ", " + string + (object == null ? ")" : ", error code " + object + ")"));
            }
            case 531: {
                throw new DicomException("ServiceError", "Resource limitation");
            }
            case 529: {
                throw new DicomException("ServiceError", "Unrecognized operation");
            }
            case 291: {
                throw new DicomException("ServiceError", "No such action type (" + string3 + ")");
            }
            case 263: {
                if (dicomWarningListener != null) {
                    dicomWarningListener.warning("ServiceWarning", "attribute list error (" + string4 + ")");
                }
                return;
            }
            case 278: {
                if (dicomWarningListener != null) {
                    dicomWarningListener.warning("ServiceWarning", "attribute value out of range");
                }
                return;
            }
        }
        throw new DicomException("ServiceError", "Unknown status code " + Integer.toHexString(n));
    }
}

