package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import open.dolphin.queries.DolphinQuery;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 患者 MEMO:マッピング d_patient
 * PatientModel generated by hbm2java
 */
public class PatientModel extends InfoModel implements IPatientModel {

    private long id;
    private String facilityId;//施設ID
    private String patientId;//患者ID
    private String familyName;
    private String givenName;
    private String fullName;
    private String kanaFamilyName;
    private String kanaGivenName;
    private String kanaName;
    private String romanFamilyName;
    private String romanGivenName;
    private String romanName;
    private String gender;//性別
    private String genderDesc;//性別説明
    @Transient
    private String genderCodeSys;//性別説明体系
    private String birthday;//生年月日
    private String nationality;
    @Transient
    private String nationalityDesc;
    @Transient
    private String nationalityCodeSys;
    private String maritalStatus;
    @Transient
    private String maritalStatusDesc;
    @Transient
    private String maritalStatusCodeSys;
    private byte[] jpegPhoto;
    private String memo;
    @Embedded
    private SimpleAddressModel address;//住所
    private String telephone;//電話番号
    private String mobilePhone;
    private String email;
    private Set<HealthInsuranceModel> healthInsurances;
    @Transient
    private List<PVTHealthInsuranceModel> pvtHealthInsurances;
    @Transient
    private List<AddressModel> addresses;
    @Transient
    private List<TelephoneModel> telephones;

    /**
     *
     */
    public PatientModel() {
        healthInsurances = new LinkedHashSet<HealthInsuranceModel>();
        pvtHealthInsurances = new ArrayList<PVTHealthInsuranceModel>(2);
        telephones = new ArrayList<TelephoneModel>(1);
        addresses = new ArrayList<AddressModel>(1);
    }

    /**
     * 検索 MEMO:何もしない
     * @param query
     * @return false
     */
    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    /**
     * idのGetter
     * @return
     */
    public long getId() {
        return id;
    }

    /**
     * idのSetter
     * @param id
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * 施設IDのGetter
     * @return 施設ID
     */
    public String getFacilityId() {
        return facilityId;
    }

    /**
     * 施設IDのSetter
     * @param facilityId 施設ID
     */
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    /**
     * 患者IDのSetter
     * @param patientId 患者ID
     */
    @Override
    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    /**
     * 患者IDのGetter
     * @return 患者ID
     */
    @Override
    public String getPatientId() {
        return patientId;
    }

    /**
     * familyNameのSetter
     * @param sirName
     */
    public void setFamilyName(String sirName) {
        this.familyName = sirName;
    }

    /**
     * familyNameのGetter
     * @return
     */
    public String getFamilyName() {
        return familyName;
    }

    /**
     * givenNameのSetter
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /**
     * givenNameのGetter
     * @return
     */
    public String getGivenName() {
        return givenName;
    }

    /**
     * fullNameのSetter
     * @param name
     */
    @Override
    public void setFullName(String name) {
        this.fullName = name;
    }

    /**
     * fullNameのGetter
     * @return
     */
    @Override
    public String getFullName() {
        return fullName;
    }

    /**
     * kanaFamilyNameのSetter
     * @param kanaSirName
     */
    public void setKanaFamilyName(String kanaSirName) {
        this.kanaFamilyName = kanaSirName;
    }

    /**
     * kanaFamilyNameのGetter
     * @return
     */
    public String getKanaFamilyName() {
        return kanaFamilyName;
    }

    /**
     * kanaGivenNameのSetter
     * @param kanaGivenName
     */
    public void setKanaGivenName(String kanaGivenName) {
        this.kanaGivenName = kanaGivenName;
    }

    /**
     * kanaGivenNameのGetter
     * @return
     */
    public String getKanaGivenName() {
        return kanaGivenName;
    }

    /**
     * kanaNameのSetter
     * @param kanaName
     */
    public void setKanaName(String kanaName) {
        this.kanaName = kanaName;
    }

    /**
     * kanaNameのGetter
     * @return
     */
    public String getKanaName() {
        return kanaName;
    }

    /**
     * romanFamilyNameのSetter
     * @param romanSirName
     */
    public void setRomanFamilyName(String romanSirName) {
        this.romanFamilyName = romanSirName;
    }

    /**
     * romanFamilyNameのGetter
     * @return
     */
    public String getRomanFamilyName() {
        return romanFamilyName;
    }

    /**
     * romanGivenNameのSetter
     * @param romanGivenName
     */
    public void setRomanGivenName(String romanGivenName) {
        this.romanGivenName = romanGivenName;
    }

    /**
     * romanGivenNameのGetter
     * @return
     */
    public String getRomanGivenName() {
        return romanGivenName;
    }

    /**
     * romanNameのSetter
     * @param romanName
     */
    public void setRomanName(String romanName) {
        this.romanName = romanName;
    }

    /**
     * romanNameのGetter
     * @return
     */
    public String getRomanName() {
        return romanName;
    }

    /**
     * 性別のSetter
     * @param gender 性別 MALE = "male" FEMALE = "female"
     */
    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    /**
     * 性別のGetter
     * @return 性別 MALE = "male" FEMALE = "female"
     */
    @Override
    public String getGender() {
        return gender;
    }

    /**
     * 性別説明のSetter
     * @param genderDesc 性別説明
     */
    @Override
    public void setGenderDesc(String genderDesc) {
        this.genderDesc = genderDesc;
    }

    /**
     * 性別説明のGetter
     * @return 性別説明
     */
    @Override
    public String getGenderDesc() {
        return genderDesc != null
                ? genderDesc
                : ModelUtils.getGenderDesc(gender);
    }

    /**
     * 性別説明体系のSetter
     * @param genderCodeSys 性別説明体系
     */
    @Override
    public void setGenderCodeSys(String genderCodeSys) {
        this.genderCodeSys = genderCodeSys;
    }

    /**
     * 性別説明体系のGetter
     * @return 性別説明体系
     */
    @Override
    public String getGenderCodeSys() {
        return genderCodeSys;
    }

    /**
     * 生年月日のSetter
     * @param birthday 生年月日 yyyy-MM-dd
     */
    @Override
    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    /**
     * 生年月日のGetter
     * @return 生年月日 yyyy-MM-dd
     */
    @Override
    public String getBirthday() {
        return birthday;
    }

    /**
     * ageBirthdayのGetter
     * @return
     */
    public String getAgeBirthday() {
        return ModelUtils.getAgeBirthday(birthday);
    }

    /**
     * nationalityのSetter
     * @param nationality
     */
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    /**
     * nationalityのGetter
     * @return
     */
    public String getNationality() {
        return nationality;
    }

    /**
     * nationalityDescのSetter
     * @param nationalityDesc
     */
    public void setNationalityDesc(String nationalityDesc) {
        this.nationalityDesc = nationalityDesc;
    }

    /**
     * nationalityDescのGetter
     * @return
     */
    public String getNationalityDesc() {
        return nationalityDesc;
    }

    /**
     * nationalityCodeSysのSetter
     * @param nationalityCodeSys
     */
    public void setNationalityCodeSys(String nationalityCodeSys) {
        this.nationalityCodeSys = nationalityCodeSys;
    }

    /**
     * nationalityCodeSysのGetter
     * @return
     */
    public String getNationalityCodeSys() {
        return nationalityCodeSys;
    }

    /**
     * maritalStatusのSetter
     * @param maritalStatus
     */
    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    /**
     * maritalStatusのGetter
     * @return
     */
    public String getMaritalStatus() {
        return maritalStatus;
    }

    /**
     * maritalStatusDescのSetter
     * @param maritalStatusDesc
     */
    public void setMaritalStatusDesc(String maritalStatusDesc) {
        this.maritalStatusDesc = maritalStatusDesc;
    }

    /**
     * maritalStatusDescのGetter
     * @return
     */
    public String getMaritalStatusDesc() {
        return maritalStatusDesc;
    }

    /**
     * maritalStatusCodeSysのSetter
     * @param maritalStatusCodeSys
     */
    public void setMaritalStatusCodeSys(String maritalStatusCodeSys) {
        this.maritalStatusCodeSys = maritalStatusCodeSys;
    }

    /**
     * maritalStatusCodeSysのGetter
     * @return
     */
    public String getMaritalStatusCodeSys() {
        return maritalStatusCodeSys;
    }

    /**
     * jpegPhotoのSetter
     * @param jpegPhoto
     */
    public void setJpegPhoto(byte[] jpegPhoto) {
        this.jpegPhoto = jpegPhoto;
    }

    /**
     * jpegPhotoのGetter
     * @return
     */
    public byte[] getJpegPhoto() {
        return jpegPhoto;
    }

    /**
     * memoのSetter
     * @param memo
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * memoのGetter
     * @return
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 住所のGetter
     * @return 住所
     */
    public SimpleAddressModel getAddress() {
        return address;
    }

    /**
     * 住所のSetter
     * @param address 住所
     */
    public void setAddress(SimpleAddressModel address) {
        this.address = address;
    }

    /**
     *
     * @return
     */
    public String contactZipCode() {
        return (address != null) ? address.getZipCode() : null;
    }

    /**
     *
     * @return
     */
    public String contactAddress() {
        return (address != null) ? address.getAddress() : null;
    }

    /**
     * 電話番号のGetter
     * @return 電話番号
     */
    public String getTelephone() {
        return telephone;
    }

    /**
     * 電話番号のSetter
     * @param telephone 電話番号
     */
    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    /**
     * mobilePhoneのGetter
     * @return
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * mobilePhoneのSetter
     * @param mobilePhone
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    /**
     * emailのGetter
     * @return
     */
    public String getEmail() {
        return email;
    }

    /**
     * emailのSetter
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * healthInsurancesのSetter
     * @param healthInsurances
     */
    public void setHealthInsurances(Set<HealthInsuranceModel> healthInsurances) {
        this.healthInsurances = healthInsurances;
        if (this.healthInsurances != null) {
            for (HealthInsuranceModel insurance : this.healthInsurances) {
                insurance.setPatient(this);
            }
        }
    }

    /**
     * healthInsurancesのGetter
     * @return
     */
    public Set<HealthInsuranceModel> getHealthInsurances() {
        return healthInsurances;
    }

    /**
     * healthInsurancesのAdder
     * @param healthInsurance
     */
    public void addHealthInsurance(HealthInsuranceModel healthInsurance) {
        if (healthInsurances == null) {
            healthInsurances = new LinkedHashSet<HealthInsuranceModel>();
        }
        healthInsurances.add(healthInsurance);
    }

    /**
     * pvtHealthInsurancesのGetter
     * @return
     */
    public List<PVTHealthInsuranceModel> getPvtHealthInsurances() {
        return pvtHealthInsurances;
    }

    /**
     * pvtHealthInsurancesのSetter
     * @param pvtHealthInsurances
     */
    public void setPvtHealthInsurances(List<PVTHealthInsuranceModel> pvtHealthInsurances) {
        this.pvtHealthInsurances = pvtHealthInsurances;
    }

    /**
     * pvtHealthInsurancesのAdder
     * @param model
     */
    public void addPvtHealthInsurance(PVTHealthInsuranceModel model) {
        //    if (pvtHealthInsurances == null) {
        //        pvtHealthInsurances = new ArrayList<PVTHealthInsuranceModel>(2);
        //     }
        pvtHealthInsurances.add(model);
    }

    /**
     * addressesのGetter
     * @return
     */
    public List<AddressModel> getAddresses() {
        return addresses;
    }

    /**
     * addressesのSetter
     * @param addresses
     */
    public void setAddresses(List<AddressModel> addresses) {
        this.addresses = addresses;
    }

    /**
     * 住所のAdder
     * @param address 住所
     */
    public void addAddress(AddressModel address) {
        //    if (addresses == null) {
        //         addresses = new ArrayList<AddressModel>(1);
        //    }
        addresses.add(address);
    }

    /**
     * telephonesのGetter
     * @return
     */
    public List<TelephoneModel> getTelephones() {
        return telephones;
    }

    /**
     * telephonesのSetter
     * @param telephones
     */
    public void setTelephones(List<TelephoneModel> telephones) {
        this.telephones = telephones;
    }

    /**
     * 電話番号のAdder
     * @param telephone 電話番号
     */
    public void addTelephone(TelephoneModel telephone) {
        //      if (telephones == null) {
        //       telephones = new ArrayList<TelephoneModel>(1);
        //   }
        telephones.add(telephone);
    }

    /**
     *
     * @return
     */
    public PatientLiteModel patientAsLiteModel() {
        PatientLiteModel model = new PatientLiteModel();
        model.setPatientId(getPatientId());
        model.setFullName(getFullName());
        model.setGender(getGender());
        model.setGenderDesc(getGenderDesc());
        model.setGenderCodeSys(getGenderCodeSys());
        model.setBirthday(getBirthday());
        return model;
    }

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     *
     * @return
     */
    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    /**
     *
     * @param obj
     * @return
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PatientModel other = (PatientModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}
