/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JTATransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)JTATransaction.class);
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean begun;
    private boolean commitFailed;
    private boolean commitSucceeded;
    private boolean callback;
    private static final int NULL = Integer.MIN_VALUE;

    public JTATransaction(InitialContext context, String utName, JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
        log.debug((Object)("Looking for UserTransaction under: " + utName));
        try {
            this.ut = (UserTransaction)context.lookup(utName);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)ne);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", ne);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug((Object)"begin");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                this.ut.begin();
                log.debug((Object)"Began a new JTA transaction");
            }
        }
        catch (Exception e) {
            log.error((Object)"JTA transaction begin failed", (Throwable)e);
            throw new TransactionException("JTA transaction begin failed", e);
        }
        boolean synchronization = this.jdbcContext.registerSynchronizationIfPossible();
        if (!this.newTransaction && !synchronization) {
            log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        if (!synchronization) {
            this.callback = this.jdbcContext.registerCallbackIfNecessary();
        }
        this.begun = true;
        this.commitSucceeded = false;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean flush;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        boolean bl = flush = !this.transactionContext.isFlushModeNever() && (this.callback || !this.transactionContext.isFlushBeforeCompletionEnabled());
        if (flush) {
            this.transactionContext.managedFlush();
        }
        if (this.callback && this.newTransaction) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
        if (this.newTransaction) {
            try {
                this.ut.commit();
                this.commitSucceeded = true;
                log.debug((Object)"Committed JTA UserTransaction");
            }
            catch (Exception e) {
                this.commitFailed = true;
                log.error((Object)"JTA commit failed", (Throwable)e);
                throw new TransactionException("JTA commit failed: ", e);
            }
            finally {
                this.afterCommitRollback();
            }
        } else {
            this.afterCommitRollback();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun && !this.commitFailed) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            this.closeIfRequired();
        }
        catch (Exception e) {
            log.error((Object)"could not close session during rollback", (Throwable)e);
        }
        try {
            if (this.newTransaction) {
                if (!this.commitFailed) {
                    this.ut.rollback();
                    log.debug((Object)"Rolled back JTA UserTransaction");
                }
            } else {
                this.ut.setRollbackOnly();
                log.debug((Object)"set JTA UserTransaction to rollback only");
            }
        }
        catch (Exception e) {
            log.error((Object)"JTA rollback failed", (Throwable)e);
            throw new TransactionException("JTA rollback failed", e);
        }
        finally {
            this.afterCommitRollback();
        }
    }

    private void afterCommitRollback() throws TransactionException {
        this.begun = false;
        if (this.callback) {
            if (!this.newTransaction) {
                log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
            int status = Integer.MIN_VALUE;
            try {
                status = this.ut.getStatus();
                this.jdbcContext.afterTransactionCompletion(status == 3, this);
            }
            catch (Exception e) {
                try {
                    log.error((Object)"Could not determine transaction status after commit", (Throwable)e);
                    throw new TransactionException("Could not determine transaction status after commit", e);
                }
                catch (Throwable throwable) {
                    this.jdbcContext.afterTransactionCompletion(status == 3, this);
                    throw throwable;
                }
            }
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(status);
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public boolean isActive() throws TransactionException {
        int status;
        if (!this.begun || this.commitFailed || this.commitSucceeded) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 0;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (this.getTransactionManager() == null) {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization", e);
        }
    }

    private TransactionManager getTransactionManager() {
        return this.transactionContext.getFactory().getTransactionManager();
    }

    private void closeIfRequired() throws HibernateException {
        boolean close;
        boolean bl = close = this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed();
        if (close) {
            this.transactionContext.managedClose();
        }
    }

    public void setTimeout(int seconds) {
        try {
            this.ut.setTransactionTimeout(seconds);
        }
        catch (SystemException se) {
            throw new TransactionException("could not set transaction timeout", (Exception)((Object)se));
        }
    }

    protected UserTransaction getUserTransaction() {
        return this.ut;
    }
}

