/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.service.remote;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityExistsException;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.RadiologyMethodValue;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.service.DolphinService;
import open.dolphin.service.ISystemService;
import org.hibernate.HibernateException;

public class RemoteSystemService
extends DolphinService
implements ISystemService {
    private static final String DEFAULT_FACILITY_OID = "1.3.6.1.4.1.9414.10.1";

    @Override
    public String helloDolphin() {
        return "Hello, OpenDolphin";
    }

    @Override
    public void addFacilityAdmin(UserModel user) {
        block9: {
            FacilityModel facilityModel;
            FacilityModel facility = user.getFacility();
            String facilityId = facility.getFacilityId();
            if (facilityId == null || facilityId.equals("")) {
                facilityId = DEFAULT_FACILITY_OID;
                facility.setFacilityId(facilityId);
            }
            if ((facilityModel = (FacilityModel)this.getSession().createQuery("from FacilityModel f where f.facilityId = :fid").setParameter("fid", (Object)facilityId).uniqueResult()) != null) {
                throw new EntityExistsException();
            }
            try {
                RoleModel role;
                this.startTransaction();
                this.getSession().persist((Object)facility);
                StringBuilder sb = new StringBuilder();
                sb.append(facilityId);
                sb.append(":");
                sb.append(user.getUserId());
                user.setUserId(sb.toString());
                this.getSession().persist((Object)user);
                boolean hasAdminRole = false;
                boolean hasUserRole = false;
                Set<RoleModel> roles = user.getRoles();
                if (roles != null) {
                    for (RoleModel val : roles) {
                        if (val.getRole().equals("admin")) {
                            hasAdminRole = true;
                            continue;
                        }
                        if (!val.getRole().equals("user")) continue;
                        hasUserRole = true;
                    }
                }
                if (!hasAdminRole) {
                    role = new RoleModel();
                    role.setRole("admin");
                    role.setUser(user);
                    role.setUserId(user.getUserId());
                    this.getSession().persist((Object)role);
                    user.addRole(role);
                }
                if (!hasUserRole) {
                    role = new RoleModel();
                    role.setRole("user");
                    role.setUser(user);
                    role.setUserId(user.getUserId());
                    this.getSession().persist((Object)role);
                    user.addRole(role);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block9;
                this.getSession().getTransaction().rollback();
            }
        }
    }

    @Override
    public void putRadMethodMaster(List<RadiologyMethodValue> methods) {
        block4: {
            if (methods == null) {
                return;
            }
            try {
                this.startTransaction();
                for (RadiologyMethodValue method : methods) {
                    this.getSession().persist((Object)method);
                }
                this.endTransaction();
            }
            catch (HibernateException e) {
                if (!this.getSession().getTransaction().isActive()) break block4;
                this.getSession().getTransaction().rollback();
            }
        }
    }
}

