/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.IStampModelEditor;
import open.dolphin.client.SymptomsDialog;
import open.dolphin.container.Pair;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.helper.NumericDocument;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SinryoCode;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.order.CommentHelper;
import open.dolphin.order.MMLTable;
import open.dolphin.order.MasterItemTransferHandler;
import open.dolphin.order.SetTableStateMgr;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.table.OddEvenRowRendererWithExpire;

public class ItemTablePanel
extends JPanel
implements PropertyChangeListener {
    protected static final String DEFAULT_STAMP_NAME = "\u65b0\u898f\u30b9\u30bf\u30f3\u30d7";
    private static final String FROM_EDITOR_STAMP_NAME = "\u30a8\u30c7\u30a3\u30bf\u304b\u3089";
    private static final String DEFAULT_NUMBER = "1";
    private static final String[] COLUMN_NAMES = new String[]{"\u30b3\u30fc\u30c9", "\u8a3a\u7642\u5185\u5bb9", "\u6570 \u91cf", "\u5358 \u4f4d"};
    private static final String[] METHOD_NAMES = new String[]{"getCode", "getName", "getNumber", "getUnit"};
    private static final int[] COLUMN_WIDTH = new int[]{50, 200, 10, 10};
    private static final int NUM_ROWS = 0;
    private static final String TOOLTIP_DND = "\u30c9\u30e9\u30c3\u30b0 & \u30c9\u30ed\u30c3\u30d7\u3067\u9806\u756a\u3092\u5165\u308c\u66ff\u3048\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002";
    private static final int SRYCD_COLUMN = 0;
    private static final int NUMBER_COLUMN = 2;
    private boolean findClaimClassCode;
    private String orderName;
    private String classCode;
    private String classCodeId;
    private String subclassCodeId;
    private String entity;
    private ObjectReflectTableModel<Object> tableModel;
    private IStampModelEditor parent;
    private boolean validModel;
    private SetTableStateMgr stateMgr;
    private JPanel bp;
    private JButton clearButton;
    private JTextField commentField;
    private JButton editButton;
    private JPanel infoP;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JComboBox numberCombo;
    private JButton removeButton;
    private JScrollPane scroller;
    private JTable setTable;
    private JPanel south;
    private JTextField stampNameField;

    public ItemTablePanel(IStampModelEditor parent) {
        this.initComponents();
        this.scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.parent = parent;
        this.tableModel = new ObjectReflectTableModel<Object>(COLUMN_NAMES, 0, METHOD_NAMES, null){

            @Override
            public boolean isCellEditable(int row, int col) {
                String cd = (String)ItemTablePanel.this.tableModel.getValueAt(row, 0);
                if (SinryoCode.isComment(cd)) {
                    return false;
                }
                return col == 2;
            }

            @Override
            public void setValueAt(Object o, int row, int col) {
                if (o != null) {
                    if (o instanceof String) {
                        if (((String)o).trim().equals("")) {
                            o = new String("0");
                        }
                    } else {
                        super.setValueAt(o, row, col);
                    }
                }
                MasterItem mItem = (MasterItem)this.getObject(row);
                if (col == 2 && mItem != null) {
                    mItem.setNumber((String)o);
                    ItemTablePanel.this.stateMgr.checkState();
                }
            }
        };
        this.setTable.setModel(this.tableModel);
        this.setTable.setTransferHandler(new MasterItemTransferHandler());
        this.setTable.setSelectionMode(0);
        this.setTable.setRowSelectionAllowed(true);
        ListSelectionModel m = this.setTable.getSelectionModel();
        m.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ItemTablePanel.this.notifySelectedRow();
                }
            }
        });
        this.setTable.setToolTipText(TOOLTIP_DND);
        this.setTable.setDefaultRenderer(Object.class, new OddEvenRowRendererWithExpire());
        TableColumn column = null;
        if (COLUMN_WIDTH != null) {
            int len = COLUMN_WIDTH.length;
            for (int i = 0; i < len; ++i) {
                column = this.setTable.getColumnModel().getColumn(i);
                column.setPreferredWidth(COLUMN_WIDTH[i]);
            }
        }
        JTextField volumeEditor = new JTextField();
        volumeEditor.addFocusListener(AutoRomanListener.getInstance());
        volumeEditor.setDocument(new NumericDocument());
        column = this.setTable.getColumnModel().getColumn(2);
        DefaultCellEditor de = new DefaultCellEditor(volumeEditor);
        int ccts = GlobalVariables.getPreferences().getInt("order.table.clickCountToStart", 2);
        de.setClickCountToStart(ccts);
        column.setCellEditor(de);
        this.commentField.addFocusListener(AutoKanjiListener.getInstance());
        this.stampNameField.addFocusListener(AutoKanjiListener.getInstance());
        if (parent.getContext().getOkButton() != null) {
            this.bp.add(parent.getContext().getOkButton());
        }
        this.south.add(this.infoP);
        this.south.add(Box.createHorizontalGlue());
        this.south.add(this.bp);
        this.setPreferredSize(new Dimension(680, 230));
        this.stateMgr = new SetTableStateMgr(this, this.setTable, this.removeButton, this.clearButton, this.stampNameField);
    }

    private void initComponents() {
        this.south = new JPanel();
        this.infoP = new JPanel();
        this.jLabel1 = new JLabel();
        this.stampNameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.numberCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.commentField = new JTextField();
        this.bp = new JPanel();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.clearButton = new JButton();
        this.scroller = new JScrollPane();
        this.setTable = new JTable();
        this.setLayout(new BorderLayout(5, 0));
        this.south.setName("south");
        this.south.setLayout(new BoxLayout(this.south, 0));
        this.infoP.setName("infoP");
        this.infoP.setLayout(new FlowLayout(0));
        this.jLabel1.setText("\u30bb\u30c3\u30c8\u540d");
        this.jLabel1.setName("jLabel1");
        this.infoP.add(this.jLabel1);
        this.stampNameField.setBackground(new Color(251, 239, 128));
        this.stampNameField.setColumns(10);
        this.stampNameField.setName("stampNameField");
        this.infoP.add(this.stampNameField);
        this.jLabel2.setText("\u56de \u6570");
        this.jLabel2.setName("jLabel2");
        this.infoP.add(this.jLabel2);
        this.numberCombo.setModel(new DefaultComboBoxModel<String>(new String[]{DEFAULT_NUMBER, "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"}));
        this.numberCombo.setName("numberCombo");
        this.infoP.add(this.numberCombo);
        this.jLabel3.setText("\u30e1 \u30e2");
        this.jLabel3.setName("jLabel3");
        this.infoP.add(this.jLabel3);
        this.commentField.setColumns(15);
        this.commentField.setName("commentField");
        this.infoP.add(this.commentField);
        this.south.add(this.infoP);
        this.bp.setName("bp");
        this.bp.setLayout(new FlowLayout(2));
        this.editButton.setText("\u7de8\u96c6");
        this.editButton.setToolTipText("\u30b3\u30e1\u30f3\u30c8\u30b3\u30fc\u30c9\u306e\u5834\u5408\u7de8\u96c6\u3067\u304d\u307e\u3059");
        this.editButton.setEnabled(false);
        this.editButton.setName("editButton");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        this.bp.add(this.editButton);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/del_16.gif")));
        this.removeButton.setToolTipText("\u9078\u629e\u3057\u305f\u30a2\u30a4\u30c6\u30e0\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        this.removeButton.setEnabled(false);
        this.removeButton.setName("removeButton");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.bp.add(this.removeButton);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/remov_16.gif")));
        this.clearButton.setToolTipText("\u30bb\u30c3\u30c8\u5185\u5bb9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059\u3002");
        this.clearButton.setEnabled(false);
        this.clearButton.setName("clearButton");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemTablePanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.bp.add(this.clearButton);
        this.south.add(this.bp);
        this.add((Component)this.south, "South");
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setAutoscrolls(true);
        this.scroller.setName("scroller");
        this.setTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.setTable.setName("setTable");
        this.setTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ItemTablePanel.this.setTableMouseDragged(evt);
            }
        });
        this.scroller.setViewportView(this.setTable);
        this.add((Component)this.scroller, "Center");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedItem();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editSelectedItem();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void setTableMouseDragged(MouseEvent evt) {
        int ctrlMask = 128;
        int action = (evt.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
        JComponent c = (JComponent)evt.getSource();
        TransferHandler handler = c.getTransferHandler();
        handler.exportAsDrag(c, evt, action);
    }

    public void setValidModel(boolean valid) {
        this.validModel = valid;
        this.getMyParent().setValidModel(this.validModel);
    }

    private String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String val) {
        this.orderName = val;
    }

    private String getEntity() {
        return this.entity;
    }

    private void setEntity(String val) {
        this.entity = val;
    }

    public void setClassCode(String val) {
        this.classCode = val;
    }

    public void setClassCodeId(String val) {
        this.classCodeId = val;
    }

    public void setSubClassCodeId(String val) {
        this.subclassCodeId = val;
    }

    private IStampModelEditor getMyParent() {
        return this.parent;
    }

    private boolean isFindClaimClassCode() {
        return this.findClaimClassCode;
    }

    public void setFindClaimClassCode(boolean b) {
        this.findClaimClassCode = true;
    }

    private void setStampName(ModuleInfoBean moduleInfo) {
        String text = this.stampNameField.getText().trim();
        if (!text.equals("")) {
            moduleInfo.setStampName(text);
        } else {
            moduleInfo.setStampName(DEFAULT_STAMP_NAME);
        }
    }

    private String getClassCodeFromItems(MasterItem mItem) {
        String result = null;
        if (this.isFindClaimClassCode() && mItem.getClassCode() == 0 && mItem.getClaimClassCode() != null && !mItem.getClaimClassCode().trim().isEmpty()) {
            result = mItem.getClaimClassCode().equals("311") ? "310" : (mItem.getClaimClassCode().equals("321") ? "320" : (mItem.getClaimClassCode().equals("331") ? "330" : mItem.getClaimClassCode()));
        }
        return result;
    }

    private ClaimItem createClaimItem(MasterItem masterRecord) {
        ClaimItem result = new ClaimItem(masterRecord);
        if (masterRecord.getSstKijunCdSet() != null) {
            result.setSstKijunCdSet(masterRecord.getSstKijunCdSet());
        }
        result.setClassCode(String.valueOf(masterRecord.getClassCode()));
        result.setClassCodeSystem(this.subclassCodeId);
        String number = masterRecord.getNumber();
        if (number != null && !(number = number.trim()).isEmpty()) {
            result.setNumber(number);
            result.setUnit(masterRecord.getUnit());
            result.setNumberCode(this.getNumberCode(masterRecord.getClassCode()));
            result.setNumberCodeSystem("Claim004");
        }
        return result;
    }

    private void setBundleItem(List itemList, BundleDolphin bundle) {
        if (itemList != null) {
            boolean found = false;
            String jihiClassCode = null;
            for (MasterItem masterRecord : itemList) {
                String _classCode;
                bundle.addClaimItem(this.createClaimItem(masterRecord));
                if (!found && (_classCode = this.getClassCodeFromItems(masterRecord)) != null) {
                    this.classCode = _classCode;
                    found = true;
                }
                if (SinryoCode.isJihiHikazei(masterRecord.getCode())) {
                    jihiClassCode = "950";
                    continue;
                }
                if (!SinryoCode.isJihiKazei(masterRecord.getCode())) continue;
                jihiClassCode = "960";
            }
            if ((this.classCode == null || this.classCode.trim().isEmpty()) && jihiClassCode != null) {
                this.classCode = jihiClassCode;
            }
        }
    }

    private void setBandle(BundleDolphin bundle) {
        bundle.setOrderName(this.getOrderName());
        this.setMemo(bundle);
        bundle.setBundleNumber((String)this.numberCombo.getSelectedItem());
        bundle.setClassCode(this.classCode);
        bundle.setClassCodeSystem(this.classCodeId);
        bundle.setClassName(MMLTable.getClaimClassCodeName(this.classCode));
    }

    private void setMemo(BundleDolphin bundle) {
        String memo = this.commentField.getText();
        if (!memo.equals("")) {
            bundle.setMemo(memo);
        }
    }

    public Object getValue() {
        ModuleModel result = new ModuleModel();
        ModuleInfoBean moduleInfo = result.getModuleInfo();
        moduleInfo.setEntity(this.getEntity());
        moduleInfo.setStampRole("p");
        this.setStampName(moduleInfo);
        BundleDolphin bundle = new BundleDolphin();
        List<Object> itemList = this.tableModel.getObjectList();
        this.setBundleItem(itemList, bundle);
        this.setBandle(bundle);
        result.setModel(bundle);
        return result;
    }

    public void setValue(Object theStamp) {
        String number;
        Date now = new Date();
        this.clear();
        if (theStamp == null) {
            this.stateMgr.checkState();
            return;
        }
        ModuleModel target = (ModuleModel)theStamp;
        this.setEntity(target.getModuleInfo().getEntity());
        String stampName = target.getModuleInfo().getStampName();
        boolean serialized = target.getModuleInfo().isSerialized();
        if (!serialized && stampName.startsWith(FROM_EDITOR_STAMP_NAME)) {
            stampName = DEFAULT_STAMP_NAME;
        } else if (stampName.equals("")) {
            stampName = DEFAULT_STAMP_NAME;
        }
        this.stampNameField.setText(stampName);
        BundleDolphin bundle = (BundleDolphin)target.getModel();
        if (bundle == null) {
            return;
        }
        this.classCode = bundle.getClassCode();
        for (ClaimItem item : bundle.getClaimItem()) {
            String endDate;
            String val = item.getClassCode();
            MasterItem mItem = new MasterItem(Integer.parseInt(val), item);
            val = item.getNumber();
            if (val != null && !val.equals("")) {
                mItem.setNumber(val);
                val = item.getUnit();
                if (val != null) {
                    mItem.setUnit(val);
                }
            }
            if (item.getSstKijunCdSet() != null) {
                mItem.setSstKijunCdSet(item.getSstKijunCdSet());
            }
            if ((endDate = item.getEndDate()) != null && !endDate.equals("99999999") && !endDate.equals("")) {
                SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
                dao.getAlternateEntry(item.getCode(), collection);
                for (MedicineEntry updateEntry : collection) {
                    if (mItem.getCode().equals(updateEntry.getCode())) continue;
                    MasterItem updatedMasterItem = new MasterItem(Integer.parseInt(item.getClassCode()), updateEntry);
                    updatedMasterItem.setUnit(updateEntry.getUnit());
                    updatedMasterItem.setNumber("0");
                    updatedMasterItem.setYkzKbn(item.getYkzKbn());
                    this.tableModel.addRow(updatedMasterItem);
                }
            }
            this.tableModel.addRow(mItem);
            this.scrollToBottom(this.scroller);
        }
        String memo = bundle.getMemo();
        if (memo != null) {
            this.commentField.setText(memo);
        }
        if ((number = bundle.getBundleNumber()) != null && !number.equals("")) {
            this.numberCombo.setSelectedItem(number);
        }
        this.stateMgr.checkState();
    }

    private List<Pair<InteractEntry, SsKijyoEntry>> checkSymptom(SqlMasterDao dao, String importCode) {
        ArrayList<Pair<InteractEntry, SsKijyoEntry>> result = new ArrayList<Pair<InteractEntry, SsKijyoEntry>>();
        ArrayList<String> onStampCode = new ArrayList<String>();
        for (Object item : this.tableModel.getObjectList()) {
            onStampCode.add(((MasterItem)item).getCode());
        }
        dao.getSsKijyoEntry(importCode, onStampCode, result);
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        boolean hasError = false;
        if (prop.equals("selectedItemProp")) {
            CommentHelper ch;
            MasterItem item = (MasterItem)e.getNewValue();
            String textVal = this.stampNameField.getText().trim();
            if (SinryoCode.isComment(item.getCode()) && !(ch = new CommentHelper()).confirm(item)) {
                hasError = true;
            }
            if (item.getClassCode() != 0) {
                if (item.getClassCode() == 2) {
                    SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
                    boolean isCancel = false;
                    List<Pair<InteractEntry, SsKijyoEntry>> symptoms = this.checkSymptom(dao, item.getCode());
                    if (symptoms.size() != 0) {
                        SymptomsDialog symptomDialog = new SymptomsDialog((Frame)((JFrame)this.getRootPane().getParent()), true, dao, symptoms);
                        symptomDialog.setVisible(true);
                        isCancel = symptomDialog.IsCancel();
                        hasError = true;
                    }
                    if (!isCancel) {
                        String inputNum = DEFAULT_NUMBER;
                        if (item.getUnit() != null) {
                            String unit = item.getUnit();
                            if (unit.equals("\u9320")) {
                                inputNum = GlobalVariables.getPreferences().get("defaultZyozaiNum", "3");
                            } else if (unit.equals("\uff47")) {
                                inputNum = GlobalVariables.getPreferences().get("defaultSanyakuNum", "1.0");
                            } else if (unit.equals("\uff4d\uff2c")) {
                                inputNum = GlobalVariables.getPreferences().get("defaultMizuyakuNum", DEFAULT_NUMBER);
                            }
                        }
                        item.setNumber(inputNum);
                    }
                } else if (item.getClassCode() == 1) {
                    item.setNumber(DEFAULT_NUMBER);
                }
            }
            if (textVal.equals("") || textVal.equals(DEFAULT_STAMP_NAME)) {
                this.stampNameField.setText(item.getName());
            }
            if (!hasError) {
                this.tableModel.addRow(item);
                this.scrollToBottom(this.scroller);
                this.stateMgr.checkState();
            }
        } else if (prop.equals("radiologyProp")) {
            String text = (String)e.getNewValue();
            this.commentField.setText(text);
        }
    }

    private void notifySelectedRow() {
        int index = this.setTable.getSelectedRow();
        MasterItem item = (MasterItem)this.tableModel.getObject(index);
        this.removeButton.setEnabled(item != null);
        String s = item != null ? item.getCode() : null;
        this.editButton.setEnabled(SinryoCode.isComment(s));
    }

    public void clear() {
        this.tableModel.clear();
        this.stateMgr.checkState();
    }

    private void removeSelectedItem() {
        int row = this.setTable.getSelectedRow();
        if (this.tableModel.getObject(row) != null) {
            this.tableModel.deleteRow(row);
            this.stateMgr.checkState();
            if (this.tableModel.getObject(0) != null) {
                this.stampNameField.setText(((MasterItem)this.tableModel.getObject(0)).getName());
            } else {
                this.stampNameField.setText(DEFAULT_STAMP_NAME);
            }
        }
    }

    private void scrollToBottom(final JScrollPane pane) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pane.getVerticalScrollBar().setValue(pane.getVerticalScrollBar().getMaximum());
            }
        });
    }

    private void editSelectedItem() {
        int idx = this.setTable.getSelectedRow();
        MasterItem item = (MasterItem)this.tableModel.getObject(idx);
        if (item != null) {
            if (SinryoCode.isComment(item.getCode())) {
                CommentHelper ch = new CommentHelper();
                ch.confirm(item);
            }
            this.tableModel.fireTableDataChanged();
            this.stateMgr.checkState();
            if (this.tableModel.getObject(0) != null) {
                this.stampNameField.setText(((MasterItem)this.tableModel.getObject(0)).getName());
            } else {
                this.stampNameField.setText(DEFAULT_STAMP_NAME);
            }
        }
    }

    private String getNumberCode(int subclassCode) {
        return subclassCode == 1 ? "21" : "11";
    }
}

