/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.message;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class MessageBuilder {
    private static final String ENCODING = "SHIFT_JIS";
    private String templateFile;
    private String encoding = "SHIFT_JIS";

    public MessageBuilder() {
        LogWriter.debug(this.getClass(), "MessageBuilder constracted");
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(String templateFile) {
        this.templateFile = templateFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String build(String dml) {
        String ret = null;
        try {
            SAXBuilder sbuilder = new SAXBuilder();
            Document root = sbuilder.build((Reader)new BufferedReader(new StringReader(dml)));
            VelocityContext context = GlobalConstants.getVelocityContext();
            context.put("root", (Object)root);
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            InputStream instream = GlobalConstants.stub.getTemplateAsStream(this.templateFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, this.encoding));
            Velocity.evaluate((Context)context, (Writer)bw, (String)"MessageBuilder", (Reader)reader);
            bw.flush();
            bw.close();
            ret = sw.toString();
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
        return ret;
    }

    public String build(Object helper) {
        String ret = null;
        String name = helper.getClass().getName();
        int index = name.lastIndexOf(46);
        name = name.substring(index + 1);
        StringBuffer sb = new StringBuffer();
        sb.append(name.substring(0, 1).toLowerCase());
        sb.append(name.substring(1));
        name = sb.toString();
        try {
            VelocityContext context = GlobalConstants.getVelocityContext();
            context.put(name, helper);
            String tFile = name + ".vm";
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            InputStream instream = GlobalConstants.stub.getTemplateAsStream(tFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, ENCODING));
            Velocity.evaluate((Context)context, (Writer)bw, (String)name, (Reader)reader);
            bw.flush();
            bw.close();
            reader.close();
            ret = sw.toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }
}

