/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.KarteEntryBean;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.SchemaModel;

public class DocumentModel
extends KarteEntryBean {
    private DocInfoModel docInfo;
    private Set<ModuleModel> modules;
    private Set<SchemaModel> schemas;

    public DocumentModel() {
        this.setDocInfo(new DocInfoModel());
        this.getDocInfo().setDocType("karte");
    }

    public void toDetuch() {
        if (this.docInfo != null) {
            this.docInfo.setDocPk(this.getId());
            this.docInfo.setParentPk(this.getLinkId());
            this.docInfo.setConfirmDate(this.getConfirmed());
            this.docInfo.setFirstConfirmDate(this.getStarted());
            this.docInfo.setStatus(this.getStatus());
        }
    }

    public void toPersist() {
        if (this.docInfo != null) {
            this.setLinkId(this.docInfo.getParentPk());
            this.setLinkRelation(this.docInfo.getParentIdRelation());
            this.setConfirmed(this.docInfo.getConfirmDate());
            this.setFirstConfirmed(this.docInfo.getFirstConfirmDate());
            this.setStatus(this.docInfo.getStatus());
        }
    }

    public DocInfoModel getDocInfo() {
        return this.docInfo;
    }

    public void setDocInfo(DocInfoModel docInfo) {
        this.docInfo = docInfo;
    }

    public Set<SchemaModel> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Set<SchemaModel> images) {
        this.schemas = images;
    }

    public void addSchema(SchemaModel model) {
        if (this.schemas == null) {
            this.schemas = new HashSet<SchemaModel>();
        }
        this.schemas.add(model);
    }

    public void clearSchema() {
        if (this.schemas != null && this.schemas.size() > 0) {
            this.schemas.clear();
        }
    }

    public SchemaModel getSchema(int index) {
        if (this.schemas != null && this.schemas.size() > 0) {
            int cnt = 0;
            for (SchemaModel bean : this.schemas) {
                if (index == cnt) {
                    return bean;
                }
                ++cnt;
            }
        }
        return null;
    }

    public Set<ModuleModel> getModules() {
        return this.modules;
    }

    public void setModules(Set<ModuleModel> modules) {
        this.modules = modules;
    }

    public void addModule(ModuleModel[] addArray) {
        if (this.modules == null) {
            this.modules = new HashSet<ModuleModel>();
        }
        for (ModuleModel bean : addArray) {
            this.modules.add(bean);
        }
    }

    public void addModule(ModuleModel addModule) {
        if (this.modules == null) {
            this.modules = new HashSet<ModuleModel>();
        }
        this.modules.add(addModule);
    }

    public void clearModules() {
        if (this.modules != null && this.modules.size() > 0) {
            this.modules.clear();
        }
    }

    public ModuleModel getModule(String entityName) {
        if (this.modules != null) {
            ModuleModel ret = null;
            for (ModuleModel model : this.modules) {
                if (!model.getModuleInfo().getEntity().equals(entityName)) continue;
                ret = model;
                break;
            }
            return ret;
        }
        return null;
    }

    public ModuleInfoBean[] getModuleInfo(String entityName) {
        HashSet<ModuleInfoBean> result = new HashSet<ModuleInfoBean>(2);
        if (this.modules != null) {
            for (ModuleModel model : this.modules) {
                if (!model.getModuleInfo().getEntity().equals(entityName)) continue;
                result.add(model.getModuleInfo());
            }
            if (result.size() > 0) {
                return result.toArray(new ModuleInfoBean[result.size()]);
            }
        }
        return null;
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<DocumentModel>\n");
        super.serialize(result);
        if (this.docInfo != null) {
            this.docInfo.serialize(result);
        }
        if (this.modules != null) {
            result.append("<Modules>\n");
            for (ModuleModel module : this.modules) {
                module.serialize(result);
            }
            result.append("</Modules>\n");
        }
        if (this.schemas != null) {
            result.append("<Schemas>\n");
            for (SchemaModel _schema : this.schemas) {
                _schema.serialize(result);
            }
            result.append("</Schemas>\n");
        }
        result.append("</DocumentModel>\n");
    }
}

