/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.SinryoCode;
import open.dolphin.queries.DolphinQuery;

public class BundleDolphin
extends ClaimBundle {
    private static final long serialVersionUID = -8747202550129389855L;
    private String orderName;

    @Override
    public boolean search(DolphinQuery query) {
        if (super.search(query)) {
            return true;
        }
        if (this.orderName != null) {
            return this.orderName.indexOf(query.what("keyword")) != -1;
        }
        return false;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public String getOrderName() {
        return this.orderName;
    }

    public String getItemNames() {
        if (this.claimItems != null && this.claimItems.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.claimItems.length; ++i) {
                if (!sb.toString().isEmpty()) {
                    sb.append(", ");
                }
                sb.append(this.claimItems[i].getName());
                if (!SinryoCode.isComplexComment(this.claimItems[i].getCode())) continue;
                sb.append(" " + this.claimItems[i].getNumber());
            }
            return sb.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.orderName);
        buf.append("\n");
        ClaimItem[] items = this.getClaimItem();
        if (items != null) {
            for (ClaimItem item : items) {
                buf.append("\u30fb");
                buf.append(item.getName());
                String number = item.getNumber();
                if (number != null) {
                    buf.append("\u3000");
                    buf.append(number);
                    if (item.getUnit() != null) {
                        buf.append(item.getUnit());
                    }
                }
                buf.append("\n");
            }
            if (!this.getBundleNumber().equals("1")) {
                buf.append("X\u3000");
                buf.append(this.getBundleNumber());
                buf.append("\n");
            }
            if (this.adminMemo != null) {
                buf.append(this.adminMemo);
                buf.append("\n");
            }
            if (this.memo != null) {
                buf.append(this.memo);
                buf.append("\n");
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public void serialize(Writer result) throws IOException {
    }
}

