/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ProgressMonitor;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class TaskProgressMonitor
implements PropertyChangeListener {
    private Task task;
    private TaskMonitor taskMonitor;
    private ProgressMonitor monitor;

    public TaskProgressMonitor(Task task, TaskMonitor taskMonitor, Component c, Object message, String note, int min, int max) {
        this.task = task;
        this.taskMonitor = taskMonitor;
        this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.monitor = new ProgressMonitor(c, message, note, min, max);
        this.monitor.setMillisToDecideToPopup(300);
        this.monitor.setMillisToPopup(300);
        this.monitor.setProgress(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (!"started".equals(propertyName)) {
            if ("done".equals(propertyName)) {
                this.monitor.close();
                this.taskMonitor.removePropertyChangeListener((PropertyChangeListener)this);
            } else if ("message".equals(propertyName)) {
                String text = (String)e.getNewValue();
                this.monitor.setNote(text);
            } else if ("progress".equals(propertyName)) {
                if (!this.monitor.isCanceled()) {
                    int value = (Integer)e.getNewValue();
                    this.monitor.setProgress(value);
                } else {
                    this.task.cancel(true);
                }
            }
        }
    }
}

