/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ModelUtils;

public class KarteHeader {
    private DocumentModel model;
    private StringBuilder buffer = new StringBuilder();
    private String title;

    public KarteHeader(DocumentModel model, String title) {
        this.model = model;
        this.title = title;
    }

    public String toString() {
        this.buffer.append(this.title);
        this.buffer.append(" ");
        if (this.model.getDocInfo().getFirstConfirmDate() != null) {
            this.buffer.append(" \u4f5c\u6210[");
            this.buffer.append(ModelUtils.getDateAsFormatString(this.model.getDocInfo().getFirstConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm"));
            this.buffer.append(" ]");
        }
        if (this.model.getDocInfo().getConfirmDate() != null) {
            this.buffer.append(" \u66f4\u65b0[");
            this.buffer.append(ModelUtils.getDateAsFormatString(this.model.getDocInfo().getConfirmDate(), "yyyy-MM-dd'('EEE')'HH:mm"));
            this.buffer.append(" ]");
        }
        if (this.model.getCreator() != null) {
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getCommonName());
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getDepartmentModel().getDepartmentDesc());
            this.buffer.append(" ");
            this.buffer.append(this.model.getCreator().getLicenseModel().getLicenseDesc());
        }
        if (this.model.getDocInfo().getStatus().equals("T")) {
            this.buffer.append(" - \u4eee\u4fdd\u5b58\u4e2d");
        }
        return this.buffer.toString();
    }
}

