/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.component;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JSpinner spinner = new JSpinner(new SpinnerDateModel());
    private final JSpinner.DateEditor editor = new JSpinner.DateEditor(this.spinner, "yyyy-MM-dd");

    public SpinnerCellEditor() {
        this.spinner.setEditor(this.editor);
        this.setArrowButtonEnabled(false);
        this.spinner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SpinnerCellEditor.this.editor.getTextField().requestFocusInWindow();
            }
        });
        this.editor.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SpinnerCellEditor.this.setArrowButtonEnabled(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                SpinnerCellEditor.this.setArrowButtonEnabled(true);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpinnerCellEditor.this.editor.getTextField().setCaretPosition(8);
                        SpinnerCellEditor.this.editor.getTextField().setSelectionStart(8);
                        SpinnerCellEditor.this.editor.getTextField().setSelectionEnd(10);
                    }
                });
            }
        });
        this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private void setArrowButtonEnabled(boolean flag) {
        for (Component c : this.spinner.getComponents()) {
            if (!(c instanceof JButton)) continue;
            ((JButton)c).setEnabled(flag);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Date dateValue = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD");
        try {
            dateValue = format.parse((String)value);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        this.spinner.setValue(dateValue);
        this.editor.getTextField().setHorizontalAlignment(2);
        return this.spinner;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }
}

