/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestdocument;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import open.dolphin.client.labotestdocument.LaboTestItemID;
import open.dolphin.client.labotestdocument.SimpleLaboSpecimen;
import open.dolphin.client.labotestdocument.SimpleLaboTestItem;

public class SimpleLaboTest
implements Comparable {
    private SimpleLaboSpecimen specimen;
    private TreeSet testItemTreeSet;

    public SimpleLaboSpecimen getSimpleSpecimen() {
        return this.specimen;
    }

    public void setSimpleSpecimen(SimpleLaboSpecimen val) {
        this.specimen = val;
    }

    public TreeSet getTestItemTreeSet() {
        return this.testItemTreeSet;
    }

    public void setTestItemTreeSet(TreeSet val) {
        this.testItemTreeSet = val;
    }

    public void addSimpleLaboTestItem(SimpleLaboTestItem val) {
        if (this.testItemTreeSet == null) {
            this.testItemTreeSet = new TreeSet();
        }
        this.testItemTreeSet.add(val);
    }

    public int compareTo(Object obj) {
        SimpleLaboTest other = (SimpleLaboTest)obj;
        String str1 = this.specimen.getSpecimenName();
        String str2 = other.getSimpleSpecimen().getSpecimenName();
        return str1.compareTo(str2);
    }

    public boolean isSpecimen(SimpleLaboSpecimen other) {
        return this.specimen.equals(other);
    }

    public Object getTestItem(LaboTestItemID testID) {
        SimpleLaboTestItem ret = null;
        if (this.testItemTreeSet == null) {
            return ret;
        }
        for (SimpleLaboTestItem testItem : this.testItemTreeSet) {
            if (!testItem.isTest(testID)) continue;
            ret = testItem;
            break;
        }
        return ret;
    }

    public String getTestValue(LaboTestItemID testID) {
        String ret = null;
        if (this.testItemTreeSet == null) {
            return ret;
        }
        Iterator iter = this.testItemTreeSet.iterator();
        boolean hasTest = false;
        SimpleLaboTestItem testItem = null;
        while (iter.hasNext()) {
            testItem = (SimpleLaboTestItem)iter.next();
            if (!testItem.isTest(testID)) continue;
            hasTest = true;
            break;
        }
        ret = hasTest ? testItem.toString() : testID.getItemName();
        return ret;
    }

    public List getSimpleLaboTestItem() {
        ArrayList<SimpleLaboTestItem> ret = null;
        if (this.testItemTreeSet == null) {
            return ret;
        }
        Iterator iter = this.testItemTreeSet.iterator();
        ret = new ArrayList<SimpleLaboTestItem>();
        while (iter.hasNext()) {
            ret.add((SimpleLaboTestItem)iter.next());
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" ");
        buf.append("\n");
        buf.append(this.specimen.toString());
        buf.append("\n");
        if (this.testItemTreeSet != null) {
            for (SimpleLaboTestItem item : this.testItemTreeSet) {
                buf.append(item.toString());
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

