/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import open.dolphin.client.KartePane;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.ProgressCourse;
import open.dolphin.log.LogWriter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class KarteRenderer {
    private static final String COMPONENT_ELEMENT_NAME = "component";
    private static final String STAMP_HOLDER = "stampHolder";
    private static final String SCHEMA_HOLDER = "schemaHolder";
    private static final int TT_SECTION = 0;
    private static final int TT_PARAGRAPH = 1;
    private static final int TT_CONTENT = 2;
    private static final int TT_ICON = 3;
    private static final int TT_COMPONENT = 4;
    private static final int TT_PROGRESS_COURSE = 5;
    private static final String SECTION_NAME = "section";
    private static final String PARAGRAPH_NAME = "paragraph";
    private static final String CONTENT_NAME = "content";
    private static final String COMPONENT_NAME = "component";
    private static final String ICON_NAME = "icon";
    private static final String ALIGNMENT_NAME = "Alignment";
    private static final String FOREGROUND_NAME = "foreground";
    private static final String SIZE_NAME = "size";
    private static final String BOLD_NAME = "bold";
    private static final String ITALIC_NAME = "italic";
    private static final String UNDERLINE_NAME = "underline";
    private static final String TEXT_NAME = "text";
    private static final String NAME_NAME = "name";
    private static final String LOGICAL_STYLE_NAME = "logicalStyle";
    private static final String PROGRESS_COURSE_NAME = "kartePane";
    private static final String[] REPLACES = new String[]{"<", ">", "&", "'", "\""};
    private static final String[] MATCHES = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private static final String NAME_STAMP_HOLDER = "name=\"stampHolder\"";
    private DocumentModel model;
    private KartePane soaPane;
    private KartePane pPane;
    private KartePane thePane;
    boolean logicalStyle;
    private boolean bSoaPane;
    private List<ModuleModel> soaModules;
    private List<ModuleModel> pModules;

    public KarteRenderer(KartePane soaPane, KartePane pPane) {
        this.soaPane = soaPane;
        this.pPane = pPane;
    }

    public void render(DocumentModel model) {
        int index;
        this.model = model;
        Set<ModuleModel> modules = model.getModules();
        this.soaModules = new ArrayList<ModuleModel>();
        this.pModules = new ArrayList<ModuleModel>();
        String soaSpec = null;
        String pSpec = null;
        for (ModuleModel bean : modules) {
            String role = bean.getModuleInfo().getStampRole();
            if (role.equals("soa")) {
                this.soaModules.add(bean);
                continue;
            }
            if (role.equals("soaSpec")) {
                soaSpec = ((ProgressCourse)bean.getModel()).getFreeText();
                continue;
            }
            if (role.equals("p")) {
                this.pModules.add(bean);
                continue;
            }
            if (!role.equals("pSpec")) continue;
            pSpec = ((ProgressCourse)bean.getModel()).getFreeText();
        }
        if (soaSpec != null && pSpec != null && (index = soaSpec.indexOf(NAME_STAMP_HOLDER)) > 0) {
            String pTmp;
            String sTmp = soaSpec;
            soaSpec = pTmp = pSpec;
            pSpec = sTmp;
        }
        if (soaSpec == null || soaSpec.equals("")) {
            for (ModuleModel mm : this.soaModules) {
                this.soaPane.stamp(mm);
                this.soaPane.makeParagraph();
            }
        } else {
            LogWriter.debug(KarteRenderer.class, "Render SOA Pane");
            LogWriter.debug(KarteRenderer.class, "Module count = " + this.soaModules.size());
            this.bSoaPane = true;
            this.thePane = this.soaPane;
            this.renderPane(soaSpec);
        }
        if (pSpec == null || pSpec.equals("")) {
            for (ModuleModel mm : this.pModules) {
                this.pPane.flowStamp(mm);
                this.pPane.makeParagraph();
                this.pPane.makeParagraph();
            }
        } else {
            this.bSoaPane = false;
            this.thePane = this.pPane;
            this.renderPane(pSpec);
        }
    }

    private void renderPane(String xml) {
        SAXBuilder docBuilder = new SAXBuilder();
        try {
            StringReader sr = new StringReader(xml);
            Document doc = docBuilder.build((Reader)new BufferedReader(sr));
            Element root = doc.getRootElement();
            this.writeChildren(root);
        }
        catch (JDOMException e) {
            LogWriter.error(this.getClass(), e);
        }
        catch (IOException e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void writeChildren(Element current) {
        int eType = -1;
        String eName = current.getName();
        if (eName.equals(PARAGRAPH_NAME)) {
            eType = 1;
            this.startParagraph(current.getAttributeValue(LOGICAL_STYLE_NAME), current.getAttributeValue(ALIGNMENT_NAME));
        } else if (eName.equals(CONTENT_NAME) && current.getChild(TEXT_NAME) != null) {
            eType = 2;
            this.startContent(current.getAttributeValue(FOREGROUND_NAME), current.getAttributeValue(SIZE_NAME), current.getAttributeValue(BOLD_NAME), current.getAttributeValue(ITALIC_NAME), current.getAttributeValue(UNDERLINE_NAME), current.getChildText(TEXT_NAME));
        } else if (eName.equals("component")) {
            eType = 4;
            this.startComponent(current.getAttributeValue(NAME_NAME), current.getAttributeValue("component"));
        } else if (eName.equals(ICON_NAME)) {
            eType = 3;
            this.startIcon(current);
        } else if (eName.equals(PROGRESS_COURSE_NAME)) {
            eType = 5;
            this.startProgressCourse();
        } else if (eName.equals(SECTION_NAME)) {
            eType = 0;
            this.startSection();
        } else {
            LogWriter.debug(KarteRenderer.class, "Other element:" + eName);
        }
        if (eType == 1 || eType == 5 || eType == 0) {
            List children = current.getChildren();
            for (Element child : children) {
                this.writeChildren(child);
            }
        }
        switch (eType) {
            case 1: {
                this.endParagraph();
                break;
            }
            case 2: {
                this.endContent();
                break;
            }
            case 3: {
                this.endIcon();
                break;
            }
            case 4: {
                this.endComponent();
                break;
            }
            case 5: {
                this.endProgressCourse();
                break;
            }
            case 0: {
                this.endSection();
            }
        }
    }

    private void startSection() {
    }

    private void endSection() {
    }

    private void startProgressCourse() {
    }

    private void endProgressCourse() {
    }

    private void startParagraph(String lStyle, String alignStr) {
        this.thePane.setLogicalStyle("default");
        this.logicalStyle = true;
        if (alignStr != null) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.thePane.getTextPane().getDocument();
            Style style0 = doc.getStyle("default");
            Style style = doc.addStyle("alignment", style0);
            if (alignStr.equals("0")) {
                StyleConstants.setAlignment(style, 0);
            } else if (alignStr.equals("1")) {
                StyleConstants.setAlignment(style, 1);
            } else if (alignStr.equals("2")) {
                StyleConstants.setAlignment(style, 2);
            }
            this.thePane.setLogicalStyle("alignment");
            this.logicalStyle = true;
        }
    }

    private void endParagraph() {
        if (this.logicalStyle) {
            this.thePane.clearLogicalStyle();
            this.logicalStyle = false;
        }
    }

    private void startContent(String foreground, String size, String bold, String italic, String underline, String text) {
        StringTokenizer stk;
        for (int i = 0; i < REPLACES.length; ++i) {
            text = text.replaceAll(MATCHES[i], REPLACES[i]);
        }
        SimpleAttributeSet atts = new SimpleAttributeSet();
        if (foreground != null && (stk = new StringTokenizer(foreground, ",")).hasMoreTokens()) {
            int r = Integer.parseInt(stk.nextToken());
            int g = Integer.parseInt(stk.nextToken());
            int b = Integer.parseInt(stk.nextToken());
            StyleConstants.setForeground(atts, new Color(r, g, b));
        }
        if (size != null) {
            StyleConstants.setFontSize(atts, Integer.parseInt(size));
        }
        if (bold != null) {
            StyleConstants.setBold(atts, Boolean.valueOf(bold));
        }
        if (italic != null) {
            StyleConstants.setItalic(atts, Boolean.valueOf(italic));
        }
        if (underline != null) {
            StyleConstants.setUnderline(atts, Boolean.valueOf(underline));
        }
        this.thePane.insertFreeString(text, atts);
    }

    private void endContent() {
    }

    private void startComponent(String name, String number) {
        LogWriter.debug(KarteRenderer.class, "Entering startComponent");
        LogWriter.debug(KarteRenderer.class, "Name = " + name);
        LogWriter.debug(KarteRenderer.class, "Number = " + number);
        LogWriter.debug(KarteRenderer.class, "soaPane = " + this.bSoaPane);
        try {
            if (name != null && name.equals(STAMP_HOLDER)) {
                int index = Integer.parseInt(number);
                ModuleModel stamp = this.bSoaPane ? this.soaModules.get(index) : this.pModules.get(index);
                this.thePane.flowStamp(stamp);
            } else if (name != null && name.equals(SCHEMA_HOLDER)) {
                int index = Integer.parseInt(number);
                this.thePane.flowSchema(this.model.getSchema(index));
            }
        }
        catch (Exception e) {
            LogWriter.error(this.getClass(), e);
        }
    }

    private void endComponent() {
    }

    private void startIcon(Element current) {
        String name = current.getChildTextTrim(NAME_NAME);
        if (name != null) {
            LogWriter.debug(KarteRenderer.class, name);
        }
    }

    private void endIcon() {
    }
}

