/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartCommandAccepter;
import open.dolphin.client.IKarteComposite;
import open.dolphin.client.KarteEditor;
import open.dolphin.client.KartePane;
import open.dolphin.client.LetterView;
import open.dolphin.client.definition.FontSettings;
import open.dolphin.client.diagnosisdocumentpanel.DiagnosisDocumentPanel;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampHolder;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeMenuBuilder;
import open.dolphin.client.editor.stamp.StampTreePopupBuilder;
import open.dolphin.helper.ChartMenuSupport;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.ClaimItem;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.StringTool;

public final class ChartMediator
extends ChartMenuSupport
implements UndoableEditListener,
MenuListener,
IChartCommandAccepter {
    private int curSize = 3;
    private IChart chart;
    private IKarteComposite curKarteComposit;
    private JFrame curWindow;
    private UndoManager undoManager;
    private Action undoAction;
    private Action redoAction;
    private FocusPropertyChangeListener fpcl;

    public ChartMediator(IChartCommandAccepter owner) {
        super(owner);
        this.setAccepter(this);
        this.chart = (IChart)((Object)owner);
        this.fpcl = new FocusPropertyChangeListener();
        this.undoManager = new UndoManager();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(this.fpcl);
    }

    protected void setCurWindow(JFrame frame) {
        this.curWindow = frame;
    }

    protected JFrame getCurWindow() {
        return this.curWindow;
    }

    protected void setCurKarteComposit(IKarteComposite newComposit) {
        IKarteComposite old = this.curKarteComposit;
        this.curKarteComposit = newComposit;
        if (old != this.curKarteComposit) {
            if (old != null) {
                old.exit(this.getActions());
            }
            this.enabledAction("cut", false);
            this.enabledAction("copy", false);
            this.enabledAction("paste", false);
            this.enabledAction("undo", false);
            this.enabledAction("redo", false);
            this.enabledAction("insertText", false);
            this.enabledAction("insertSchema", false);
            this.enabledAction("insertStamp", false);
            if (this.curKarteComposit != null) {
                this.curKarteComposit.enter(this.getActions());
            }
        }
    }

    @Override
    public void registerActions(ActionMap map) {
        super.registerActions(map);
        this.undoAction = map.get("undo");
        this.redoAction = map.get("redo");
        boolean isAsc = GlobalVariables.getAscendingKarte();
        Action action = null;
        action = isAsc ? map.get("ascending") : map.get("descending");
        JRadioButtonMenuItem rdi = (JRadioButtonMenuItem)action.getValue("menuItem");
        rdi.setSelected(true);
    }

    public void dispose() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener(this.fpcl);
    }

    private JComponent getCurrentComponent() {
        if (this.curKarteComposit != null) {
            return (JComponent)this.curKarteComposit.getComponent();
        }
        return null;
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu selectedMenu = (JMenu)e.getSource();
        String cmd = selectedMenu.getActionCommand();
        if (cmd.equals("\u633f \u5165")) {
            selectedMenu.removeAll();
            List<StampTree> trees = this.getStampBox().getAllTrees();
            for (StampTree tree : trees) {
                String entity = tree.getEntity();
                if (entity.equals("diagnosis")) {
                    selectedMenu.add(this.createDiagnosisMenu(tree));
                    selectedMenu.addSeparator();
                    continue;
                }
                if (entity.equals("text")) {
                    selectedMenu.add(this.createTextMenu(tree));
                    selectedMenu.addSeparator();
                    continue;
                }
                selectedMenu.add(this.createStampMenu(tree));
            }
        } else if (cmd.equals("\u30c6\u30ad\u30b9\u30c8")) {
            this.adjustStyleMenu();
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    private void adjustStyleMenu() {
        boolean enabled = false;
        KartePane kartePane = null;
        if (this.getLast() instanceof KarteEditor) {
            KarteEditor editor = (KarteEditor)this.getLast();
            kartePane = editor.getSOAPane();
            enabled = kartePane.getTextPane().isEditable();
        }
        this.getAction("size").setEnabled(enabled);
        this.getAction("style").setEnabled(enabled);
        this.getAction("justify").setEnabled(enabled);
        this.getAction("color").setEnabled(enabled);
        this.getAction("fontRed").setEnabled(enabled);
        this.getAction("fontOrange").setEnabled(enabled);
        this.getAction("fontYellow").setEnabled(enabled);
        this.getAction("fontGreen").setEnabled(enabled);
        this.getAction("fontBlue").setEnabled(enabled);
        this.getAction("fontPurple").setEnabled(enabled);
        this.getAction("fontGray").setEnabled(enabled);
        this.getAction("fontLarger").setEnabled(enabled);
        this.getAction("fontSmaller").setEnabled(enabled);
        this.getAction("fontStandard").setEnabled(enabled);
        this.getAction("fontBold").setEnabled(enabled);
        this.getAction("fontItalic").setEnabled(enabled);
        this.getAction("fontUnderline").setEnabled(enabled);
        this.getAction("leftJustify").setEnabled(enabled);
        this.getAction("centerJustify").setEnabled(enabled);
        this.getAction("rightJustify").setEnabled(enabled);
    }

    private JMenu createDiagnosisMenu(StampTree stampTree) {
        JMenu myMenu = null;
        boolean enabled = false;
        DiagnosisDocumentPanel diagnosis = null;
        Object obj = this.getLast();
        if (obj instanceof DiagnosisDocumentPanel) {
            diagnosis = (DiagnosisDocumentPanel)obj;
            enabled = true;
        }
        if (!enabled) {
            myMenu = new JMenu(stampTree.getTreeName());
            myMenu.setEnabled(false);
        } else {
            JTable comp = diagnosis.getDiagnosisTable();
            TransferHandler handler = comp.getTransferHandler();
            StampTreeMenuBuilder builder = new StampTreeMenuBuilder();
            myMenu = builder.build(stampTree, comp, handler);
        }
        return myMenu;
    }

    private JMenu createTextMenu(StampTree stampTree) {
        KarteEditor editor;
        JMenu myMenu = null;
        boolean enabled = false;
        KartePane kartePane = null;
        if (this.getLast() instanceof KarteEditor && (kartePane = (editor = (KarteEditor)this.getLast()).getSOAPane()) != null) {
            enabled = kartePane.getTextPane().isEditable();
        }
        if (!enabled) {
            myMenu = new JMenu(stampTree.getTreeName());
            myMenu.setEnabled(false);
        } else {
            JComponent comp = this.getCurrentComponent();
            if (comp == null) {
                comp = kartePane.getTextPane();
            }
            TransferHandler handler = comp.getTransferHandler();
            StampTreeMenuBuilder builder = new StampTreeMenuBuilder();
            myMenu = builder.build(stampTree, comp, handler);
        }
        return myMenu;
    }

    private JMenu createStampMenu(StampTree stampTree) {
        KarteEditor editor;
        JMenu myMenu = null;
        boolean enabled = false;
        KartePane kartePane = null;
        if (this.getLast() instanceof KarteEditor && (kartePane = (editor = (KarteEditor)this.getLast()).getPPane()) != null) {
            enabled = kartePane.getTextPane().isEditable();
        }
        if (!enabled) {
            myMenu = new JMenu(stampTree.getTreeName());
            myMenu.setEnabled(false);
        } else {
            JTextPane comp = kartePane.getTextPane();
            TransferHandler handler = comp.getTransferHandler();
            StampTreeMenuBuilder builder = new StampTreeMenuBuilder();
            myMenu = builder.build(stampTree, comp, handler);
        }
        return myMenu;
    }

    protected void addDiseaseMenu(JPopupMenu popup) {
        StampTree stampTree;
        boolean enabled = false;
        DiagnosisDocumentPanel diagnosis = null;
        if (this.getLast() instanceof DiagnosisDocumentPanel) {
            diagnosis = (DiagnosisDocumentPanel)this.getLast();
            enabled = true;
        }
        if ((stampTree = this.getStampBox().getStampTree("diagnosis")) != null) {
            if (!enabled) {
                JMenu myMenu = new JMenu(stampTree.getTreeName());
                myMenu.setEnabled(false);
                popup.add(myMenu);
                return;
            }
            JTable comp = diagnosis.getDiagnosisTable();
            TransferHandler handler = comp.getTransferHandler();
            StampTreePopupBuilder builder = new StampTreePopupBuilder();
            builder.build(stampTree, popup, comp, handler);
        }
    }

    public void addTextMenu(JPopupMenu popup) {
        StampTree stampTree;
        KarteEditor editor;
        boolean enabled = false;
        KartePane kartePane = null;
        if (this.getLast() instanceof KarteEditor && (kartePane = (editor = (KarteEditor)this.getLast()).getSOAPane()) != null) {
            boolean bl = enabled = kartePane.getTextPane().isEditable();
        }
        if ((stampTree = this.getStampBox().getStampTree("text")) != null) {
            if (!enabled) {
                JMenu myMenu = new JMenu(stampTree.getTreeName());
                myMenu.setEnabled(false);
                popup.add(myMenu);
                return;
            }
            JComponent comp = this.getCurrentComponent();
            if (comp == null) {
                comp = kartePane.getTextPane();
            }
            TransferHandler handler = comp.getTransferHandler();
            StampTreePopupBuilder builder = new StampTreePopupBuilder();
            builder.build(stampTree, popup, comp, handler);
        }
    }

    protected void addStampMenu(JPopupMenu menu, KartePane kartePane) {
        if (kartePane != null && kartePane.getMyRole().equals("p") && kartePane.getTextPane().isEditable()) {
            StampBoxFrame stampBox = this.getStampBox();
            List<StampTree> trees = stampBox.getAllTrees();
            StampTreeMenuBuilder builder = new StampTreeMenuBuilder();
            JTextPane cmp = kartePane.getTextPane();
            TransferHandler handler = cmp.getTransferHandler();
            for (StampTree stampTree : trees) {
                String entity = stampTree.getEntity();
                if (entity.equals("diagnosis") || entity.equals("text")) continue;
                JMenu subMenu = builder.build(stampTree, cmp, handler);
                menu.add(subMenu);
            }
        }
    }

    public void addStampMenu(JPopupMenu popup) {
        KarteEditor editor;
        boolean enabled = false;
        KartePane kartePane = null;
        if (this.getLast() instanceof KarteEditor && (kartePane = (editor = (KarteEditor)this.getLast()).getPPane()) != null) {
            enabled = kartePane.getTextPane().isEditable();
        }
        if (enabled) {
            this.addStampMenu(popup, kartePane);
        }
    }

    protected StampTree getStampTree(String entity) {
        return this.getStampBox().getStampTree(entity);
    }

    protected StampBoxFrame getStampBox() {
        return (StampBoxFrame)this.chart.getContext().getPlugin("stampBox");
    }

    protected boolean hasTree(String entity) {
        StampBoxFrame stBox = (StampBoxFrame)this.chart.getContext().getPlugin("stampBox");
        StampTree tree = stBox.getStampTree(entity);
        return tree != null;
    }

    public void applyInsurance(PVTHealthInsuranceModel pvtHIModel) {
        Object target = this.getLast();
        if (target != null) {
            try {
                Method meth = target.getClass().getMethod("applyInsurance", pvtHIModel.getClass());
                meth.invoke(target, pvtHIModel);
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
            }
        }
    }

    @Override
    public void cut() {
        Action action;
        JComponent focusOwner;
        if (this.curKarteComposit != null && (focusOwner = this.getCurrentComponent()) != null && (action = focusOwner.getActionMap().get(TransferHandler.getCutAction().getValue("Name"))) != null) {
            action.actionPerformed(new ActionEvent(focusOwner, 1001, null));
            this.setCurKarteComposit(null);
        }
    }

    @Override
    public void copy() {
        Action action;
        JComponent focusOwner = this.getCurrentComponent();
        if (focusOwner != null && (action = focusOwner.getActionMap().get(TransferHandler.getCopyAction().getValue("Name"))) != null) {
            action.actionPerformed(new ActionEvent(focusOwner, 1001, null));
        }
    }

    @Override
    public void paste() {
        Action action;
        JComponent focusOwner = this.getCurrentComponent();
        if (focusOwner != null && (action = focusOwner.getActionMap().get(TransferHandler.getPasteAction().getValue("Name"))) != null) {
            action.actionPerformed(new ActionEvent(focusOwner, 1001, null));
        }
    }

    public IChart getChart() {
        return this.chart;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case letterPaste: {
                return this.pasteLetter();
            }
            case quickEdit: {
                return this.quickEdit();
            }
            case delete: {
                return this.delete();
            }
            case resetStyle: {
                return this.resetStyle();
            }
            case undo: {
                return this.undo();
            }
            case redo: {
                return this.redo();
            }
            case fontLarger: {
                return this.fontLarger();
            }
            case fontSmaller: {
                return this.fontSmaller();
            }
            case fontStandard: {
                return this.fontStandard();
            }
            case fontBold: {
                return this.styleAction("font-bold");
            }
            case fontItalic: {
                return this.styleAction("font-italic");
            }
            case fontUnderline: {
                return this.styleAction("font-underline");
            }
            case leftJustify: {
                return this.styleAction("left-justify");
            }
            case centerJustify: {
                return this.styleAction("center-justify");
            }
            case rightJustify: {
                return this.styleAction("right-justify");
            }
            case fontRed: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.RED));
            }
            case fontOrange: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.ORANGE));
            }
            case fontYellow: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.YELLOW));
            }
            case fontGreen: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.GREEN));
            }
            case fontBlue: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.BLUE));
            }
            case fontPurple: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.PURPLE));
            }
            case fontGray: {
                return this.colorAction(GlobalSettings.getColors(GlobalSettings.Parts.GRAY));
            }
            case fontBlack: {
                return this.colorAction(Color.BLACK);
            }
        }
        return false;
    }

    private boolean pasteMedicationToLetter(String message) {
        LetterView view = ((ChartWindow)this.chart).getLetterPane();
        if (view != null) {
            view.getMedication().setText(view.getMedication().getText() + "\n" + message);
        }
        return true;
    }

    private boolean pasteLetter() {
        JComponent stampHolder;
        if (this.chart instanceof ChartWindow && ((ChartWindow)this.chart).existLetterPane() && (stampHolder = this.getCurrentComponent()) instanceof StampHolder) {
            ModuleModel stamp = ((StampHolder)stampHolder).getStamp();
            String stampName = stamp.getModuleInfo().getStampName();
            BundleDolphin bundle = (BundleDolphin)stamp.getModel();
            this.pasteMedicationToLetter(bundle.toString().replaceFirst("\n", "(" + stampName + ")\n"));
        }
        return true;
    }

    private boolean quickEdit() {
        if (this.chart instanceof IChart) {
            JComponent currentComponent = this.getCurrentComponent();
            if (currentComponent instanceof StampHolder) {
                int i;
                StampHolder stampHolder = (StampHolder)currentComponent;
                ModuleModel moduleModel = stampHolder.getStamp();
                IInfoModel model = moduleModel.getModel();
                if (!(model instanceof ClaimBundle)) {
                    return false;
                }
                ClaimBundle bundle = (ClaimBundle)model;
                List<JTextField> results = stampHolder.showQuickEditDialog(this.getCurWindow());
                if (results == null) {
                    return false;
                }
                JTextField bundleNumber = results.remove(results.size() - 1);
                ArrayList<ClaimItem> targets = new ArrayList<ClaimItem>();
                ClaimItem[] candidates = bundle.getClaimItem();
                for (i = 0; i < candidates.length; ++i) {
                    if (StringTool.isEmptyString(candidates[i].getNumber())) continue;
                    targets.add(candidates[i]);
                }
                for (i = 0; i < targets.size(); ++i) {
                    String value = results.get(i).getText();
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(this.getCurWindow(), "\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                        return false;
                    }
                    ((ClaimItem)targets.get(i)).setNumber(value);
                }
                int number = 0;
                try {
                    number = Integer.parseInt(bundleNumber.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this.getCurWindow(), "\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                    return false;
                }
                bundle.setBundleNumber(number);
                stampHolder.importStamp(moduleModel);
            }
            return true;
        }
        return false;
    }

    public boolean delete() {
        return true;
    }

    private boolean resetStyle() {
        JComponent focusOwner = this.getCurrentComponent();
        if (focusOwner != null && focusOwner instanceof JTextPane) {
            JTextPane pane = (JTextPane)focusOwner;
            pane.setCharacterAttributes(SimpleAttributeSet.EMPTY, true);
        }
        return true;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.addEdit(e.getEdit());
        this.updateUndoAction();
        this.updateRedoAction();
    }

    private boolean undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        this.updateUndoAction();
        this.updateRedoAction();
        return true;
    }

    private boolean redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        this.updateRedoAction();
        this.updateUndoAction();
        return true;
    }

    private void updateUndoAction() {
        if (this.undoManager.canUndo()) {
            this.undoAction.setEnabled(true);
        } else {
            this.undoAction.setEnabled(false);
        }
    }

    private void updateRedoAction() {
        if (this.undoManager.canRedo()) {
            this.redoAction.setEnabled(true);
        } else {
            this.redoAction.setEnabled(false);
        }
    }

    private boolean fontLarger() {
        JTextPane focusOwner = (JTextPane)this.getCurrentComponent();
        int selectionStart = focusOwner.getSelectionStart();
        int selectionEnd = focusOwner.getSelectionEnd();
        if (focusOwner != null && selectionStart != selectionEnd) {
            if (this.curSize < 6) {
                ++this.curSize;
            }
            int size = FontSettings.getKarteFontSize(this.curSize);
            Action a = focusOwner.getActionMap().get("font-size-" + size);
            if (a != null) {
                a.actionPerformed(new ActionEvent(focusOwner, 1001, null));
            }
            if (this.curSize == 6) {
                this.enabledAction("fontLarger", false);
            }
        }
        return true;
    }

    private boolean fontSmaller() {
        JTextPane focusOwner = (JTextPane)this.getCurrentComponent();
        int selectionStart = focusOwner.getSelectionStart();
        int selectionEnd = focusOwner.getSelectionEnd();
        if (focusOwner != null && selectionStart != selectionEnd) {
            if (this.curSize > 0) {
                --this.curSize;
            }
            int size = FontSettings.getKarteFontSize(this.curSize);
            Action a = focusOwner.getActionMap().get("font-size-" + size);
            if (a != null) {
                a.actionPerformed(new ActionEvent(focusOwner, 1001, null));
            }
            if (this.curSize == 0) {
                this.enabledAction("fontSmaller", false);
            }
        }
        return true;
    }

    private boolean fontStandard() {
        JTextPane focusOwner = (JTextPane)this.getCurrentComponent();
        if (focusOwner != null) {
            this.curSize = 3;
            int size = FontSettings.getKarteDefaultFontSize();
            Action a = focusOwner.getActionMap().get("font-size-" + size);
            if (a != null) {
                a.actionPerformed(new ActionEvent(focusOwner, 1001, null));
            }
            this.enabledAction("fontSmaller", true);
            this.enabledAction("fontLarger", true);
        }
        return true;
    }

    private boolean styleAction(String style) {
        Action a;
        JComponent focusOwner = this.getCurrentComponent();
        if (focusOwner != null && (a = focusOwner.getActionMap().get(style)) != null) {
            a.actionPerformed(new ActionEvent(focusOwner, 1001, null));
        }
        return true;
    }

    private boolean colorAction(Color color) {
        StyledEditorKit.ForegroundAction a;
        JComponent focusOwner = this.getCurrentComponent();
        if (focusOwner != null && (a = new StyledEditorKit.ForegroundAction("color", color)) != null) {
            a.actionPerformed(new ActionEvent(focusOwner, 1001, "foreground"));
        }
        return true;
    }

    class FocusPropertyChangeListener
    implements PropertyChangeListener {
        FocusPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object frame;
            LogWriter.debug(this.getClass(), "propertyChange");
            String prop = e.getPropertyName();
            if ("focusOwner".equals(prop)) {
                Component comp = (Component)e.getNewValue();
                if (comp instanceof JTextPane) {
                    Object obj = ((JTextPane)comp).getClientProperty("kartePane");
                    if (obj != null && obj instanceof KartePane) {
                        ChartMediator.this.setCurKarteComposit((IKarteComposite)obj);
                    }
                } else if (comp instanceof IKarteComposite) {
                    ChartMediator.this.setCurKarteComposit((IKarteComposite)((Object)comp));
                }
            } else if ("activeWindow".equals(prop) && (frame = e.getNewValue()) instanceof JFrame) {
                ChartMediator.this.setCurWindow((JFrame)e.getNewValue());
            }
        }
    }

    protected static enum CompState {
        NONE,
        SOA,
        SOA_TEXT,
        SCHEMA,
        P,
        P_TEXT,
        STAMP;

    }
}

