/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.UIDRefContent;
import org.dcm4cheri.srom.NamedContentImpl;

class UIDRefContentImpl
extends NamedContentImpl
implements UIDRefContent {
    private String uid;

    UIDRefContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, String uid) {
        super(owner, obsDateTime, template, UIDRefContentImpl.checkNotNull(name));
        this.setUID(uid);
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new UIDRefContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.uid);
    }

    public final void setName(Code newName) {
        this.name = UIDRefContentImpl.checkNotNull(newName);
    }

    public String toString() {
        return this.prompt().append('\"').append(this.uid).append('\"').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.UIDREF;
    }

    public final String getUID() {
        return this.uid;
    }

    public final void setUID(String uid) {
        if (uid.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.uid = uid;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putUI(4235556, this.uid);
    }
}

