/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirRecord;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirReaderImpl;
import org.dcm4cheri.media.DirRecordImpl;
import org.dcm4cheri.util.IntHashtable2;

final class DirWriterImpl
extends DirReaderImpl
implements DirWriter {
    private static final Short INACTIVE = new Short(0);
    private static final Integer INTEGER0 = new Integer(0);
    private static final String[] TYPE_CODE = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE", "OVERLAY", "MODALITY LUT", "VOI LUT", "CURVE", "TOPIC", "VISIT", "RESULTS", "INTERPRETATION", "STUDY COMPONENT", "STORED PRINT", "RT DOSE", "RT STRUCTURE SET", "RT PLAN", "RT TREAT RECORD", "PRESENTATION", "WAVEFORM", "SR DOCUMENT", "KEY OBJECT DOC", "SPECTROSCOPY", "RAW DATA", "REGISTRATION", "FIDUCIAL", "ENCAP DOC", "PRIVATE", "MRDR"};
    private static final List TYPE_CODE_LIST = Arrays.asList(TYPE_CODE);
    private static final byte[] ITEM = new byte[]{-2, -1, 0, -32, -1, -1, -1, -1};
    private static final byte[] ITEM_DELIMITER = new byte[]{-2, -1, 13, -32, 0, 0, 0, 0};
    private static final byte[] SEQ_DELIMITER = new byte[]{-2, -1, -35, -32, 0, 0, 0, 0};
    private static final byte[] PADDING_TAG_OB = new byte[]{-4, -1, -4, -1, 79, 66, 0, 0};
    private String dirPath;
    private final ImageOutputStream out;
    private final DcmEncodeParam encParam;
    private boolean autoCommit = false;
    private long newRecPos;
    private long rollbackPos;
    private int rollbackOffLastRootRec;
    private TreeMap dirtyOffsets = new TreeMap();
    private Long lastRootRecNextValPos = null;
    private IntHashtable2 lastRecNextValPosCache = new IntHashtable2();

    DirWriterImpl(File file, ImageOutputStream out, DcmEncodeParam encParam) {
        super(file, out);
        this.out = out;
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.encParam = encParam != null ? encParam : DcmDecodeParam.EVR_LE;
    }

    public String[] toFileIDs(File refFile) throws IOException {
        String path;
        if (this.dirPath == null) {
            this.dirPath = this.file.getParentFile().getAbsolutePath();
        }
        if (!(path = refFile.getAbsolutePath()).startsWith(this.dirPath)) {
            throw new IllegalArgumentException(path);
        }
        StringTokenizer strTk = new StringTokenizer(path.substring(this.dirPath.length()), File.separator);
        String[] retVal = new String[strTk.countTokens()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = strTk.nextToken();
        }
        return retVal;
    }

    DirWriterImpl initWriter(FileMetaInfo fmi, String filesetID, File descriptorFile, String specCharset) throws IOException {
        this.parser.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
        this.fsi = factory.newDataset();
        this.fsi.setFileMetaInfo(fmi);
        this.fsi.putCS(266544, filesetID);
        if (descriptorFile != null) {
            this.fsi.putCS(266561, this.toFileIDs(descriptorFile.getAbsoluteFile()));
            if (specCharset != null) {
                this.fsi.putCS(266562, specCharset);
            }
        }
        this.offFirstRootRec = 0;
        this.fsi.putUL(266752, 0);
        this.offLastRootRec = 0;
        this.fsi.putUL(266754, 0);
        this.fsi.putUS(266770, 0);
        this.fsi.putSQ(266784);
        this.fsi.writeFile(this.out, this.encParam);
        this.fsi.remove(266784);
        if (this.encParam.undefSeqLen) {
            this.seqLength = -1;
            this.seqValuePos = this.out.getStreamPosition() - 8L;
        } else {
            this.seqLength = 0;
            this.seqValuePos = this.out.getStreamPosition();
        }
        this.offFirstRootRecValPos = this.seqValuePos - 38L;
        this.offLastRootRecValPos = this.seqValuePos - 26L;
        this.newRecPos = this.rollbackPos = this.seqValuePos;
        this.rollbackOffLastRootRec = this.offLastRootRec;
        return this;
    }

    DirWriterImpl initWriter() throws IOException {
        this.initReader();
        this.rollbackPos = this.seqLength != -1 ? this.seqValuePos + ((long)this.seqLength & 0xFFFFFFFFL) : (this.offLastRootRec == 0 ? this.seqValuePos : this.parseItems());
        this.newRecPos = this.rollbackPos;
        this.rollbackOffLastRootRec = this.offLastRootRec;
        return this;
    }

    private long parseItems() throws IOException {
        this.parser.seek((long)this.offLastRootRec & 0xFFFFFFFFL);
        while (this.parser.parseItemDataset() != -1L) {
        }
        return this.parser.getStreamPosition() - 8L;
    }

    public void close() throws IOException {
        this.commit();
        super.close();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws IOException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.autoCommit = autoCommit;
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void commit() throws IOException {
        if (this.dirtyOffsets.isEmpty()) {
            if (this.newRecPos != this.rollbackPos) {
                throw new RuntimeException("newRecPos:" + this.newRecPos + ", rollbackPos:" + this.rollbackPos);
            }
            return;
        }
        if (this.newRecPos != this.rollbackPos) {
            this.writeTrailer();
            if (this.seqLength != -1) {
                this.dirtyOffsets.put(new Long(this.seqValuePos - 4L), new Integer(this.seqLength += (int)(this.newRecPos - this.rollbackPos)));
            }
        }
        Iterator iter = this.dirtyOffsets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.out.seek((Long)entry.getKey());
            Number num = (Number)entry.getValue();
            if (num instanceof Integer) {
                this.out.writeInt(num.intValue());
                continue;
            }
            this.out.writeShort(num.intValue());
        }
        this.dirtyOffsets.clear();
        this.rollbackOffLastRootRec = this.offLastRootRec;
        this.rollbackPos = this.newRecPos;
    }

    public synchronized void rollback() throws IOException {
        if (this.newRecPos == this.rollbackPos) {
            return;
        }
        this.dirtyOffsets.clear();
        this.lastRecNextValPosCache.clear();
        this.lastRootRecNextValPos = null;
        this.offLastRootRec = this.rollbackOffLastRootRec;
        if (this.offLastRootRec == 0) {
            this.offFirstRootRec = 0;
        }
        this.newRecPos = this.rollbackPos;
        this.writeTrailer();
    }

    private void writeTrailer() throws IOException {
        int padlen;
        this.out.seek(this.newRecPos);
        if (this.seqLength == -1) {
            this.out.write(SEQ_DELIMITER);
        }
        if ((padlen = (int)(this.out.length() - this.out.getStreamPosition())) > 0) {
            this.out.write(PADDING_TAG_OB);
            padlen = Math.max(0, padlen - 12);
            this.out.writeInt(padlen + 1 & 0xFFFFFFFE);
            if ((padlen & 1) != 0) {
                this.out.seek(this.out.length());
                this.out.write(0);
            }
        }
    }

    public synchronized DirRecord add(DirRecord parent, String type, Dataset ds) throws IOException {
        return this.add(parent, type, ds, null, null, null, null);
    }

    public synchronized DirRecord add(DirRecord parent, String type, Dataset ds, String[] fileIDs, String classUID, String instUID, String tsUID) throws IOException {
        return this.add(parent, type, ds, fileIDs, classUID, instUID, tsUID, false);
    }

    private DirRecord add(DirRecord parentOrOld, String type, Dataset ds, String[] fileIDs, String classUID, String instUID, String tsUID, boolean replace) throws IOException {
        if (TYPE_CODE_LIST.indexOf(type) == -1) {
            throw new IllegalArgumentException("type:" + type);
        }
        Dataset ds0004 = factory.newDataset();
        ds0004.putUL(267264, 0);
        ds0004.putUS(267280, 65535);
        ds0004.putUL(267296, replace ? ((DirRecordImpl)parentOrOld).lower : 0);
        ds0004.putCS(267312, type);
        if (fileIDs != null) {
            if (classUID == null) {
                throw new NullPointerException();
            }
            if (instUID == null) {
                throw new NullPointerException();
            }
            if (tsUID == null) {
                throw new NullPointerException();
            }
            ds0004.putCS(267520, fileIDs);
            ds0004.putUI(267536, classUID);
            ds0004.putUI(267537, instUID);
            ds0004.putUI(267538, tsUID);
        }
        this.out.seek(this.newRecPos);
        this.out.write(ITEM, 0, 8);
        ds0004.writeDataset(this.out, this.encParam);
        ds.subSet(524288, -1).writeDataset(this.out, this.encParam);
        long nextNewRecPos = this.out.getStreamPosition();
        if (this.encParam.undefItemLen) {
            this.out.write(ITEM_DELIMITER, 0, 8);
            nextNewRecPos += 8L;
        } else {
            this.out.seek(this.newRecPos + 4L);
            this.out.writeInt((int)(nextNewRecPos - this.newRecPos - 8L));
        }
        DirRecordImpl retval = new DirRecordImpl(this.parser, (int)this.newRecPos);
        Integer newOff = new Integer((int)this.newRecPos);
        if (parentOrOld == null) {
            this.dirtyOffsets.put(this.setLastRootRecNextValPos(retval.nextValPos), newOff);
            this.dirtyOffsets.put(new Long(this.offLastRootRecValPos), newOff);
            this.offLastRootRec = (int)this.newRecPos;
            if (this.offFirstRootRec == 0) {
                this.offFirstRootRec = (int)this.newRecPos;
            }
        } else if (replace) {
            DirRecordImpl rec = (DirRecordImpl)parentOrOld;
            this.dirtyOffsets.put(new Long(rec.inUsePos), INACTIVE);
            this.dirtyOffsets.put(new Long(rec.lowerValPos), INTEGER0);
            while (rec.next != 0) {
                rec = new DirRecordImpl(this.parser, rec.next);
            }
            this.dirtyOffsets.put(new Long(rec.nextValPos), newOff);
        } else {
            this.dirtyOffsets.put(this.setLastRecNextValPos(parentOrOld, retval.nextValPos), newOff);
        }
        this.newRecPos = nextNewRecPos;
        if (this.autoCommit) {
            this.commit();
        }
        return retval;
    }

    private Long setLastRootRecNextValPos(long newval) throws IOException {
        Long retval = this.lastRootRecNextValPos;
        this.lastRootRecNextValPos = new Long(newval);
        if (this.offLastRootRec == 0) {
            return new Long(this.offFirstRootRecValPos);
        }
        if (retval != null) {
            return retval;
        }
        return new Long(new DirRecordImpl((DcmParser)this.parser, (int)this.offLastRootRec).nextValPos);
    }

    private Long setLastRecNextValPos(DirRecord parent, long newval) throws IOException {
        int key = parent.hashCode();
        Long retval = (Long)this.lastRecNextValPosCache.get(key);
        this.lastRecNextValPosCache.put(key, new Long(newval));
        if (retval != null) {
            return retval;
        }
        DirRecordImpl child = (DirRecordImpl)parent.getFirstChild(true);
        if (child == null) {
            return new Long(((DirRecordImpl)parent).lowerValPos);
        }
        while (child.next != 0) {
            child = new DirRecordImpl(this.parser, child.next);
        }
        return new Long(child.nextValPos);
    }

    public int remove(DirRecord rec) throws IOException {
        if (rec.getInUseFlag() == 0) {
            return 0;
        }
        int retval = this.doRemove(rec);
        if (this.autoCommit) {
            this.commit();
        }
        return retval;
    }

    private int doRemove(DirRecord rec) throws IOException {
        this.dirtyOffsets.put(new Long(((DirRecordImpl)rec).inUsePos), INACTIVE);
        int retval = 1;
        for (DirRecord child = rec.getFirstChild(true); child != null; child = child.getNextSibling(true)) {
            retval += this.doRemove(child);
        }
        return retval;
    }

    public DirRecord replace(DirRecord old, String type, Dataset ds) throws IOException {
        return this.replace(old, type, ds, null, null, null, null);
    }

    public DirRecord replace(DirRecord old, String type, Dataset ds, String[] fileIDs, String classUID, String instUID, String tsUID) throws IOException {
        if (old.getInUseFlag() == 0) {
            throw new IllegalArgumentException("" + old);
        }
        return this.add(old, type, ds, fileIDs, classUID, instUID, tsUID, true);
    }

    private File backup() throws IOException {
        this.close();
        File dir = this.file.getParentFile();
        String fname = this.file.getName();
        File bakFile = null;
        while ((bakFile = new File(dir, fname = fname + '~')).exists()) {
        }
        this.file.renameTo(bakFile);
        return bakFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirWriter compact() throws IOException {
        File bakFile = this.backup();
        DirWriterImpl writer = null;
        try {
            DirReaderImpl reader = new DirReaderImpl(bakFile, new FileImageInputStream(bakFile)).initReader();
            try {
                Dataset fsi = reader.getFileSetInfo();
                writer = new DirWriterImpl(this.file, new FileImageOutputStream(this.file), this.encParam);
                writer.initWriter(fsi.getFileMetaInfo(), fsi.getString(266544), reader.getDescriptorFile(), fsi.getString(266562));
                this.copy(reader, writer);
                writer.commit();
                writer.setAutoCommit(this.autoCommit);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.file.delete();
            bakFile.renameTo(this.file);
            throw e;
        }
        bakFile.delete();
        return writer;
    }

    private void copy(DirReaderImpl src, DirWriterImpl dst) throws IOException {
        for (DirRecord srcRec = src.getFirstRecord(true); srcRec != null; srcRec = srcRec.getNextSibling(true)) {
            this.copyInto(srcRec, dst, null);
        }
    }

    private void copyInto(DirRecord srcRec, DirWriterImpl dst, DirRecord parent) throws IOException {
        DirRecord dstRec = dst.add(parent, srcRec.getType(), srcRec.getDataset(), srcRec.getRefFileIDs(), srcRec.getRefSOPClassUID(), srcRec.getRefSOPInstanceUID(), srcRec.getRefSOPTransferSyntaxUID());
        for (DirRecord childRec = srcRec.getFirstChild(true); childRec != null; childRec = childRec.getNextSibling(true)) {
            this.copyInto(childRec, dst, dstRec);
        }
    }
}

