/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.FileMetaInfoImpl;

class DcmStreamHandlerImpl
implements DcmHandler {
    private static final int ITEM_TAG = -73728;
    private static final int ITEM_DELIMITATION_ITEM_TAG = -73715;
    private static final int SEQ_DELIMITATION_ITEM_TAG = -73507;
    private final byte[] b12 = new byte[12];
    private final ByteBuffer bb12 = ByteBuffer.wrap(this.b12).order(ByteOrder.LITTLE_ENDIAN);
    private boolean explicitVR = false;
    private int tag = 0;
    private int vr = 0;
    private DataOutput out;

    public DcmStreamHandlerImpl(OutputStream out) {
        this.out = out instanceof DataOutput ? (DataOutput)((Object)out) : new DataOutputStream(out);
    }

    public DcmStreamHandlerImpl(ImageOutputStream out) {
        this.out = out;
    }

    public void startCommand() {
    }

    public void endCommand() {
    }

    public void startDcmFile() {
    }

    public void endDcmFile() {
    }

    public void startFileMetaInfo(byte[] preamble) throws IOException {
        if (preamble != null) {
            this.out.write(preamble, 0, 128);
            this.out.write(FileMetaInfoImpl.DICM_PREFIX, 0, 4);
        }
    }

    public void endFileMetaInfo() {
    }

    public void startDataset() {
    }

    public void endDataset() {
    }

    public void setDcmDecodeParam(DcmDecodeParam param) {
        this.bb12.order(param.byteOrder);
        this.explicitVR = param.explicitVR;
    }

    public int writeHeader(int tag, int vr, int len) throws IOException {
        this.bb12.clear();
        this.bb12.putShort((short)(tag >>> 16));
        this.bb12.putShort((short)tag);
        if (!this.explicitVR || vr == 0) {
            this.bb12.putInt(len);
            this.out.write(this.b12, 0, 8);
            return 8;
        }
        this.bb12.put((byte)(vr >>> 8));
        this.bb12.put((byte)vr);
        if (VRs.isLengthField16Bit(vr)) {
            this.bb12.putShort((short)len);
            this.out.write(this.b12, 0, 8);
            return 8;
        }
        this.bb12.put((byte)0);
        this.bb12.put((byte)0);
        this.bb12.putInt(len);
        this.out.write(this.b12, 0, 12);
        return 12;
    }

    public void startElement(int tag, int vr, long pos) throws IOException {
        this.tag = tag;
        this.vr = vr;
    }

    public void endElement() throws IOException {
    }

    public void startSequence(int len) throws IOException {
        this.writeHeader(this.tag, this.vr, len);
    }

    public void endSequence(int len) throws IOException {
        if (len == -1) {
            this.writeHeader(-73507, 0, 0);
        }
    }

    public void startItem(int id, long pos, int len) throws IOException {
        this.writeHeader(-73728, 0, len);
    }

    public void endItem(int len) throws IOException {
        if (len == -1) {
            this.writeHeader(-73715, 0, 0);
        }
    }

    public void value(byte[] data, int start, int length) throws IOException {
        this.writeHeader(this.tag, this.vr, length + 1 & 0xFFFFFFFE);
        this.out.write(data, start, length);
        if ((length & 1) != 0) {
            this.out.write(VRs.getPadding(this.vr));
        }
    }

    public void fragment(int id, long pos, byte[] data, int start, int length) throws IOException {
        this.writeHeader(-73728, 0, length + 1 & 0xFFFFFFFE);
        this.out.write(data, start, length);
        if ((length & 1) != 0) {
            this.out.write(0);
        }
    }
}

