/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.media.DirReader;
import org.dcm4che.media.DirRecord;
import org.dcm4cheri.media.DirRecordImpl;

class DirReaderImpl
implements DirReader {
    static final DcmParserFactory pfactory = DcmParserFactory.getInstance();
    static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    protected final File file;
    protected final ImageInputStream in;
    protected final DcmParser parser;
    protected Dataset fsi;
    protected int offFirstRootRec;
    protected int offLastRootRec;
    protected int seqLength;
    protected long offFirstRootRecValPos;
    protected long offLastRootRecValPos;
    protected long seqValuePos;

    DirReaderImpl(File file, ImageInputStream in) {
        this.file = file != null ? file.getAbsoluteFile() : null;
        this.in = in;
        this.parser = pfactory.newDcmParser(in);
    }

    DirReaderImpl initReader() throws IOException {
        this.fsi = factory.newDataset();
        this.parser.setDcmHandler(this.fsi.getDcmHandler());
        this.seqValuePos = this.parser.parseDcmFile(FileFormat.DICOM_FILE, 266784);
        this.parser.setDcmHandler(null);
        if (this.parser.getReadTag() != 266784) {
            throw new DcmValueException("Missing Directory Record Sequence");
        }
        this.seqLength = this.parser.getReadLength();
        DcmElement offFirstRootRecElem = this.fsi.get(266752);
        if (offFirstRootRecElem == null || offFirstRootRecElem.isEmpty()) {
            throw new DcmValueException("Missing Offset of First Directory Record");
        }
        this.offFirstRootRec = offFirstRootRecElem.getInt();
        this.offFirstRootRecValPos = offFirstRootRecElem.getStreamPosition() + 8L;
        DcmElement offLastRootRecElem = this.fsi.get(266754);
        if (offLastRootRecElem == null || offLastRootRecElem.isEmpty()) {
            throw new DcmValueException("Missing Offset of Last Directory Record");
        }
        this.offLastRootRec = offLastRootRecElem.getInt();
        this.offLastRootRecValPos = offLastRootRecElem.getStreamPosition() + 8L;
        return this;
    }

    public Dataset getFileSetInfo() {
        return this.fsi;
    }

    public File getRefFile(File root, String[] fileIDs) {
        File retval = new File(root, fileIDs[0]);
        for (int i = 1; i < fileIDs.length; ++i) {
            retval = new File(retval, fileIDs[i]);
        }
        return retval;
    }

    public File getRefFile(String[] fileIDs) {
        if (this.file == null) {
            throw new IllegalStateException("Unkown root directory");
        }
        return this.getRefFile(this.file.getParentFile(), fileIDs);
    }

    public File getDescriptorFile(File root) throws DcmValueException {
        String[] fileID = this.fsi.getStrings(266561);
        if (fileID == null || fileID.length == 0) {
            return null;
        }
        return this.getRefFile(root, fileID);
    }

    public File getDescriptorFile() throws DcmValueException {
        if (this.file == null) {
            throw new IllegalStateException("Unkown root directory");
        }
        return this.getDescriptorFile(this.file.getParentFile());
    }

    public boolean isEmpty(boolean onlyInUse) throws IOException {
        return this.getFirstRecord(onlyInUse) == null;
    }

    public DirRecord getFirstRecord() throws IOException {
        return this.getFirstRecord(true);
    }

    public DirRecord getFirstRecord(boolean onlyInUse) throws IOException {
        if (this.offFirstRootRec == 0) {
            return null;
        }
        DirRecordImpl retval = new DirRecordImpl(this.parser, this.offFirstRootRec);
        if (onlyInUse && retval.getInUseFlag() == 0) {
            return retval.getNextSibling(onlyInUse);
        }
        return retval;
    }

    public DirRecord getFirstRecordBy(String type, Dataset keys, boolean ignorePNCase) throws IOException {
        DirRecord dr = this.getFirstRecord(true);
        return dr == null || dr.match(type, keys, ignorePNCase) ? dr : dr.getNextSiblingBy(type, keys, ignorePNCase);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

