/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.dcm4che.hl7.HL7Exception;
import org.dcm4che.hl7.MSHSegment;
import org.dcm4cheri.hl7.HL7MessageImpl;
import org.dcm4cheri.hl7.HL7SegmentImpl;

public class MSHSegmentImpl
extends HL7SegmentImpl
implements MSHSegment {
    private static final byte[] START_WITH = new byte[]{77, 83, 72, 124, 94, 126, 92, 38, 124};
    private static final byte[] ACK = new byte[]{124, 124, 124, 65, 67, 75, 124, 65};
    private static final byte[] MSA = new byte[]{13, 77, 83, 65, 124};
    private static final byte[] ERR = new byte[]{13, 69, 82, 82, 124};
    private static final byte[] AA = new byte[]{65, 65};
    private static final byte[] AE = new byte[]{65, 69};
    private static final byte[] AR = new byte[]{65, 82};
    private static final HashMap csMap = new HashMap();

    MSHSegmentImpl(byte[] data) throws HL7Exception {
        this(data, 0, HL7MessageImpl.indexOfNextCRorLF(data, 0));
    }

    MSHSegmentImpl(byte[] data, int off, int len) throws HL7Exception {
        super(data, off, len);
        for (int i = 0; i < START_WITH.length; ++i) {
            if (data[off + i] == START_WITH[i]) continue;
            throw new IllegalArgumentException(this.toString());
        }
    }

    public int size() {
        return super.size() + 1;
    }

    public String get(int seq) {
        switch (seq) {
            case 0: {
                return "MSH";
            }
            case 1: {
                return "|";
            }
        }
        return super.get(seq - 1);
    }

    public String get(int seq, int rep) {
        if (seq < 2) {
            throw new IllegalArgumentException("seq: " + seq);
        }
        return super.get(seq - 1, rep);
    }

    public String get(int seq, int rep, int comp) {
        if (seq < 2) {
            throw new IllegalArgumentException("seq: " + seq);
        }
        return super.get(seq - 1, rep, comp);
    }

    public String get(int seq, int rep, int comp, int sub) {
        if (seq < 2) {
            throw new IllegalArgumentException("seq: " + seq);
        }
        return super.get(seq - 1, rep, comp, sub);
    }

    public void writeTo(int seq, ByteArrayOutputStream out) {
        if (seq < 2) {
            throw new IllegalArgumentException("seq: " + seq);
        }
        super.writeTo(seq - 1, out);
    }

    public String getMessageControlID() {
        return this.get(10);
    }

    public String getReceivingApplication() {
        return this.get(5);
    }

    public String getReceivingFacility() {
        return this.get(6);
    }

    public String getSendingApplication() {
        return this.get(3);
    }

    public String getSendingFacility() {
        return this.get(4);
    }

    public String getMessageType() {
        return this.get(9, 1, 1);
    }

    public String getTriggerEvent() {
        return this.get(9, 1, 2);
    }

    public String getCharacterSet() {
        return this.get(18);
    }

    public String getCharacterSetAsISO_IR() {
        return (String)csMap.get(this.getCharacterSet());
    }

    private void writeTo(byte[] b, ByteArrayOutputStream out) {
        out.write(b, 0, b.length);
    }

    public byte[] makeACK_AA() {
        return this.ack(AA, null, null, null);
    }

    public byte[] makeACK_AR(String errText, String errCode, String errComment) {
        return this.ack(AR, errText, errCode, errComment);
    }

    public byte[] makeACK_AE(String errText, String errCode, String errComment) {
        return this.ack(AE, errText, errCode, errComment);
    }

    byte[] ack(byte[] ackCode, String errText, String errCode, String errComment) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        this.writeTo(START_WITH, out);
        this.writeTo(5, out);
        out.write(124);
        this.writeTo(6, out);
        out.write(124);
        this.writeTo(3, out);
        out.write(124);
        this.writeTo(4, out);
        this.writeTo(ACK, out);
        this.writeTo(10, out);
        out.write(124);
        this.writeTo(11, out);
        out.write(124);
        this.writeTo(12, out);
        this.writeTo(MSA, out);
        this.writeTo(ackCode, out);
        out.write(124);
        this.writeTo(10, out);
        if (errText != null || errCode != null) {
            out.write(124);
            if (errText != null) {
                this.writeTo(errText.getBytes(), out);
            }
            if (errCode != null) {
                out.write(124);
                out.write(124);
                out.write(124);
                this.writeTo(errCode.getBytes(), out);
            }
        }
        if (errComment != null) {
            this.writeTo(ERR, out);
            this.writeTo(errComment.getBytes(), out);
        }
        out.write(13);
        return out.toByteArray();
    }

    static {
        csMap.put("", "ISO_IR 100");
        csMap.put("ASCII", "ISO_IR 100");
        csMap.put("8859/1", "ISO_IR 100");
        csMap.put("8859/2", "ISO_IR 101");
        csMap.put("8859/3", "ISO_IR 109");
        csMap.put("8859/4", "ISO_IR 110");
        csMap.put("8859/5", "ISO_IR 144");
        csMap.put("8859/6", "ISO_IR 127");
        csMap.put("8859/7", "ISO_IR 126");
        csMap.put("8859/8", "ISO_IR 138");
        csMap.put("8859/9", "ISO_IR 148");
    }
}

