/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4cheri.dict.UIDDictionaryLoader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UIDDictionaryImpl
implements UIDDictionary,
Serializable {
    static final long serialVersionUID = -4793624142653062179L;
    private transient HashMap map = new HashMap(257);

    public UIDDictionary.Entry lookup(String uid) {
        UIDDictionary.Entry entry = (UIDDictionary.Entry)this.map.get(uid);
        return entry != null ? entry : new UIDDictionary.Entry(uid, "?");
    }

    public String toString(String uid) {
        return this.lookup(uid).toString();
    }

    public final void add(UIDDictionary.Entry entry) {
        this.map.put(entry.uid, entry);
    }

    public int size() {
        return this.map.size();
    }

    public void load(InputSource xmlSource) throws IOException, SAXException {
        new UIDDictionaryLoader(this).parse(xmlSource);
    }

    public void load(File xmlFile) throws IOException, SAXException {
        new UIDDictionaryLoader(this).parse(xmlFile);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        Iterator iter = this.map.values().iterator();
        while (iter.hasNext()) {
            UIDDictionary.Entry e = (UIDDictionary.Entry)iter.next();
            out.writeUTF(e.uid);
            out.writeUTF(e.name);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int n = in.readInt();
        this.map = new HashMap(n * 4 / 3 + 1);
        for (int i = 0; i < n; ++i) {
            this.add(new UIDDictionary.Entry(in.readUTF(), in.readUTF()));
        }
    }
}

