/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4cheri.data.DatasetImpl;
import org.dcm4cheri.data.DcmElementImpl;

class SQElement
extends DcmElementImpl {
    private final ArrayList list = new ArrayList();
    private final Dataset parent;
    private int totlen = -1;

    public SQElement(int tag, Dataset parent) {
        super(tag);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DcmElement share() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                ((Dataset)this.list.get(i)).shareElements();
            }
        }
        return this;
    }

    public int hashCode() {
        return this.tag ^ this.list.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQElement)) {
            return false;
        }
        SQElement ve = (SQElement)o;
        if (this.tag != ve.tag) {
            return false;
        }
        return this.list.equals(ve.list);
    }

    public final int vr() {
        return 21329;
    }

    public final int vm(SpecificCharacterSet cs) {
        return this.countItems();
    }

    public final int countItems() {
        return this.list.size();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final int getLength() {
        return this.list.isEmpty() ? 0 : -1;
    }

    public final boolean hasItems() {
        return true;
    }

    public Dataset getItem(int index) {
        if (index >= this.list.size()) {
            return null;
        }
        return (Dataset)this.list.get(index);
    }

    public void addItem(Dataset item) {
        this.list.add(item);
    }

    public Dataset addNewItem() {
        DatasetImpl item = new DatasetImpl(this.parent);
        this.list.add(item);
        return item;
    }

    public int calcLength(DcmEncodeParam param) {
        this.totlen = param.undefSeqLen ? 8 : 0;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            this.totlen += this.getItem(i).calcLength(param) + (param.undefItemLen ? 16 : 8);
        }
        return this.totlen;
    }

    public int length() {
        return this.totlen;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(DICT.toString(this.tag));
        sb.append(",SQ");
        if (!this.isEmpty()) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                sb.append("\n\tItem-").append(i + 1).append(this.getItem(i));
            }
        }
        return sb.toString();
    }

    protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, Charset keyCS, Charset dsCS) {
        int m = key.countItems();
        for (int i = 0; i < m; ++i) {
            Dataset keys = key.getItem(i);
            int n = this.list.size();
            for (int j = 0; j < n; ++j) {
                if (!this.getItem(j).match(keys, ignorePNCase, ignoreEmpty)) continue;
                return true;
            }
        }
        return false;
    }
}

