/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import open.dolphin.client.BlockGlass;
import open.dolphin.client.editor.admin.AdminMasterPanel;
import open.dolphin.client.editor.diagnosis.DiagnosisMasterPanel;
import open.dolphin.client.editor.injectionmedicine.InjectionMedicineMasterPanel;
import open.dolphin.client.editor.medicalsupplies.MedicalSuppliesMasterPanel;
import open.dolphin.client.editor.toolmaterial.ToolMaterialMasterPanel;
import open.dolphin.client.editor.treatment.TreatmentMasterPanel;
import open.dolphin.order.AbstractMasterPanel;
import open.dolphin.order.ClaimConst;

public class MasterSetPanel
extends JPanel {
    private static final long serialVersionUID = 4282518548618120301L;
    private static final int DIGNOSIS_INDEX = 0;
    private static final int MEDICAL_TRAET_INDEX = 1;
    private static final int MEDICAL_SUPPLY_INDEX = 2;
    private static final int ADMIN_INDEX = 3;
    private static final int INJECTION_INDEX = 4;
    private static final int TOOL_MATERIAL_INDEX = 5;
    private DiagnosisMasterPanel diagnosis;
    private TreatmentMasterPanel treatment;
    private MedicalSuppliesMasterPanel medicalSupplies;
    private AdminMasterPanel administration;
    private InjectionMedicineMasterPanel injection;
    private ToolMaterialMasterPanel toolMaterial;
    private EnumSet<ClaimConst.MasterSet> masterSet;
    private BusyListener busyListener;
    private ItemCountListener itemCountListener;
    private JLabel classCodeLabel;
    private JLabel countLabel;
    private JPanel statusP;
    private JTabbedPane tabbedPane;

    public MasterSetPanel() {
        super(new BorderLayout(0, 11));
        EnumSet<ClaimConst.MasterSet[]> enumSet = EnumSet.of(ClaimConst.MasterSet.DIAGNOSIS, new ClaimConst.MasterSet[]{ClaimConst.MasterSet.TREATMENT, ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.ADMINISTRATION, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL});
        this.setMasterSet(enumSet);
        this.initInstances();
        this.initComponents();
        this.intialize();
    }

    public MasterSetPanel(EnumSet<ClaimConst.MasterSet> enumSet) {
        super(new BorderLayout());
        this.setMasterSet(enumSet);
        this.initInstances();
        this.initComponents();
        this.intialize();
    }

    public void dispose() {
        if (this.tabbedPane != null) {
            int cnt = this.tabbedPane.getTabCount();
            for (int i = 0; i < cnt; ++i) {
                AbstractMasterPanel mp = (AbstractMasterPanel)this.tabbedPane.getComponentAt(i);
                if (mp == null) continue;
                mp.dispose();
            }
        }
    }

    public EnumSet<ClaimConst.MasterSet> getMasterSet() {
        return this.masterSet;
    }

    public void setMasterSet(EnumSet<ClaimConst.MasterSet> masterSet) {
        this.masterSet = masterSet;
        if (this.tabbedPane != null) {
            this.enabled();
        }
    }

    public void setGlass(BlockGlass glass) {
    }

    private void initInstances() {
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.DIAGNOSIS)) {
            this.diagnosis = new DiagnosisMasterPanel(ClaimConst.MasterSet.DIAGNOSIS.getName());
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TREATMENT)) {
            this.treatment = new TreatmentMasterPanel(ClaimConst.MasterSet.TREATMENT.getName());
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.MEDICAL_SUPPLY)) {
            this.medicalSupplies = new MedicalSuppliesMasterPanel(ClaimConst.MasterSet.MEDICAL_SUPPLY.getName());
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.ADMINISTRATION)) {
            this.administration = new AdminMasterPanel(ClaimConst.MasterSet.ADMINISTRATION.getName());
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.INJECTION_MEDICINE)) {
            this.injection = new InjectionMedicineMasterPanel(ClaimConst.MasterSet.INJECTION_MEDICINE.getName());
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TOOL_MATERIAL)) {
            this.toolMaterial = new ToolMaterialMasterPanel(ClaimConst.MasterSet.TOOL_MATERIAL.getName());
        }
        this.busyListener = new BusyListener();
        this.itemCountListener = new ItemCountListener();
    }

    private void intialize() {
        this.enabled();
        this.countLabel.setText(this.paddCount(0));
        this.countLabel.setHorizontalAlignment(0);
        this.classCodeLabel.setHorizontalAlignment(0);
        Font font = new Font("Dialog", 0, 10);
        this.countLabel.setFont(font);
        this.classCodeLabel.setFont(font);
        this.statusP.setLayout(new FlowLayout(2));
        this.statusP.add(Box.createHorizontalStrut(6));
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.statusP, "South");
    }

    public void clear() {
        if (this.diagnosis != null) {
            this.diagnosis.clear();
        }
        if (this.treatment != null) {
            this.treatment.clear();
        }
        if (this.medicalSupplies != null) {
            this.medicalSupplies.clear();
        }
        if (this.administration != null) {
            this.administration.clear();
        }
        if (this.injection != null) {
            this.injection.clear();
        }
        if (this.toolMaterial != null) {
            this.toolMaterial.clear();
        }
    }

    public void setSearchClass(String serchClass) {
        this.treatment.setSearchClass(serchClass);
        if (serchClass != null) {
            this.classCodeLabel.setText("\u8a3a\u7642\u884c\u70ba:" + serchClass);
        } else {
            this.classCodeLabel.setText("\u8a3a\u7642\u884c\u70ba:100-999");
        }
    }

    public void setRadLocationEnabled(boolean enabled) {
        this.treatment.setRadLocationEnabled(enabled);
    }

    private void addListeners(PropertyChangeListener l) {
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.DIAGNOSIS)) {
            this.diagnosis.addPropertyChangeListener("selectedItemProp", l);
            this.diagnosis.addPropertyChangeListener("busyProp", this.busyListener);
            this.diagnosis.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TREATMENT)) {
            this.treatment.addPropertyChangeListener("selectedItemProp", l);
            this.treatment.addPropertyChangeListener("busyProp", this.busyListener);
            this.treatment.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.MEDICAL_SUPPLY)) {
            this.medicalSupplies.addPropertyChangeListener("selectedItemProp", l);
            this.medicalSupplies.addPropertyChangeListener("busyProp", this.busyListener);
            this.medicalSupplies.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.ADMINISTRATION)) {
            this.administration.addPropertyChangeListener("selectedItemProp", l);
            this.administration.addPropertyChangeListener("busyProp", this.busyListener);
            this.administration.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.INJECTION_MEDICINE)) {
            this.injection.addPropertyChangeListener("selectedItemProp", l);
            this.injection.addPropertyChangeListener("busyProp", this.busyListener);
            this.injection.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TOOL_MATERIAL)) {
            this.toolMaterial.addPropertyChangeListener("selectedItemProp", l);
            this.toolMaterial.addPropertyChangeListener("busyProp", this.busyListener);
            this.toolMaterial.addPropertyChangeListener("itemCount", this.itemCountListener);
        }
    }

    private void removeListeners(PropertyChangeListener l) {
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.DIAGNOSIS)) {
            this.diagnosis.removePropertyChangeListener("selectedItemProp", l);
            this.diagnosis.removePropertyChangeListener("busyProp", this.busyListener);
            this.diagnosis.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TREATMENT)) {
            this.treatment.removePropertyChangeListener("selectedItemProp", l);
            this.treatment.removePropertyChangeListener("busyProp", this.busyListener);
            this.treatment.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.MEDICAL_SUPPLY)) {
            this.medicalSupplies.removePropertyChangeListener("selectedItemProp", l);
            this.medicalSupplies.removePropertyChangeListener("busyProp", this.busyListener);
            this.medicalSupplies.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.ADMINISTRATION)) {
            this.administration.removePropertyChangeListener("selectedItemProp", l);
            this.administration.removePropertyChangeListener("busyProp", this.busyListener);
            this.administration.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.INJECTION_MEDICINE)) {
            this.injection.removePropertyChangeListener("selectedItemProp", l);
            this.injection.removePropertyChangeListener("busyProp", this.busyListener);
            this.injection.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TOOL_MATERIAL)) {
            this.toolMaterial.removePropertyChangeListener("selectedItemProp", l);
            this.toolMaterial.removePropertyChangeListener("busyProp", this.busyListener);
            this.toolMaterial.removePropertyChangeListener("itemCount", this.itemCountListener);
        }
    }

    private void enabled() {
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setEnabledAt(1, false);
        this.tabbedPane.setEnabledAt(2, false);
        this.tabbedPane.setEnabledAt(3, false);
        this.tabbedPane.setEnabledAt(4, false);
        this.tabbedPane.setEnabledAt(5, false);
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.DIAGNOSIS)) {
            this.tabbedPane.setEnabledAt(0, true);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TREATMENT)) {
            this.tabbedPane.setEnabledAt(1, true);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.MEDICAL_SUPPLY)) {
            this.tabbedPane.setEnabledAt(2, true);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.ADMINISTRATION)) {
            this.tabbedPane.setEnabledAt(3, true);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.INJECTION_MEDICINE)) {
            this.tabbedPane.setEnabledAt(4, true);
            this.tabbedPane.setEnabledAt(2, true);
        }
        if (this.masterSet.contains((Object)ClaimConst.MasterSet.TOOL_MATERIAL)) {
            this.tabbedPane.setEnabledAt(5, true);
        }
    }

    public void startDiagnosis(PropertyChangeListener listener) {
        this.classCodeLabel.setText("MEDIS ICD10");
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.DIAGNOSIS);
        this.setMasterSet(enumSet);
        this.addListeners(listener);
        this.tabbedPane.setSelectedIndex(0);
        this.diagnosis.enter();
    }

    public void stopDiagnosis(PropertyChangeListener listener) {
        this.removeListeners(listener);
    }

    public void startMedicine(PropertyChangeListener editor) {
        this.classCodeLabel.setText("\u8a3a\u7642\u884c\u70ba:210-230");
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.ADMINISTRATION, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.setMasterSet(enumSet);
        this.addListeners(editor);
        this.tabbedPane.setSelectedIndex(2);
    }

    public void stopMedicine(PropertyChangeListener editor) {
        this.removeListeners(editor);
    }

    public void startInjection(PropertyChangeListener editor) {
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.TREATMENT, ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.setMasterSet(enumSet);
        this.addListeners(editor);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void stopInjection(PropertyChangeListener editor) {
        this.removeListeners(editor);
    }

    public void startCharge(PropertyChangeListener editor) {
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.TREATMENT);
        this.setMasterSet(enumSet);
        this.addListeners(editor);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void stopCharge(PropertyChangeListener editor) {
        this.removeListeners(editor);
    }

    public void startTest(PropertyChangeListener editor) {
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.TREATMENT, ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.setMasterSet(enumSet);
        this.addListeners(editor);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void stopTest(PropertyChangeListener editor) {
        this.removeListeners(editor);
    }

    public void startGeneral(PropertyChangeListener editor) {
        this.treatment.setSearchClass(null);
        EnumSet<ClaimConst.MasterSet> enumSet = EnumSet.of(ClaimConst.MasterSet.TREATMENT, ClaimConst.MasterSet.MEDICAL_SUPPLY, ClaimConst.MasterSet.INJECTION_MEDICINE, ClaimConst.MasterSet.TOOL_MATERIAL);
        this.setMasterSet(enumSet);
        this.addListeners(editor);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void stopGeneral(PropertyChangeListener editor) {
        this.removeListeners(editor);
    }

    protected BlockGlass getBlockGlass() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            Window frame;
            Component c = null;
            if (w instanceof JDialog) {
                frame = (JDialog)w;
                c = ((JDialog)frame).getGlassPane();
            }
            if (w instanceof JFrame) {
                frame = (JFrame)w;
                c = ((JFrame)frame).getGlassPane();
            }
            return c != null && c instanceof BlockGlass ? (BlockGlass)c : null;
        }
        return null;
    }

    protected void block() {
        BlockGlass glass = this.getBlockGlass();
        if (glass != null) {
            glass.block();
        }
    }

    protected void unblock() {
        BlockGlass glass = this.getBlockGlass();
        if (glass != null) {
            glass.unblock();
        }
    }

    private String paddCount(int num) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u4ef6\u6570:");
        String numStr = String.valueOf(num);
        int len = numStr.length();
        int cnt = 4 - len;
        for (int i = 0; i < cnt; ++i) {
            sb.append(" ");
        }
        sb.append(numStr);
        return sb.toString();
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(ClaimConst.MasterSet.DIAGNOSIS.getDispName(), this.diagnosis);
        this.tabbedPane.addTab(ClaimConst.MasterSet.TREATMENT.getDispName(), this.treatment);
        this.tabbedPane.addTab(ClaimConst.MasterSet.MEDICAL_SUPPLY.getDispName(), this.medicalSupplies);
        this.tabbedPane.addTab(ClaimConst.MasterSet.ADMINISTRATION.getDispName(), this.administration);
        this.tabbedPane.addTab(ClaimConst.MasterSet.INJECTION_MEDICINE.getDispName(), this.injection);
        this.tabbedPane.addTab(ClaimConst.MasterSet.TOOL_MATERIAL.getDispName(), this.toolMaterial);
        this.statusP = new JPanel();
        this.countLabel = new JLabel();
        this.classCodeLabel = new JLabel();
        this.tabbedPane.setName("tabbedPane");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MasterSetPanel.this.tabbedPaneStateChanged(evt);
            }
        });
        this.statusP.setName("statusP");
        this.countLabel.setName("countLabel");
        this.classCodeLabel.setName("classCodeLabel");
        GroupLayout statusPLayout = new GroupLayout(this.statusP);
        this.statusP.setLayout(statusPLayout);
        statusPLayout.setHorizontalGroup(statusPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPLayout.createSequentialGroup().addGap(215, 215, 215).addComponent(this.countLabel, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addComponent(this.classCodeLabel, -2, 74, -2).addContainerGap()));
        statusPLayout.setVerticalGroup(statusPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPLayout.createSequentialGroup().addContainerGap().addGroup(statusPLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.countLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.classCodeLabel, GroupLayout.Alignment.LEADING, -1, 18, Short.MAX_VALUE)).addGap(10, 10, 10)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusP, -1, -1, Short.MAX_VALUE).addComponent(this.tabbedPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 260, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusP, -2, -1, -2)));
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        int index = this.tabbedPane.getSelectedIndex();
        AbstractMasterPanel masterPanel = (AbstractMasterPanel)this.tabbedPane.getComponentAt(index);
        masterPanel.enter();
    }

    protected class ItemCountListener
    implements PropertyChangeListener {
        protected ItemCountListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("itemCount")) {
                int count = (Integer)e.getNewValue();
                MasterSetPanel.this.countLabel.setText(MasterSetPanel.this.paddCount(count));
            }
        }
    }

    protected class BusyListener
    implements PropertyChangeListener {
        protected BusyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("busyProp")) {
                boolean busy = (Boolean)e.getNewValue();
                if (busy) {
                    MasterSetPanel.this.countLabel.setText("\u4ef6\u6570:  ? ");
                    MasterSetPanel.this.block();
                } else {
                    MasterSetPanel.this.unblock();
                }
            }
        }
    }
}

