/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.UserIdentityRQ;
import org.dcm4cheri.net.AAbortImpl;

final class UserIdentityRQImpl
implements UserIdentityRQ {
    private static final byte[] EMPTY = new byte[0];
    private final int userIdentityType;
    private final boolean positiveResponseRequested;
    private final byte[] primaryField;
    private final byte[] secondaryField;

    UserIdentityRQImpl(int userIdentityType, boolean positiveResponseRequested, byte[] primaryField) {
        this.userIdentityType = userIdentityType;
        this.positiveResponseRequested = positiveResponseRequested;
        this.primaryField = (byte[])primaryField.clone();
        this.secondaryField = EMPTY;
    }

    UserIdentityRQImpl(boolean positiveResponseRequested, String username, String passcode) {
        this.userIdentityType = passcode == null ? 1 : 2;
        this.positiveResponseRequested = positiveResponseRequested;
        this.primaryField = UserIdentityRQImpl.toBytes(username);
        this.secondaryField = passcode == null ? EMPTY : UserIdentityRQImpl.toBytes(passcode);
    }

    UserIdentityRQImpl(DataInputStream din, int len) throws IOException {
        this.userIdentityType = din.readUnsignedByte();
        this.positiveResponseRequested = din.readBoolean();
        int primaryFieldLen = din.readUnsignedShort();
        if (primaryFieldLen + 6 > len) {
            throw new PDUException("User Identity sub-item length: " + len + " mismatch primary-field-length:" + primaryFieldLen, new AAbortImpl(2, 6));
        }
        this.primaryField = new byte[primaryFieldLen];
        din.read(this.primaryField);
        int secondaryFieldLen = din.readUnsignedShort();
        if (secondaryFieldLen + primaryFieldLen + 6 != len) {
            throw new PDUException("User Identity sub-item length: " + len + " mismatch secondary-field-length:" + secondaryFieldLen, new AAbortImpl(2, 6));
        }
        this.secondaryField = new byte[secondaryFieldLen];
        din.read(this.secondaryField);
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(88);
        dout.write(0);
        dout.writeShort(this.length());
        dout.write(this.userIdentityType);
        dout.writeBoolean(this.positiveResponseRequested);
        dout.writeShort(this.primaryField.length);
        dout.write(this.primaryField);
        dout.writeShort(this.secondaryField.length);
        dout.write(this.secondaryField);
    }

    public final int getUserIdentityType() {
        return this.userIdentityType;
    }

    public final boolean isPositiveResponseRequested() {
        return this.positiveResponseRequested;
    }

    public final byte[] getPrimaryField() {
        return (byte[])this.primaryField.clone();
    }

    public final byte[] getSecondaryField() {
        return (byte[])this.secondaryField.clone();
    }

    public String getUsername() {
        return UserIdentityRQImpl.toString(this.primaryField);
    }

    public String getPasscode() {
        return UserIdentityRQImpl.toString(this.secondaryField);
    }

    private static String toString(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int length() {
        return 6 + this.primaryField.length + this.secondaryField.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("UserIdentity[type = ").append(this.userIdentityType);
        if (this.userIdentityType == 1 || this.userIdentityType == 2) {
            sb.append(", username = ").append(this.getUsername());
            if (this.userIdentityType == 2) {
                sb.append(", passcode = ");
                int i = this.secondaryField.length;
                while (--i >= 0) {
                    sb.append('*');
                }
            }
        } else {
            sb.append(", primaryField(").append(this.primaryField.length);
            sb.append("), secondaryField(").append(this.secondaryField.length);
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

