/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4cheri.data.FileMetaInfoImpl;

class DcmObjectHandlerImpl
implements DcmHandler {
    private final DcmObject result;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private DcmObject curDcmObject;
    private int tag;
    private int vr;
    private long pos;
    private final LinkedList seqStack = new LinkedList();

    public DcmObjectHandlerImpl(DcmObject result) {
        if (result == null) {
            throw new NullPointerException();
        }
        this.result = result;
    }

    public void startCommand() {
        this.curDcmObject = (Command)this.result;
        this.seqStack.clear();
    }

    public void endCommand() {
        this.curDcmObject = null;
    }

    public void startDcmFile() {
    }

    public void endDcmFile() {
    }

    public void startFileMetaInfo(byte[] preamble) {
        if (this.result instanceof Dataset) {
            this.curDcmObject = ((Dataset)this.result).getFileMetaInfo();
            if (this.curDcmObject == null) {
                this.curDcmObject = new FileMetaInfoImpl();
                ((Dataset)this.result).setFileMetaInfo((FileMetaInfo)this.curDcmObject);
            }
        } else {
            this.curDcmObject = (FileMetaInfo)this.result;
        }
        ((FileMetaInfo)this.curDcmObject).setPreamble(preamble);
        this.seqStack.clear();
    }

    public void endFileMetaInfo() {
        this.curDcmObject = this.result instanceof Dataset ? this.result : null;
    }

    public void startDataset() {
        this.curDcmObject = (Dataset)this.result;
        this.seqStack.clear();
    }

    public void endDataset() {
        this.curDcmObject = null;
    }

    public void setDcmDecodeParam(DcmDecodeParam param) {
        this.byteOrder = param.byteOrder;
    }

    public void startElement(int tag, int vr, long pos) throws IOException {
        this.tag = tag;
        this.vr = vr;
        this.pos = pos;
    }

    public void endElement() throws IOException {
    }

    public void startSequence(int length) throws IOException {
        this.seqStack.add(this.vr == 21329 ? this.curDcmObject.putSQ(this.tag) : this.curDcmObject.putXXsq(this.tag, this.vr));
    }

    public void endSequence(int length) throws IOException {
        this.seqStack.removeLast();
    }

    public void value(byte[] data, int start, int length) throws IOException {
        this.curDcmObject.putXX(this.tag, this.vr, ByteBuffer.wrap(data, start, length).order(this.byteOrder)).setStreamPosition(this.pos);
    }

    public void fragment(int id, long pos, byte[] data, int start, int length) throws IOException {
        ((DcmElement)this.seqStack.getLast()).addDataFragment(ByteBuffer.wrap(data, start, length).order(this.byteOrder));
    }

    public void startItem(int id, long pos, int length) throws IOException {
        this.curDcmObject = ((DcmElement)this.seqStack.getLast()).addNewItem().setItemOffset(pos);
    }

    public void endItem(int len) throws IOException {
        this.curDcmObject = ((Dataset)this.curDcmObject).getParent();
    }
}

