/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$HeadMethod == null ? (class$org$apache$commons$httpclient$methods$HeadMethod = HeadMethod.class$("org.apache.commons.httpclient.methods.HeadMethod")) : class$org$apache$commons$httpclient$methods$HeadMethod));
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$HeadMethod;

    public HeadMethod() {
        this.setFollowRedirects(true);
    }

    public HeadMethod(String string) {
        super(string);
        this.setFollowRedirects(true);
    }

    public String getName() {
        return "HEAD";
    }

    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    protected void readResponseBody(HttpState httpState, HttpConnection httpConnection) throws HttpException, IOException {
        LOG.trace((Object)"enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        int n = this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
        if (n < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Check for non-compliant response body. Timeout in " + n + " ms"));
            }
            boolean bl = false;
            try {
                bl = httpConnection.isResponseAvailable(n);
            }
            catch (IOException iOException) {
                LOG.debug((Object)"An IOException occurred while testing if a response was available, we will assume one is not.", (Throwable)iOException);
                bl = false;
            }
            if (bl) {
                if (this.getParams().isParameterTrue("http.protocol.reject-head-body")) {
                    throw new ProtocolException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn((Object)"Body content returned in response to HTTP HEAD");
                super.readResponseBody(httpState, httpConnection);
            }
        }
    }

    public int getBodyCheckTimeout() {
        return this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
    }

    public void setBodyCheckTimeout(int n) {
        this.getParams().setIntParameter("http.protocol.head-body-timeout", n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

