/*	$OpenBSD: ar9285reg.h,v 1.3 2010/05/10 17:44:21 damien Exp $	*/

/*-
 * Copyright (c) 2009 Damien Bergamini <damien.bergamini@free.fr>
 * Copyright (c) 2008-2009 Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define AR9285_MAX_CHAINS	1

#define AR9285_PHY_CCA_MAX_GOOD_VALUE	(-118)

#define AR9285_CL_CAL_REDO_THRESH	1

/*
 * Analog registers.
 */
#define AR9285_AN_RF2G1			0x7820
#define AR9285_AN_RF2G2			0x7824
#define AR9285_AN_RF2G3			0x7828
#define AR9285_AN_RF2G4			0x782c
#define AR9285_AN_RF2G5			0x7830
#define AR9285_AN_RF2G6			0x7834
#define AR9285_AN_RF2G7			0x7838
#define AR9285_AN_RF2G8			0x783c
#define AR9285_AN_RF2G9			0x7840
#define AR9285_AN_RXTXBB1		0x7854
#define AR9285_AN_TOP2			0x7868
#define AR9285_AN_TOP3			0x786c
#define AR9285_AN_TOP4			0x7870

/* Bits for AR9285_AN_RF2G1. */
#define AR9285_AN_RF2G1_ENPACAL		0x00000800
#define AR9285_AN_RF2G1_PDPAOUT		0x00800000
#define AR9285_AN_RF2G1_PDPADRV2	0x01000000
#define AR9285_AN_RF2G1_PDPADRV1	0x02000000

/* Bits for AR9285_AN_RF2G2. */
#define AR9285_AN_RF2G2_OFFCAL	0x00001000

/* Bits for AR9285_AN_RF2G3. */
#define AR9285_AN_RF2G3_DB1_2_M		0x00000007
#define AR9285_AN_RF2G3_DB1_2_S		0
#define AR9285_AN_RF2G3_DB1_1_M		0x00000038
#define AR9285_AN_RF2G3_DB1_1_S		3
#define AR9285_AN_RF2G3_DB1_0_M		0x000001c0
#define AR9285_AN_RF2G3_DB1_0_S		6
#define AR9285_AN_RF2G3_OB_4_M		0x00000e00
#define AR9285_AN_RF2G3_OB_4_S		9
#define AR9285_AN_RF2G3_OB_3_M		0x00007000
#define AR9285_AN_RF2G3_OB_3_S		12
#define AR9285_AN_RF2G3_OB_2_M		0x00038000
#define AR9285_AN_RF2G3_OB_2_S		15
#define AR9285_AN_RF2G3_OB_1_M		0x001c0000
#define AR9285_AN_RF2G3_OB_1_S		18
#define AR9285_AN_RF2G3_OB_0_M		0x00e00000
#define AR9285_AN_RF2G3_OB_0_S		21
#define AR9285_AN_RF2G3_PDVCCOMP	0x02000000

/* Bits for AR9285_AN_RF2G4. */
#define AR9285_AN_RF2G4_DB2_4_M		0x00003800
#define AR9285_AN_RF2G4_DB2_4_S		11
#define AR9285_AN_RF2G4_DB2_3_M		0x0001c000
#define AR9285_AN_RF2G4_DB2_3_S		14
#define AR9285_AN_RF2G4_DB2_2_M		0x000e0000
#define AR9285_AN_RF2G4_DB2_2_S		17
#define AR9285_AN_RF2G4_DB2_1_M		0x00700000
#define AR9285_AN_RF2G4_DB2_1_S		20
#define AR9285_AN_RF2G4_DB2_0_M		0x03800000
#define AR9285_AN_RF2G4_DB2_0_S		23
#define AR9285_AN_RF2G4_DB1_4_M		0x1c000000
#define AR9285_AN_RF2G4_DB1_4_S		26
#define AR9285_AN_RF2G4_DB1_3_M		0xe0000000
#define AR9285_AN_RF2G4_DB1_3_S		29

/* Bits for AR9285_AN_RF2G5. */
#define AR9285_AN_RF2G5_IC50TX_M	0x00000700
#define AR9285_AN_RF2G5_IC50TX_S	8

/* Bits for AR9285_AN_RF2G6. */
#define AR9285_AN_RF2G6_CCOMP_M		0x00007800
#define AR9285_AN_RF2G6_CCOMP_S		11
#define AR9285_AN_RF2G6_OFFS_6_1	0x03f00000
#define AR9285_AN_RF2G6_OFFS(i)		(1 << (19 + (i)))

/* Bits for AR9285_AN_RF2G7. */
#define AR9285_AN_RF2G7_PWDDB		0x00000002
#define AR9285_AN_RF2G7_PADRVGN2TAB0_M	0xe0000000
#define AR9285_AN_RF2G7_PADRVGN2TAB0_S	29

/* Bits for AR9285_AN_RF2G8. */
#define AR9285_AN_RF2G8_PADRVGN2TAB0_M	0x0001c000
#define AR9285_AN_RF2G8_PADRVGN2TAB0_S	14

/* Bits for AR9285_AN_RXTXBB1. */
#define AR9285_AN_RXTXBB1_SPARE9	0x00000001
#define AR9285_AN_RXTXBB1_PDRXTXBB1	0x00000020
#define AR9285_AN_RXTXBB1_PDV2I		0x00000080
#define AR9285_AN_RXTXBB1_PDDACIF	0x00000100

/* Bits for AR9285_AN_TOP2. */
#define AR9285_AN_TOP2_DEFAULT		0xca0358a0	/* XXX magic */

/* Bits for AR9285_AN_TOP3. */
#define AR9285_AN_TOP3_XPABIAS_LVL_M	0x0000000c
#define AR9285_AN_TOP3_XPABIAS_LVL_S	2
#define AR9285_AN_TOP3_PWDDAC		0x00800000

/* Bits for AR9285_AN_TOP4. */
#define AR9285_AN_TOP4_DEFAULT		0x10142c00	/* XXX magic */
#define AR9285_AN_TOP4_UNLOCKED		0x10142c14	/* XXX magic */

/* Bits for AR_PHY_MULTICHAIN_GAIN_CTL. */
#define AR9285_PHY_ANT_DIV_CTL_ALL_M		0x7f000000
#define AR9285_PHY_ANT_DIV_CTL_ALL_S		24
#define AR9285_PHY_ANT_DIV_CTL_M		0x01000000
#define AR9285_PHY_ANT_DIV_CTL_S		24
#define AR9285_PHY_ANT_DIV_ALT_LNACONF_M	0x06000000
#define AR9285_PHY_ANT_DIV_ALT_LNACONF_S	25
#define AR9285_PHY_ANT_DIV_MAIN_LNACONF_M	0x18000000
#define AR9285_PHY_ANT_DIV_MAIN_LNACONF_S	27
#define AR9285_PHY_ANT_DIV_ALT_GAINTB_M		0x20000000
#define AR9285_PHY_ANT_DIV_ALT_GAINTB_S		29
#define AR9285_PHY_ANT_DIV_MAIN_GAINTB_M	0x40000000
#define AR9285_PHY_ANT_DIV_MAIN_GAINTB_S	30

/*
 * ROM layout used by AR9285 (single-stream, 2GHz only).
 */
#define AR9285_EEP_START_LOC		64
#define AR9285_NUM_2G_CAL_PIERS		3
#define AR9285_NUM_2G_CCK_TARGET_POWERS	3
#define AR9285_NUM_2G_20_TARGET_POWERS	3
#define AR9285_NUM_2G_40_TARGET_POWERS	3
#define AR9285_NUM_CTLS			12
#define AR9285_NUM_BAND_EDGES		4
#define AR9285_NUM_PD_GAINS		2
#define AR9285_PD_GAINS_IN_MASK		4
#define AR9285_PD_GAIN_ICEPTS		5

struct ar9285_base_eep_header {
	uint16_t	length;
	uint16_t	checksum;
	uint16_t	version;
	uint8_t		opCapFlags;
	uint8_t		eepMisc;
	uint16_t	regDmn[2];
	uint8_t		macAddr[6];
	uint8_t		rxMask;
	uint8_t		txMask;
	uint16_t	rfSilent;
	uint16_t	blueToothOptions;
	uint16_t	deviceCap;
	uint32_t	binBuildNumber;
	uint8_t		deviceType;
	/* End of common header. */
	uint8_t		txGainType;
} __packed;

struct ar9285_modal_eep_header {
	uint32_t	antCtrlChain;
	uint32_t	antCtrlCommon;
	uint8_t		antennaGain;
	uint8_t		switchSettling;
	uint8_t		txRxAtten;
	uint8_t		rxTxMargin;
	uint8_t		adcDesiredSize;
	uint8_t		pgaDesiredSize;
	uint8_t		xlnaGain;
	uint8_t		txEndToXpaOff;
	uint8_t		txEndToRxOn;
	uint8_t		txFrameToXpaOn;
	uint8_t		thresh62;
	uint8_t		noiseFloorThresh;
	uint8_t		xpdGain;
	uint8_t		xpd;
	uint8_t		iqCalI;
	uint8_t		iqCalQ;
	uint8_t		pdGainOverlap;
	uint8_t		ob_01;
	uint8_t		db1_01;
	uint8_t		xpaBiasLvl;
	uint8_t		txFrameToDataStart;
	uint8_t		txFrameToPaOn;
	uint8_t		ht40PowerIncForPdadc;
	uint8_t		bswAtten;
	uint8_t		bswMargin;
	uint8_t		swSettleHt40;
	uint8_t		xatten2Db;
	uint8_t		xatten2Margin;
	uint8_t		db2_01;
	uint8_t		version;
	uint16_t	ob_234;
	uint16_t	db1_234;
	uint16_t	db2_234;
	uint8_t		futureModal[4];
	struct		ar_spur_chan spurChans[AR_EEPROM_MODAL_SPURS];
} __packed;

struct ar9285_cal_data_per_freq {
	uint8_t	pwrPdg[AR9285_NUM_PD_GAINS][AR9285_PD_GAIN_ICEPTS];
	uint8_t	vpdPdg[AR9285_NUM_PD_GAINS][AR9285_PD_GAIN_ICEPTS];
} __packed;

struct ar9285_cal_ctl_data {
	struct ar_cal_ctl_edges	ctlEdges[AR9285_NUM_BAND_EDGES];
} __packed;

struct ar9285_eeprom {
	struct	ar9285_base_eep_header baseEepHeader;
	uint8_t	custData[20];
	struct	ar9285_modal_eep_header modalHeader;
	uint8_t	calFreqPier2G[AR9285_NUM_2G_CAL_PIERS];
	struct	ar9285_cal_data_per_freq
	    calPierData2G[AR9285_NUM_2G_CAL_PIERS];
	struct	ar_cal_target_power_leg
	    calTargetPowerCck[AR9285_NUM_2G_CCK_TARGET_POWERS];
	struct	ar_cal_target_power_leg
	    calTargetPower2G[AR9285_NUM_2G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower2GHT20[AR9285_NUM_2G_20_TARGET_POWERS];
	struct	ar_cal_target_power_ht
	    calTargetPower2GHT40[AR9285_NUM_2G_40_TARGET_POWERS];
	uint8_t	ctlIndex[AR9285_NUM_CTLS];
	struct	ar9285_cal_ctl_data ctlData[AR9285_NUM_CTLS];
	uint8_t	padding;
} __packed;

/* Macro to "pack" registers to 16-bit to save some .rodata space. */
#define P(x)	(x)

/*
 * AR9285 1.0 initialization values.
 */
static const uint16_t ar9285_1_0_regs[] = {
	P(0x01030), P(0x01070), P(0x010b0), P(0x010f0), P(0x08014),
	P(0x0801c), P(0x08318), P(0x09804), P(0x09820), P(0x09824),
	P(0x09828), P(0x09834), P(0x09838), P(0x09840), P(0x09844),
	P(0x09848), P(0x09850), P(0x09858), P(0x0985c), P(0x09860),
	P(0x09864), P(0x09868), P(0x0986c), P(0x09914), P(0x09918),
	P(0x09924), P(0x09944), P(0x09960), P(0x09964), P(0x099b8),
	P(0x099bc), P(0x099c0), P(0x099c4), P(0x099c8), P(0x099cc),
	P(0x099d0), P(0x099d4), P(0x099d8), P(0x09a00), P(0x09a04),
	P(0x09a08), P(0x09a0c), P(0x09a10), P(0x09a14), P(0x09a18),
	P(0x09a1c), P(0x09a20), P(0x09a24), P(0x09a28), P(0x09a2c),
	P(0x09a30), P(0x09a34), P(0x09a38), P(0x09a3c), P(0x09a40),
	P(0x09a44), P(0x09a48), P(0x09a4c), P(0x09a50), P(0x09a54),
	P(0x09a58), P(0x09a5c), P(0x09a60), P(0x09a64), P(0x09a68),
	P(0x09a6c), P(0x09a70), P(0x09a74), P(0x09a78), P(0x09a7c),
	P(0x09a80), P(0x09a84), P(0x09a88), P(0x09a8c), P(0x09a90),
	P(0x09a94), P(0x09a98), P(0x09a9c), P(0x09aa0), P(0x09aa4),
	P(0x09aa8), P(0x09aac), P(0x09ab0), P(0x09ab4), P(0x09ab8),
	P(0x09abc), P(0x09ac0), P(0x09ac4), P(0x09ac8), P(0x09acc),
	P(0x09ad0), P(0x09ad4), P(0x09ad8), P(0x09adc), P(0x09ae0),
	P(0x09ae4), P(0x09ae8), P(0x09aec), P(0x09af0), P(0x09af4),
	P(0x09af8), P(0x09afc), P(0x09b00), P(0x09b04), P(0x09b08),
	P(0x09b0c), P(0x09b10), P(0x09b14), P(0x09b18), P(0x09b1c),
	P(0x09b20), P(0x09b24), P(0x09b28), P(0x09b2c), P(0x09b30),
	P(0x09b34), P(0x09b38), P(0x09b3c), P(0x09b40), P(0x09b44),
	P(0x09b48), P(0x09b4c), P(0x09b50), P(0x09b54), P(0x09b58),
	P(0x09b5c), P(0x09b60), P(0x09b64), P(0x09b68), P(0x09b6c),
	P(0x09b70), P(0x09b74), P(0x09b78), P(0x09b7c), P(0x09b80),
	P(0x09b84), P(0x09b88), P(0x09b8c), P(0x09b90), P(0x09b94),
	P(0x09b98), P(0x09b9c), P(0x09ba0), P(0x09ba4), P(0x09ba8),
	P(0x09bac), P(0x09bb0), P(0x09bb4), P(0x09bb8), P(0x09bbc),
	P(0x09bc0), P(0x09bc4), P(0x09bc8), P(0x09bcc), P(0x09bd0),
	P(0x09bd4), P(0x09bd8), P(0x09bdc), P(0x09be0), P(0x09be4),
	P(0x09be8), P(0x09bec), P(0x09bf0), P(0x09bf4), P(0x09bf8),
	P(0x09bfc), P(0x0aa00), P(0x0aa04), P(0x0aa08), P(0x0aa0c),
	P(0x0aa10), P(0x0aa14), P(0x0aa18), P(0x0aa1c), P(0x0aa20),
	P(0x0aa24), P(0x0aa28), P(0x0aa2c), P(0x0aa30), P(0x0aa34),
	P(0x0aa38), P(0x0aa3c), P(0x0aa40), P(0x0aa44), P(0x0aa48),
	P(0x0aa4c), P(0x0aa50), P(0x0aa54), P(0x0aa58), P(0x0aa5c),
	P(0x0aa60), P(0x0aa64), P(0x0aa68), P(0x0aa6c), P(0x0aa70),
	P(0x0aa74), P(0x0aa78), P(0x0aa7c), P(0x0aa80), P(0x0aa84),
	P(0x0aa88), P(0x0aa8c), P(0x0aa90), P(0x0aa94), P(0x0aa98),
	P(0x0aa9c), P(0x0aaa0), P(0x0aaa4), P(0x0aaa8), P(0x0aaac),
	P(0x0aab0), P(0x0aab4), P(0x0aab8), P(0x0aabc), P(0x0aac0),
	P(0x0aac4), P(0x0aac8), P(0x0aacc), P(0x0aad0), P(0x0aad4),
	P(0x0aad8), P(0x0aadc), P(0x0aae0), P(0x0aae4), P(0x0aae8),
	P(0x0aaec), P(0x0aaf0), P(0x0aaf4), P(0x0aaf8), P(0x0aafc),
	P(0x0ab00), P(0x0ab04), P(0x0ab08), P(0x0ab0c), P(0x0ab10),
	P(0x0ab14), P(0x0ab18), P(0x0ab1c), P(0x0ab20), P(0x0ab24),
	P(0x0ab28), P(0x0ab2c), P(0x0ab30), P(0x0ab34), P(0x0ab38),
	P(0x0ab3c), P(0x0ab40), P(0x0ab44), P(0x0ab48), P(0x0ab4c),
	P(0x0ab50), P(0x0ab54), P(0x0ab58), P(0x0ab5c), P(0x0ab60),
	P(0x0ab64), P(0x0ab68), P(0x0ab6c), P(0x0ab70), P(0x0ab74),
	P(0x0ab78), P(0x0ab7c), P(0x0ab80), P(0x0ab84), P(0x0ab88),
	P(0x0ab8c), P(0x0ab90), P(0x0ab94), P(0x0ab98), P(0x0ab9c),
	P(0x0aba0), P(0x0aba4), P(0x0aba8), P(0x0abac), P(0x0abb0),
	P(0x0abb4), P(0x0abb8), P(0x0abbc), P(0x0abc0), P(0x0abc4),
	P(0x0abc8), P(0x0abcc), P(0x0abd0), P(0x0abd4), P(0x0abd8),
	P(0x0abdc), P(0x0abe0), P(0x0abe4), P(0x0abe8), P(0x0abec),
	P(0x0abf0), P(0x0abf4), P(0x0abf8), P(0x0abfc), P(0x0a204),
	P(0x0a20c), P(0x0a21c), P(0x0a230), P(0x0a250), P(0x0a274),
	P(0x0a300), P(0x0a304), P(0x0a308), P(0x0a30c), P(0x0a310),
	P(0x0a314), P(0x0a318), P(0x0a31c), P(0x0a320), P(0x0a324),
	P(0x0a328), P(0x0a32c), P(0x0a330), P(0x0a334), P(0x0a338),
	P(0x0a33c), P(0x0a340), P(0x0a344), P(0x0a358)
};

#ifndef IEEE80211_NO_HT
static const uint32_t ar9285_1_0_vals_2g40[] = {
	0x000002c0, 0x00000318, 0x00007c70, 0x00000000, 0x10801600,
	0x12e00057, 0x00006880, 0x000003c4, 0x02020200, 0x00000e0e,
	0x0a020001, 0x00000e0e, 0x00000007, 0x206a012e, 0x03720020,
	0x0000004e, 0x6d4000e2, 0x7ec84d2e, 0x3136605e, 0x00058d20,
	0x0001ce00, 0x5ac640d0, 0x06903881, 0x00001130, 0x00000016,
	0xd00a800d, 0xdfbc1020, 0x00000000, 0x00000000, 0x00cf4d1c,
	0x00000c00, 0x05eea6d4, 0x06336f77, 0x60f65329, 0x08f186c8,
	0x00046384, 0x00000000, 0x00000000, 0x00068084, 0x00068088,
	0x0006808c, 0x00068100, 0x00068104, 0x00068108, 0x0006810c,
	0x00068110, 0x00068114, 0x00068180, 0x00068184, 0x00068188,
	0x0006818c, 0x00068190, 0x00068194, 0x000681a0, 0x0006820c,
	0x000681a8, 0x00068284, 0x00068288, 0x00068220, 0x00068290,
	0x00068300, 0x00068304, 0x00068308, 0x0006830c, 0x00068380,
	0x00068384, 0x00068700, 0x00068704, 0x00068708, 0x0006870c,
	0x00068780, 0x00068784, 0x00068b04, 0x00068b08, 0x00068b08,
	0x00068b0c, 0x00068b80, 0x00068b84, 0x00068b88, 0x00068b8c,
	0x000b8b90, 0x000b8f80, 0x000b8f84, 0x000b8f88, 0x000b8f8c,
	0x000b8f90, 0x000bb30c, 0x000bb310, 0x000bb384, 0x000bb388,
	0x000bb324, 0x000bb704, 0x000f96a4, 0x000f96a8, 0x000f9710,
	0x000f9714, 0x000f9720, 0x000f9724, 0x000f9728, 0x000f972c,
	0x000f97a0, 0x000f97a4, 0x000fb7a8, 0x000fb7b0, 0x000fb7b4,
	0x000fb7b8, 0x000fb7a5, 0x000fb7a9, 0x000fb7ad, 0x000fb7b1,
	0x000fb7b5, 0x000fb7b9, 0x000fb7c5, 0x000fb7c9, 0x000fb7d1,
	0x000fb7d5, 0x000fb7d9, 0x000fb7c6, 0x000fb7ca, 0x000fb7ce,
	0x000fb7d2, 0x000fb7d6, 0x000fb7c3, 0x000fb7c7, 0x000fb7cb,
	0x000fb7cf, 0x000fb7d7, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x0006801c, 0x00068080, 0x00068084, 0x00068088,
	0x0006808c, 0x00068100, 0x00068104, 0x00068108, 0x0006810c,
	0x00068110, 0x00068110, 0x00068180, 0x00068184, 0x00068188,
	0x0006818c, 0x00068190, 0x00068194, 0x000681a0, 0x0006820c,
	0x000681a8, 0x000681ac, 0x0006821c, 0x00068224, 0x00068290,
	0x00068300, 0x00068308, 0x0006830c, 0x00068310, 0x00068788,
	0x0006878c, 0x00068790, 0x00068794, 0x00068798, 0x0006879c,
	0x00068b89, 0x00068b8d, 0x00068b91, 0x00068b95, 0x00068b99,
	0x00068ba5, 0x00068ba9, 0x00068bad, 0x000b8b0c, 0x000b8f10,
	0x000b8f14, 0x000b8f84, 0x000b8f84, 0x000b8f88, 0x000bb380,
	0x000bb384, 0x000bb388, 0x000bb38c, 0x000bb394, 0x000bb798,
	0x000f970c, 0x000f9710, 0x000f9714, 0x000f9718, 0x000f9705,
	0x000f9709, 0x000f970d, 0x000f9711, 0x000f9715, 0x000f9719,
	0x000fb7a4, 0x000fb7a8, 0x000fb7ac, 0x000fb7ac, 0x000fb7b0,
	0x000fb7b8, 0x000fb7bc, 0x000fb7a1, 0x000fb7a5, 0x000fb7a9,
	0x000fb7b1, 0x000fb7b5, 0x000fb7bd, 0x000fb7c9, 0x000fb7cd,
	0x000fb7d1, 0x000fb7d9, 0x000fb7c2, 0x000fb7c6, 0x000fb7ca,
	0x000fb7ce, 0x000fb7d2, 0x000fb7d6, 0x000fb7c3, 0x000fb7cb,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x00000004,
	0x00000000, 0x1883800a, 0x00000210, 0x001ca000, 0x0a820652,
	0x00000000, 0x00007201, 0x00010408, 0x0001860a, 0x00020818,
	0x00024858, 0x00026859, 0x0002985b, 0x0002c89a, 0x0002e89b,
	0x0003089c, 0x0003289d, 0x0003489e, 0x000388de, 0x0003b91e,
	0x0003d95e, 0x000419df, 0x0003e9df, 0x7999aa0e
};
#endif

static const uint32_t ar9285_1_0_vals_2g20[] = {
	0x00000160, 0x0000018c, 0x00003e38, 0x00000000, 0x08400b00,
	0x12e0002b, 0x00003440, 0x00000300, 0x02020200, 0x00000e0e,
	0x0a020001, 0x00000e0e, 0x00000007, 0x206a012e, 0x03720020,
	0x0000004e, 0x6d4000e2, 0x7ec84d2e, 0x3136605e, 0x00058d20,
	0x0001ce00, 0x5ac640d0, 0x06903881, 0x00000898, 0x0000000b,
	0xd00a800d, 0xdfbc1020, 0x00000000, 0x00000000, 0x00cf4d1c,
	0x00000c00, 0x05eea6d4, 0x06336f77, 0x60f65329, 0x08f186c8,
	0x00046384, 0x00000000, 0x00000000, 0x00068084, 0x00068088,
	0x0006808c, 0x00068100, 0x00068104, 0x00068108, 0x0006810c,
	0x00068110, 0x00068114, 0x00068180, 0x00068184, 0x00068188,
	0x0006818c, 0x00068190, 0x00068194, 0x000681a0, 0x0006820c,
	0x000681a8, 0x00068284, 0x00068288, 0x00068220, 0x00068290,
	0x00068300, 0x00068304, 0x00068308, 0x0006830c, 0x00068380,
	0x00068384, 0x00068700, 0x00068704, 0x00068708, 0x0006870c,
	0x00068780, 0x00068784, 0x00068b04, 0x00068b08, 0x00068b08,
	0x00068b0c, 0x00068b80, 0x00068b84, 0x00068b88, 0x00068b8c,
	0x000b8b90, 0x000b8f80, 0x000b8f84, 0x000b8f88, 0x000b8f8c,
	0x000b8f90, 0x000bb30c, 0x000bb310, 0x000bb384, 0x000bb388,
	0x000bb324, 0x000bb704, 0x000f96a4, 0x000f96a8, 0x000f9710,
	0x000f9714, 0x000f9720, 0x000f9724, 0x000f9728, 0x000f972c,
	0x000f97a0, 0x000f97a4, 0x000fb7a8, 0x000fb7b0, 0x000fb7b4,
	0x000fb7b8, 0x000fb7a5, 0x000fb7a9, 0x000fb7ad, 0x000fb7b1,
	0x000fb7b5, 0x000fb7b9, 0x000fb7c5, 0x000fb7c9, 0x000fb7d1,
	0x000fb7d5, 0x000fb7d9, 0x000fb7c6, 0x000fb7ca, 0x000fb7ce,
	0x000fb7d2, 0x000fb7d6, 0x000fb7c3, 0x000fb7c7, 0x000fb7cb,
	0x000fb7cf, 0x000fb7d7, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db, 0x000fb7db,
	0x000fb7db, 0x0006801c, 0x00068080, 0x00068084, 0x00068088,
	0x0006808c, 0x00068100, 0x00068104, 0x00068108, 0x0006810c,
	0x00068110, 0x00068110, 0x00068180, 0x00068184, 0x00068188,
	0x0006818c, 0x00068190, 0x00068194, 0x000681a0, 0x0006820c,
	0x000681a8, 0x000681ac, 0x0006821c, 0x00068224, 0x00068290,
	0x00068300, 0x00068308, 0x0006830c, 0x00068310, 0x00068788,
	0x0006878c, 0x00068790, 0x00068794, 0x00068798, 0x0006879c,
	0x00068b89, 0x00068b8d, 0x00068b91, 0x00068b95, 0x00068b99,
	0x00068ba5, 0x00068ba9, 0x00068bad, 0x000b8b0c, 0x000b8f10,
	0x000b8f14, 0x000b8f84, 0x000b8f84, 0x000b8f88, 0x000bb380,
	0x000bb384, 0x000bb388, 0x000bb38c, 0x000bb394, 0x000bb798,
	0x000f970c, 0x000f9710, 0x000f9714, 0x000f9718, 0x000f9705,
	0x000f9709, 0x000f970d, 0x000f9711, 0x000f9715, 0x000f9719,
	0x000fb7a4, 0x000fb7a8, 0x000fb7ac, 0x000fb7ac, 0x000fb7b0,
	0x000fb7b8, 0x000fb7bc, 0x000fb7a1, 0x000fb7a5, 0x000fb7a9,
	0x000fb7b1, 0x000fb7b5, 0x000fb7bd, 0x000fb7c9, 0x000fb7cd,
	0x000fb7d1, 0x000fb7d9, 0x000fb7c2, 0x000fb7c6, 0x000fb7ca,
	0x000fb7ce, 0x000fb7d2, 0x000fb7d6, 0x000fb7c3, 0x000fb7cb,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3,
	0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x000fb7d3, 0x00000004,
	0x00000000, 0x1883800a, 0x00000108, 0x001ca000, 0x0a820652,
	0x00000000, 0x00007201, 0x00010408, 0x0001860a, 0x00020818,
	0x00024858, 0x00026859, 0x0002985b, 0x0002c89a, 0x0002e89b,
	0x0003089c, 0x0003289d, 0x0003489e, 0x000388de, 0x0003b91e,
	0x0003d95e, 0x000419df, 0x0003e9df, 0x7999aa0e
};

static const uint16_t ar9285_1_0_cm_regs[] = {
	P(0x0000c), P(0x00030), P(0x00034), P(0x00040), P(0x00044),
	P(0x00048), P(0x0004c), P(0x00050), P(0x00054), P(0x00800),
	P(0x00804), P(0x00808), P(0x0080c), P(0x00810), P(0x00814),
	P(0x00818), P(0x0081c), P(0x00820), P(0x00824), P(0x01040),
	P(0x01044), P(0x01048), P(0x0104c), P(0x01050), P(0x01054),
	P(0x01058), P(0x0105c), P(0x01060), P(0x01064), P(0x01230),
	P(0x01270), P(0x01038), P(0x01078), P(0x010b8), P(0x010f8),
	P(0x01138), P(0x01178), P(0x011b8), P(0x011f8), P(0x01238),
	P(0x01278), P(0x012b8), P(0x012f8), P(0x01338), P(0x01378),
	P(0x013b8), P(0x013f8), P(0x01438), P(0x01478), P(0x014b8),
	P(0x014f8), P(0x01538), P(0x01578), P(0x015b8), P(0x015f8),
	P(0x01638), P(0x01678), P(0x016b8), P(0x016f8), P(0x01738),
	P(0x01778), P(0x017b8), P(0x017f8), P(0x0103c), P(0x0107c),
	P(0x010bc), P(0x010fc), P(0x0113c), P(0x0117c), P(0x011bc),
	P(0x011fc), P(0x0123c), P(0x0127c), P(0x012bc), P(0x012fc),
	P(0x0133c), P(0x0137c), P(0x013bc), P(0x013fc), P(0x0143c),
	P(0x0147c), P(0x04030), P(0x0403c), P(0x04024), P(0x04060),
	P(0x04064), P(0x07010), P(0x07034), P(0x07038), P(0x08004),
	P(0x08008), P(0x0800c), P(0x08018), P(0x08020), P(0x08038),
	P(0x0803c), P(0x08048), P(0x08054), P(0x08058), P(0x0805c),
	P(0x08060), P(0x08064), P(0x08070), P(0x080c0), P(0x080c4),
	P(0x080c8), P(0x080cc), P(0x080d0), P(0x080d4), P(0x080d8),
	P(0x080e0), P(0x080e4), P(0x080e8), P(0x080ec), P(0x080f0),
	P(0x080f4), P(0x080f8), P(0x080fc), P(0x08100), P(0x08104),
	P(0x08108), P(0x0810c), P(0x08110), P(0x08118), P(0x0811c),
	P(0x08120), P(0x08124), P(0x08128), P(0x0812c), P(0x08130),
	P(0x08134), P(0x08138), P(0x0813c), P(0x08144), P(0x08168),
	P(0x0816c), P(0x08170), P(0x08174), P(0x08178), P(0x0817c),
	P(0x081c0), P(0x081d0), P(0x081ec), P(0x081f0), P(0x081f4),
	P(0x081f8), P(0x081fc), P(0x08200), P(0x08204), P(0x08208),
	P(0x0820c), P(0x08210), P(0x08214), P(0x08218), P(0x0821c),
	P(0x08220), P(0x08224), P(0x08228), P(0x0822c), P(0x08230),
	P(0x08234), P(0x08238), P(0x0823c), P(0x08240), P(0x08244),
	P(0x08248), P(0x0824c), P(0x08250), P(0x08254), P(0x08258),
	P(0x0825c), P(0x08260), P(0x08264), P(0x08270), P(0x08274),
	P(0x08278), P(0x0827c), P(0x08284), P(0x08288), P(0x0828c),
	P(0x08294), P(0x08298), P(0x0829c), P(0x08300), P(0x08314),
	P(0x08328), P(0x0832c), P(0x08330), P(0x08334), P(0x08338),
	P(0x0833c), P(0x08340), P(0x08344), P(0x09808), P(0x0980c),
	P(0x09810), P(0x09814), P(0x0981c), P(0x0982c), P(0x09830),
	P(0x0983c), P(0x0984c), P(0x09854), P(0x09900), P(0x09904),
	P(0x09908), P(0x0990c), P(0x09910), P(0x0991c), P(0x09920),
	P(0x09928), P(0x0992c), P(0x09934), P(0x09938), P(0x0993c),
	P(0x09940), P(0x09948), P(0x0994c), P(0x09954), P(0x09958),
	P(0x09968), P(0x09970), P(0x09974), P(0x09978), P(0x0997c),
	P(0x09980), P(0x09984), P(0x09988), P(0x0998c), P(0x09990),
	P(0x09994), P(0x09998), P(0x0999c), P(0x099a0), P(0x099a4),
	P(0x099a8), P(0x099ac), P(0x099b0), P(0x099b4), P(0x099dc),
	P(0x099e0), P(0x099e4), P(0x099e8), P(0x099ec), P(0x099f0),
	P(0x0a208), P(0x0a210), P(0x0a214), P(0x0a218), P(0x0a220),
	P(0x0a224), P(0x0a228), P(0x0a22c), P(0x0a234), P(0x0a238),
	P(0x0a244), P(0x0a248), P(0x0a24c), P(0x0a254), P(0x0a258),
	P(0x0a25c), P(0x0a260), P(0x0a268), P(0x0a26c), P(0x0d270),
	P(0x0a278), P(0x0a27c), P(0x0d35c), P(0x0d360), P(0x0d364),
	P(0x0d368), P(0x0d36c), P(0x0d370), P(0x0d374), P(0x0d378),
	P(0x0d37c), P(0x0d380), P(0x0d384), P(0x0a388), P(0x0a38c),
	P(0x0a390), P(0x0a394), P(0x0a398), P(0x0a39c), P(0x0a3a0),
	P(0x0a3a4), P(0x0a3a8), P(0x0a3ac), P(0x0a3b0), P(0x0a3b4),
	P(0x0a3b8), P(0x0a3bc), P(0x0a3c0), P(0x0a3c4), P(0x0a3cc),
	P(0x0a3d0), P(0x0a3d4), P(0x0a3dc), P(0x0a3e0), P(0x0a3e4),
	P(0x0a3e8), P(0x0a3ec), P(0x07800), P(0x07804), P(0x07808),
	P(0x0780c), P(0x07810), P(0x07814), P(0x0781c), P(0x07820),
	P(0x07824), P(0x07828), P(0x0782c), P(0x07830), P(0x07834),
	P(0x07838), P(0x0783c), P(0x07840), P(0x07844), P(0x07848),
	P(0x0784c), P(0x07850), P(0x07854), P(0x07858), P(0x0785c),
	P(0x07860), P(0x07864), P(0x07868), P(0x0786c), P(0x07870)
};

static const uint32_t ar9285_1_0_cm_vals[] = {
	0x00000000, 0x00020045, 0x00000005, 0x00000000, 0x00000008,
	0x00000008, 0x00000010, 0x00000000, 0x0000001f, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000002, 0x00000002, 0x0000001f, 0x00000000,
	0x00000000, 0x00000031, 0x00000002, 0x000004c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000700, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000fc78f,
	0x0000000f, 0x00000000, 0x00000000, 0x2a80001a, 0x05dc01e0,
	0x1f402710, 0x01f40000, 0x00001e00, 0x00000000, 0x00400000,
	0xffffffff, 0x0000ffff, 0x003f3f3f, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00020000, 0x00020000, 0x00000001,
	0x00000052, 0x00000000, 0x00000168, 0x000100aa, 0x00003210,
	0x08f04800, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x32143320, 0xfaa4fa50, 0x00000100, 0x00000000,
	0x00000000, 0x00003210, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x0010f400,
	0x00000100, 0x0001e800, 0x00000000, 0x00000000, 0x00000000,
	0x400000ff, 0x00080922, 0xa8a00010, 0x00000000, 0x40000000,
	0x003e4180, 0x00000000, 0x0000002c, 0x0000002c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000,
	0x00000000, 0x00000001, 0x00000302, 0x00000e00, 0x00000000,
	0x00000000, 0x00010380, 0x00481043, 0x00000000, 0xafe68e30,
	0xfd14e000, 0x9c0a9f6b, 0x00000000, 0x0000a000, 0x00000000,
	0x00200400, 0x0040233c, 0x00000044, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x01002310, 0x10000fff, 0x04900000,
	0x00000001, 0x00000004, 0x1e1f2022, 0x0a0b0c0d, 0x00000000,
	0x14750604, 0x9280c00a, 0x00020028, 0x5f3ca3de, 0x2108ecff,
	0x000003ce, 0x1927b515, 0x00000000, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
	0x201fff00, 0x2def0a00, 0x03051000, 0x00000820, 0x00000000,
	0x00000000, 0xaaaaaaaa, 0x3c466478, 0x0cc80caa, 0x00000000,
	0x803e6788, 0x4080a333, 0x00206c10, 0x009c4060, 0x01834061,
	0x00000400, 0x000003b5, 0x00000000, 0x20202020, 0x20202020,
	0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x0ccb5380,
	0x15151501, 0xdfa90f01, 0x00000000, 0x0ebae9e6, 0x0d820820,
	0x39ce739c, 0x050e039c, 0x07ffffef, 0x0fffffe7, 0x17ffffe5,
	0x1fffffe4, 0x37ffffe3, 0x3fffffe3, 0x57ffffe3, 0x5fffffe2,
	0x7fffffe2, 0x7f3c7bba, 0xf3307ff0, 0x0c000000, 0x20202020,
	0x20202020, 0x39ce739c, 0x0000039c, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20202020,
	0x20202020, 0x20202020, 0x39ce739c, 0x0000039c, 0x00000000,
	0x18c43433, 0x00f70081, 0x00140000, 0x0e4548d8, 0x54214514,
	0x02025820, 0x71c0d388, 0x924934a8, 0x00000000, 0x00000c04,
	0x00d86fff, 0x26d2491b, 0x6e36d97b, 0xedb6d96c, 0x71400086,
	0xfac68800, 0x0001fffe, 0xffeb1a20, 0x000c0db6, 0x6db61b6f,
	0x6d9b66db, 0x6d8c6dba, 0x00040000, 0xdb003012, 0x04924914,
	0x21084210, 0xf7d7ffde, 0xc2034080, 0x48609eb4, 0x10142c00
};

static const struct athn_ini ar9285_1_0_ini = {
	nitems(ar9285_1_0_regs),
	ar9285_1_0_regs,
	NULL,	/* 2GHz only. */
#ifndef IEEE80211_NO_HT
	NULL,	/* 2GHz only. */
	ar9285_1_0_vals_2g40,
#endif
	ar9285_1_0_vals_2g20,
	nitems(ar9285_1_0_cm_regs),
	ar9285_1_0_cm_regs,
	ar9285_1_0_cm_vals
};

/*
 * AR9285 1.2 initialization values.
 */
static const uint16_t ar9285_1_2_regs[] = {
	P(0x01030), P(0x01070), P(0x010b0), P(0x010f0), P(0x08014),
	P(0x0801c), P(0x08318), P(0x09804), P(0x09820), P(0x09824),
	P(0x09828), P(0x09834), P(0x09838), P(0x09840), P(0x09844),
	P(0x09848), P(0x0a848), P(0x09850), P(0x09858), P(0x0985c),
	P(0x09860), P(0x09864), P(0x09868), P(0x0986c), P(0x09914),
	P(0x09918), P(0x09924), P(0x09944), P(0x09960), P(0x09964),
	P(0x099b8), P(0x099bc), P(0x099c0), P(0x099c4), P(0x099c8),
	P(0x099cc), P(0x099d0), P(0x099d4), P(0x099d8), P(0x09a00),
	P(0x09a04), P(0x09a08), P(0x09a0c), P(0x09a10), P(0x09a14),
	P(0x09a18), P(0x09a1c), P(0x09a20), P(0x09a24), P(0x09a28),
	P(0x09a2c), P(0x09a30), P(0x09a34), P(0x09a38), P(0x09a3c),
	P(0x09a40), P(0x09a44), P(0x09a48), P(0x09a4c), P(0x09a50),
	P(0x09a54), P(0x09a58), P(0x09a5c), P(0x09a60), P(0x09a64),
	P(0x09a68), P(0x09a6c), P(0x09a70), P(0x09a74), P(0x09a78),
	P(0x09a7c), P(0x09a80), P(0x09a84), P(0x09a88), P(0x09a8c),
	P(0x09a90), P(0x09a94), P(0x09a98), P(0x09a9c), P(0x09aa0),
	P(0x09aa4), P(0x09aa8), P(0x09aac), P(0x09ab0), P(0x09ab4),
	P(0x09ab8), P(0x09abc), P(0x09ac0), P(0x09ac4), P(0x09ac8),
	P(0x09acc), P(0x09ad0), P(0x09ad4), P(0x09ad8), P(0x09adc),
	P(0x09ae0), P(0x09ae4), P(0x09ae8), P(0x09aec), P(0x09af0),
	P(0x09af4), P(0x09af8), P(0x09afc), P(0x09b00), P(0x09b04),
	P(0x09b08), P(0x09b0c), P(0x09b10), P(0x09b14), P(0x09b18),
	P(0x09b1c), P(0x09b20), P(0x09b24), P(0x09b28), P(0x09b2c),
	P(0x09b30), P(0x09b34), P(0x09b38), P(0x09b3c), P(0x09b40),
	P(0x09b44), P(0x09b48), P(0x09b4c), P(0x09b50), P(0x09b54),
	P(0x09b58), P(0x09b5c), P(0x09b60), P(0x09b64), P(0x09b68),
	P(0x09b6c), P(0x09b70), P(0x09b74), P(0x09b78), P(0x09b7c),
	P(0x09b80), P(0x09b84), P(0x09b88), P(0x09b8c), P(0x09b90),
	P(0x09b94), P(0x09b98), P(0x09b9c), P(0x09ba0), P(0x09ba4),
	P(0x09ba8), P(0x09bac), P(0x09bb0), P(0x09bb4), P(0x09bb8),
	P(0x09bbc), P(0x09bc0), P(0x09bc4), P(0x09bc8), P(0x09bcc),
	P(0x09bd0), P(0x09bd4), P(0x09bd8), P(0x09bdc), P(0x09be0),
	P(0x09be4), P(0x09be8), P(0x09bec), P(0x09bf0), P(0x09bf4),
	P(0x09bf8), P(0x09bfc), P(0x0aa00), P(0x0aa04), P(0x0aa08),
	P(0x0aa0c), P(0x0aa10), P(0x0aa14), P(0x0aa18), P(0x0aa1c),
	P(0x0aa20), P(0x0aa24), P(0x0aa28), P(0x0aa2c), P(0x0aa30),
	P(0x0aa34), P(0x0aa38), P(0x0aa3c), P(0x0aa40), P(0x0aa44),
	P(0x0aa48), P(0x0aa4c), P(0x0aa50), P(0x0aa54), P(0x0aa58),
	P(0x0aa5c), P(0x0aa60), P(0x0aa64), P(0x0aa68), P(0x0aa6c),
	P(0x0aa70), P(0x0aa74), P(0x0aa78), P(0x0aa7c), P(0x0aa80),
	P(0x0aa84), P(0x0aa88), P(0x0aa8c), P(0x0aa90), P(0x0aa94),
	P(0x0aa98), P(0x0aa9c), P(0x0aaa0), P(0x0aaa4), P(0x0aaa8),
	P(0x0aaac), P(0x0aab0), P(0x0aab4), P(0x0aab8), P(0x0aabc),
	P(0x0aac0), P(0x0aac4), P(0x0aac8), P(0x0aacc), P(0x0aad0),
	P(0x0aad4), P(0x0aad8), P(0x0aadc), P(0x0aae0), P(0x0aae4),
	P(0x0aae8), P(0x0aaec), P(0x0aaf0), P(0x0aaf4), P(0x0aaf8),
	P(0x0aafc), P(0x0ab00), P(0x0ab04), P(0x0ab08), P(0x0ab0c),
	P(0x0ab10), P(0x0ab14), P(0x0ab18), P(0x0ab1c), P(0x0ab20),
	P(0x0ab24), P(0x0ab28), P(0x0ab2c), P(0x0ab30), P(0x0ab34),
	P(0x0ab38), P(0x0ab3c), P(0x0ab40), P(0x0ab44), P(0x0ab48),
	P(0x0ab4c), P(0x0ab50), P(0x0ab54), P(0x0ab58), P(0x0ab5c),
	P(0x0ab60), P(0x0ab64), P(0x0ab68), P(0x0ab6c), P(0x0ab70),
	P(0x0ab74), P(0x0ab78), P(0x0ab7c), P(0x0ab80), P(0x0ab84),
	P(0x0ab88), P(0x0ab8c), P(0x0ab90), P(0x0ab94), P(0x0ab98),
	P(0x0ab9c), P(0x0aba0), P(0x0aba4), P(0x0aba8), P(0x0abac),
	P(0x0abb0), P(0x0abb4), P(0x0abb8), P(0x0abbc), P(0x0abc0),
	P(0x0abc4), P(0x0abc8), P(0x0abcc), P(0x0abd0), P(0x0abd4),
	P(0x0abd8), P(0x0abdc), P(0x0abe0), P(0x0abe4), P(0x0abe8),
	P(0x0abec), P(0x0abf0), P(0x0abf4), P(0x0abf8), P(0x0abfc),
	P(0x0a204), P(0x0a20c), P(0x0b20c), P(0x0a21c), P(0x0a230),
	P(0x0a250), P(0x0a358)
};

#ifndef IEEE80211_NO_HT
static const uint32_t ar9285_1_2_vals_2g40[] = {
	0x000002c0, 0x00000318, 0x00007c70, 0x00000000, 0x10801600,
	0x12e00057, 0x00006880, 0x000003c4, 0x02020200, 0x01000e0e,
	0x0a020001, 0x00000e0e, 0x00000007, 0x206a012e, 0x03721620,
	0x00001053, 0x00001053, 0x6d4000e2, 0x7ec84d2e, 0x3137605e,
	0x00058d20, 0x0001ce00, 0x5ac640d0, 0x06903881, 0x00001130,
	0x00000016, 0xd00a800d, 0xffbc1020, 0x00000000, 0x00000000,
	0x0000421c, 0x00000c00, 0x05eea6d4, 0x06336f77, 0x6af6532f,
	0x08f186c8, 0x00046384, 0x00000000, 0x00000000, 0x00058084,
	0x00058088, 0x0005808c, 0x00058100, 0x00058104, 0x00058108,
	0x0005810c, 0x00058110, 0x00058114, 0x00058180, 0x00058184,
	0x00058188, 0x0005818c, 0x00058190, 0x00058194, 0x000581a0,
	0x0005820c, 0x000581a8, 0x00058284, 0x00058288, 0x00058224,
	0x00058290, 0x00058300, 0x00058304, 0x00058308, 0x0005830c,
	0x00058380, 0x00058384, 0x00068700, 0x00068704, 0x00068708,
	0x0006870c, 0x00068780, 0x00068784, 0x00078b00, 0x00078b04,
	0x00078b08, 0x00078b0c, 0x00078b80, 0x00078b84, 0x00078b88,
	0x00078b8c, 0x00078b90, 0x000caf80, 0x000caf84, 0x000caf88,
	0x000caf8c, 0x000caf90, 0x000db30c, 0x000db310, 0x000db384,
	0x000db388, 0x000db324, 0x000eb704, 0x000eb6a4, 0x000eb6a8,
	0x000eb710, 0x000eb714, 0x000eb720, 0x000eb724, 0x000eb728,
	0x000eb72c, 0x000eb7a0, 0x000eb7a4, 0x000eb7a8, 0x000eb7b0,
	0x000eb7b4, 0x000eb7b8, 0x000eb7a5, 0x000eb7a9, 0x000eb7ad,
	0x000eb7b1, 0x000eb7b5, 0x000eb7b9, 0x000eb7c5, 0x000eb7c9,
	0x000eb7d1, 0x000eb7d5, 0x000eb7d9, 0x000eb7c6, 0x000eb7ca,
	0x000eb7ce, 0x000eb7d2, 0x000eb7d6, 0x000eb7c3, 0x000eb7c7,
	0x000eb7cb, 0x000eb7cf, 0x000eb7d7, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x00058084, 0x00058088, 0x0005808c,
	0x00058100, 0x00058104, 0x00058108, 0x0005810c, 0x00058110,
	0x00058114, 0x00058180, 0x00058184, 0x00058188, 0x0005818c,
	0x00058190, 0x00058194, 0x000581a0, 0x0005820c, 0x000581a8,
	0x00058284, 0x00058288, 0x00058224, 0x00058290, 0x00058300,
	0x00058304, 0x00058308, 0x0005830c, 0x00058380, 0x00058384,
	0x00068700, 0x00068704, 0x00068708, 0x0006870c, 0x00068780,
	0x00068784, 0x00078b00, 0x00078b04, 0x00078b08, 0x00078b0c,
	0x00078b80, 0x00078b84, 0x00078b88, 0x00078b8c, 0x00078b90,
	0x000caf80, 0x000caf84, 0x000caf88, 0x000caf8c, 0x000caf90,
	0x000db30c, 0x000db310, 0x000db384, 0x000db388, 0x000db324,
	0x000eb704, 0x000eb6a4, 0x000eb6a8, 0x000eb710, 0x000eb714,
	0x000eb720, 0x000eb724, 0x000eb728, 0x000eb72c, 0x000eb7a0,
	0x000eb7a4, 0x000eb7a8, 0x000eb7b0, 0x000eb7b4, 0x000eb7b8,
	0x000eb7a5, 0x000eb7a9, 0x000eb7ad, 0x000eb7b1, 0x000eb7b5,
	0x000eb7b9, 0x000eb7c5, 0x000eb7c9, 0x000eb7d1, 0x000eb7d5,
	0x000eb7d9, 0x000eb7c6, 0x000eb7ca, 0x000eb7ce, 0x000eb7d2,
	0x000eb7d6, 0x000eb7c3, 0x000eb7c7, 0x000eb7cb, 0x000eb7cf,
	0x000eb7d7, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x00000004, 0x0001f000, 0x0001f000, 0x1883800a, 0x00000210,
	0x0004a000, 0x7999aa0e
};
#endif

static const uint32_t ar9285_1_2_vals_2g20[] = {
	0x00000160, 0x0000018c, 0x00003e38, 0x00000000, 0x08400b00,
	0x12e0002b, 0x00003440, 0x00000300, 0x02020200, 0x01000e0e,
	0x0a020001, 0x00000e0e, 0x00000007, 0x206a012e, 0x03721620,
	0x00001053, 0x00001053, 0x6d4000e2, 0x7ec84d2e, 0x3137605e,
	0x00058d20, 0x0001ce00, 0x5ac640d0, 0x06903881, 0x00000898,
	0x0000000b, 0xd00a800d, 0xffbc1020, 0x00000000, 0x00000000,
	0x0000421c, 0x00000c00, 0x05eea6d4, 0x06336f77, 0x6af6532f,
	0x08f186c8, 0x00046384, 0x00000000, 0x00000000, 0x00058084,
	0x00058088, 0x0005808c, 0x00058100, 0x00058104, 0x00058108,
	0x0005810c, 0x00058110, 0x00058114, 0x00058180, 0x00058184,
	0x00058188, 0x0005818c, 0x00058190, 0x00058194, 0x000581a0,
	0x0005820c, 0x000581a8, 0x00058284, 0x00058288, 0x00058224,
	0x00058290, 0x00058300, 0x00058304, 0x00058308, 0x0005830c,
	0x00058380, 0x00058384, 0x00068700, 0x00068704, 0x00068708,
	0x0006870c, 0x00068780, 0x00068784, 0x00078b00, 0x00078b04,
	0x00078b08, 0x00078b0c, 0x00078b80, 0x00078b84, 0x00078b88,
	0x00078b8c, 0x00078b90, 0x000caf80, 0x000caf84, 0x000caf88,
	0x000caf8c, 0x000caf90, 0x000db30c, 0x000db310, 0x000db384,
	0x000db388, 0x000db324, 0x000eb704, 0x000eb6a4, 0x000eb6a8,
	0x000eb710, 0x000eb714, 0x000eb720, 0x000eb724, 0x000eb728,
	0x000eb72c, 0x000eb7a0, 0x000eb7a4, 0x000eb7a8, 0x000eb7b0,
	0x000eb7b4, 0x000eb7b8, 0x000eb7a5, 0x000eb7a9, 0x000eb7ad,
	0x000eb7b1, 0x000eb7b5, 0x000eb7b9, 0x000eb7c5, 0x000eb7c9,
	0x000eb7d1, 0x000eb7d5, 0x000eb7d9, 0x000eb7c6, 0x000eb7ca,
	0x000eb7ce, 0x000eb7d2, 0x000eb7d6, 0x000eb7c3, 0x000eb7c7,
	0x000eb7cb, 0x000eb7cf, 0x000eb7d7, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x00058084, 0x00058088, 0x0005808c,
	0x00058100, 0x00058104, 0x00058108, 0x0005810c, 0x00058110,
	0x00058114, 0x00058180, 0x00058184, 0x00058188, 0x0005818c,
	0x00058190, 0x00058194, 0x000581a0, 0x0005820c, 0x000581a8,
	0x00058284, 0x00058288, 0x00058224, 0x00058290, 0x00058300,
	0x00058304, 0x00058308, 0x0005830c, 0x00058380, 0x00058384,
	0x00068700, 0x00068704, 0x00068708, 0x0006870c, 0x00068780,
	0x00068784, 0x00078b00, 0x00078b04, 0x00078b08, 0x00078b0c,
	0x00078b80, 0x00078b84, 0x00078b88, 0x00078b8c, 0x00078b90,
	0x000caf80, 0x000caf84, 0x000caf88, 0x000caf8c, 0x000caf90,
	0x000db30c, 0x000db310, 0x000db384, 0x000db388, 0x000db324,
	0x000eb704, 0x000eb6a4, 0x000eb6a8, 0x000eb710, 0x000eb714,
	0x000eb720, 0x000eb724, 0x000eb728, 0x000eb72c, 0x000eb7a0,
	0x000eb7a4, 0x000eb7a8, 0x000eb7b0, 0x000eb7b4, 0x000eb7b8,
	0x000eb7a5, 0x000eb7a9, 0x000eb7ad, 0x000eb7b1, 0x000eb7b5,
	0x000eb7b9, 0x000eb7c5, 0x000eb7c9, 0x000eb7d1, 0x000eb7d5,
	0x000eb7d9, 0x000eb7c6, 0x000eb7ca, 0x000eb7ce, 0x000eb7d2,
	0x000eb7d6, 0x000eb7c3, 0x000eb7c7, 0x000eb7cb, 0x000eb7cf,
	0x000eb7d7, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db, 0x000eb7db,
	0x00000004, 0x0001f000, 0x0001f000, 0x1883800a, 0x00000108,
	0x0004a000, 0x7999aa0e
};

static const uint16_t ar9285_1_2_cm_regs[] = {
	P(0x0000c), P(0x00030), P(0x00034), P(0x00040), P(0x00044),
	P(0x00048), P(0x0004c), P(0x00050), P(0x00054), P(0x00800),
	P(0x00804), P(0x00808), P(0x0080c), P(0x00810), P(0x00814),
	P(0x00818), P(0x0081c), P(0x00820), P(0x00824), P(0x01040),
	P(0x01044), P(0x01048), P(0x0104c), P(0x01050), P(0x01054),
	P(0x01058), P(0x0105c), P(0x01060), P(0x01064), P(0x01230),
	P(0x01270), P(0x01038), P(0x01078), P(0x010b8), P(0x010f8),
	P(0x01138), P(0x01178), P(0x011b8), P(0x011f8), P(0x01238),
	P(0x01278), P(0x012b8), P(0x012f8), P(0x01338), P(0x01378),
	P(0x013b8), P(0x013f8), P(0x01438), P(0x01478), P(0x014b8),
	P(0x014f8), P(0x01538), P(0x01578), P(0x015b8), P(0x015f8),
	P(0x01638), P(0x01678), P(0x016b8), P(0x016f8), P(0x01738),
	P(0x01778), P(0x017b8), P(0x017f8), P(0x0103c), P(0x0107c),
	P(0x010bc), P(0x010fc), P(0x0113c), P(0x0117c), P(0x011bc),
	P(0x011fc), P(0x0123c), P(0x0127c), P(0x012bc), P(0x012fc),
	P(0x0133c), P(0x0137c), P(0x013bc), P(0x013fc), P(0x0143c),
	P(0x0147c), P(0x04030), P(0x0403c), P(0x04024), P(0x04060),
	P(0x04064), P(0x07010), P(0x07034), P(0x07038), P(0x08004),
	P(0x08008), P(0x0800c), P(0x08018), P(0x08020), P(0x08038),
	P(0x0803c), P(0x08048), P(0x08054), P(0x08058), P(0x0805c),
	P(0x08060), P(0x08064), P(0x08070), P(0x080c0), P(0x080c4),
	P(0x080c8), P(0x080cc), P(0x080d0), P(0x080d4), P(0x080d8),
	P(0x080e0), P(0x080e4), P(0x080e8), P(0x080ec), P(0x080f0),
	P(0x080f4), P(0x080f8), P(0x080fc), P(0x08100), P(0x08104),
	P(0x08108), P(0x0810c), P(0x08110), P(0x08118), P(0x0811c),
	P(0x08120), P(0x08124), P(0x08128), P(0x0812c), P(0x08130),
	P(0x08134), P(0x08138), P(0x0813c), P(0x08144), P(0x08168),
	P(0x0816c), P(0x08170), P(0x08174), P(0x08178), P(0x0817c),
	P(0x081c0), P(0x081d0), P(0x081ec), P(0x081f0), P(0x081f4),
	P(0x081f8), P(0x081fc), P(0x08200), P(0x08204), P(0x08208),
	P(0x0820c), P(0x08210), P(0x08214), P(0x08218), P(0x0821c),
	P(0x08220), P(0x08224), P(0x08228), P(0x0822c), P(0x08230),
	P(0x08234), P(0x08238), P(0x0823c), P(0x08240), P(0x08244),
	P(0x08248), P(0x0824c), P(0x08250), P(0x08254), P(0x08258),
	P(0x0825c), P(0x08260), P(0x08264), P(0x08270), P(0x08274),
	P(0x08278), P(0x0827c), P(0x08284), P(0x08288), P(0x0828c),
	P(0x08294), P(0x08298), P(0x0829c), P(0x08300), P(0x08314),
	P(0x08328), P(0x0832c), P(0x08330), P(0x08334), P(0x08338),
	P(0x0833c), P(0x08340), P(0x08344), P(0x09808), P(0x0980c),
	P(0x09810), P(0x09814), P(0x0981c), P(0x0982c), P(0x09830),
	P(0x0983c), P(0x0984c), P(0x09854), P(0x09900), P(0x09904),
	P(0x09908), P(0x0990c), P(0x09910), P(0x0991c), P(0x09920),
	P(0x09928), P(0x0992c), P(0x09934), P(0x09938), P(0x0993c),
	P(0x09940), P(0x09948), P(0x0994c), P(0x09954), P(0x09958),
	P(0x09968), P(0x09970), P(0x09974), P(0x09978), P(0x0997c),
	P(0x09980), P(0x09984), P(0x09988), P(0x0998c), P(0x09990),
	P(0x09994), P(0x09998), P(0x0999c), P(0x099a0), P(0x099a4),
	P(0x099a8), P(0x099ac), P(0x099b0), P(0x099b4), P(0x099dc),
	P(0x099e0), P(0x099e4), P(0x099e8), P(0x099ec), P(0x099f0),
	P(0x0a208), P(0x0a210), P(0x0a214), P(0x0a218), P(0x0a220),
	P(0x0a224), P(0x0a228), P(0x0a22c), P(0x0a234), P(0x0a238),
	P(0x0a244), P(0x0a248), P(0x0a24c), P(0x0a254), P(0x0a258),
	P(0x0a25c), P(0x0a260), P(0x0a268), P(0x0a26c), P(0x0d270),
	P(0x0d35c), P(0x0d360), P(0x0d364), P(0x0d368), P(0x0d36c),
	P(0x0d370), P(0x0d374), P(0x0d378), P(0x0d37c), P(0x0d380),
	P(0x0d384), P(0x0a388), P(0x0a38c), P(0x0a390), P(0x0a39c),
	P(0x0a3a0), P(0x0a3a4), P(0x0a3a8), P(0x0a3ac), P(0x0a3b0),
	P(0x0a3b4), P(0x0a3b8), P(0x0a3bc), P(0x0a3c0), P(0x0a3c4),
	P(0x0a3cc), P(0x0a3d0), P(0x0a3d4), P(0x0a3e4), P(0x0a3e8),
	P(0x0a3ec), P(0x07800), P(0x07804), P(0x07808), P(0x0780c),
	P(0x07810), P(0x0781c), P(0x07824), P(0x0782c), P(0x07834),
	P(0x07844), P(0x07848), P(0x0784c), P(0x07850), P(0x07854),
	P(0x07858), P(0x0785c), P(0x07860), P(0x07864), P(0x07868),
	P(0x07870)
};

static const uint32_t ar9285_1_2_cm_vals[] = {
	0x00000000, 0x00020045, 0x00000005, 0x00000000, 0x00000008,
	0x00000008, 0x00000010, 0x00000000, 0x0000001f, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f,
	0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x002ffc0f, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000002, 0x00000002, 0x0000001f, 0x00000000,
	0x00000000, 0x00000031, 0x00000002, 0x000004c2, 0x00000000,
	0x00000000, 0x00000000, 0x00000700, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000fc78f,
	0x0000000f, 0x00000000, 0x00000000, 0x2a80001a, 0x05dc01e0,
	0x1f402710, 0x01f40000, 0x00001e00, 0x00000000, 0x00400000,
	0xffffffff, 0x0000ffff, 0x003f3f3f, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00020000, 0x00020000, 0x00000001,
	0x00000052, 0x00000000, 0x00000168, 0x000100aa, 0x00003210,
	0x08f04810, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000,
	0x00000000, 0x32143320, 0xfaa4fa50, 0x00000100, 0x00000000,
	0x00000000, 0x0000320a, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x0010f400,
	0x00000100, 0x0001e800, 0x00000000, 0x00000000, 0x00000000,
	0x400000ff, 0x00080922, 0x88a00010, 0x00000000, 0x40000000,
	0x003e4180, 0x00000000, 0x0000002c, 0x0000002c, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000040, 0x00000000,
	0x00000000, 0x00000001, 0x00000302, 0x00000e00, 0x00ff0000,
	0x00000000, 0x00010380, 0x00481043, 0x00000000, 0xafe68e30,
	0xfd14e000, 0x9c0a9f6b, 0x00000000, 0x0000a000, 0x00000000,
	0x00200400, 0x0040233c, 0x00000044, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x01002310, 0x10000fff, 0x04900000,
	0x00000001, 0x00000004, 0x1e1f2022, 0x0a0b0c0d, 0x00000000,
	0x14750604, 0x9280c00a, 0x00020028, 0x5f3ca3de, 0x2108ecff,
	0x000003ce, 0x192bb514, 0x00000000, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001,
	0x201fff00, 0x2def0400, 0x03051000, 0x00000820, 0x00000000,
	0x00000000, 0xaaaaaaaa, 0x3c466478, 0x0cc80caa, 0x00000000,
	0x803e68c8, 0x4080a333, 0x00206c10, 0x009c4060, 0x01834061,
	0x00000400, 0x000003b5, 0x00000000, 0x20202020, 0x20202020,
	0x00000000, 0xfffffffc, 0x00000000, 0x00000000, 0x0ccb5380,
	0x15151501, 0xdfa90f01, 0x00000000, 0x0ebae9e6, 0x0d820820,
	0x07ffffef, 0x0fffffe7, 0x17ffffe5, 0x1fffffe4, 0x37ffffe3,
	0x3fffffe3, 0x57ffffe3, 0x5fffffe2, 0x7fffffe2, 0x7f3c7bba,
	0xf3307ff0, 0x0c000000, 0x20202020, 0x20202020, 0x00000001,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x20202020, 0x20202020, 0x20202020, 0x00000000, 0x18c43433,
	0x00f70081, 0x00140000, 0x0e4548d8, 0x54214514, 0x02025830,
	0x71c0d388, 0x00000000, 0x00d86fff, 0x6e36d97b, 0x71400087,
	0x000c0db6, 0x6db6246f, 0x6d9b66db, 0x6d8c6dba, 0x00040000,
	0xdb003012, 0x04924914, 0x21084210, 0xf7d7ffde, 0xc2034080,
	0x10142c00
};

static const struct athn_ini ar9285_1_2_ini = {
	nitems(ar9285_1_2_regs),
	ar9285_1_2_regs,
	NULL,	/* 2GHz only. */
#ifndef IEEE80211_NO_HT
	NULL,	/* 2GHz only. */
	ar9285_1_2_vals_2g40,
#endif
	ar9285_1_2_vals_2g20,
	nitems(ar9285_1_2_cm_regs),
	ar9285_1_2_cm_regs,
	ar9285_1_2_cm_vals
};

/*
 * AR9285 1.2 Tx gains.
 */
static const uint16_t ar9285_1_2_tx_gain_regs[] = {
	P(0x0a300), P(0x0a304), P(0x0a308), P(0x0a30c), P(0x0a310),
	P(0x0a314), P(0x0a318), P(0x0a31c), P(0x0a320), P(0x0a324),
	P(0x0a328), P(0x0a32c), P(0x0a330), P(0x0a334), P(0x0a338),
	P(0x0a33c), P(0x0a340), P(0x0a344), P(0x0a348), P(0x0a34c),
	P(0x0a350), P(0x0a354), P(0x07814), P(0x07828), P(0x07830),
	P(0x07838), P(0x0783c), P(0x07840), P(0x0786c), P(0x07820),
	P(0x0a274), P(0x0a278), P(0x0a27c), P(0x0a394), P(0x0a398),
	P(0x0a3dc), P(0x0a3e0)
};

static const uint32_t ar9285_1_2_tx_gain_vals_2g[] = {
	0x00000000, 0x00009200, 0x00010208, 0x00019608, 0x00022618,
	0x0002a6c9, 0x00031710, 0x00035718, 0x00038758, 0x0003c75a,
	0x0004075c, 0x0004475e, 0x0004679f, 0x000487df, 0x0003891e,
	0x0003a95e, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df,
	0x0003e9df, 0x0003e9df, 0x924934a8, 0x26d2491b, 0xedb6d96e,
	0xfac68801, 0x0001fffe, 0xffeb1a20, 0x48609eb4, 0x00000c04,
	0x0a21a652, 0x39ce739c, 0x050e039c, 0x39ce739c, 0x0000039c,
	0x39ce739c, 0x0000039c
};

static const struct athn_gain ar9285_1_2_tx_gain = {
	nitems(ar9285_1_2_tx_gain_regs),
	ar9285_1_2_tx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9285_1_2_tx_gain_vals_2g
};

static const uint32_t ar9285_1_2_tx_gain_high_power_vals_2g[] = {
	0x00000000, 0x00006200, 0x00008201, 0x0000b240, 0x0000d241,
	0x0000f600, 0x00012800, 0x00016802, 0x0001b805, 0x00021a80,
	0x00028b00, 0x0002ab40, 0x0002cd80, 0x00033d82, 0x0003891e,
	0x0003a95e, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df,
	0x0003e9df, 0x0003e9df, 0x924934a8, 0x26d2491b, 0xedb6d96e,
	0xfac68803, 0x0001fffe, 0xffeb1a20, 0x08609ebe, 0x00000c00,
	0x0a216652, 0x0e739ce7, 0x050380e7, 0x0e739ce7, 0x000000e7,
	0x0e739ce7, 0x000000e7
};

static const struct athn_gain ar9285_1_2_tx_gain_high_power = {
	nitems(ar9285_1_2_tx_gain_regs),
	ar9285_1_2_tx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9285_1_2_tx_gain_high_power_vals_2g
};

/*
 * AR9285 XE 2.0 Tx gains.
 */
static const uint32_t ar9285_2_0_tx_gain_vals_2g[] = {
	0x00000000, 0x00009200, 0x00010208, 0x00019608, 0x00022618,
	0x0002a6c9, 0x00031710, 0x00035718, 0x00038758, 0x0003c75a,
	0x0004075c, 0x0004475e, 0x0004679f, 0x000487df, 0x0003891e,
	0x0003a95e, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df,
	0x0003e9df, 0x0003e9df, 0x92497ca8, 0x2ad2491b, 0xedb6da6e,
	0xdac71441, 0x2481f6fe, 0xba5f638c, 0x48609eb4, 0x00000c04,
	0x0a21a652, 0x39ce739c, 0x050e039c, 0x39ce739c, 0x0000039c,
	0x39ce739c, 0x0000039c
};

static const struct athn_gain ar9285_2_0_tx_gain = {
	nitems(ar9285_1_2_tx_gain_regs),
	ar9285_1_2_tx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9285_2_0_tx_gain_vals_2g
};

static const uint32_t ar9285_2_0_tx_gain_high_power_vals_2g[] = {
	0x00000000, 0x00006200, 0x00008201, 0x0000b240, 0x0000d241,
	0x0000f600, 0x00012800, 0x00016802, 0x0001b805, 0x00021a80,
	0x00028b00, 0x0002ab40, 0x0002cd80, 0x00033d82, 0x0003891e,
	0x0003a95e, 0x0003e9df, 0x0003e9df, 0x0003e9df, 0x0003e9df,
	0x0003e9df, 0x0003e9df, 0x92497ca8, 0x2ad2491b, 0xedb6da6e,
	0xdac71443, 0x2481f6fe, 0xba5f638c, 0x08609ebe, 0x00000c00,
	0x0a216652, 0x0e739ce7, 0x050380e7, 0x0e739ce7, 0x000000e7,
	0x0e739ce7, 0x000000e7
};

static const struct athn_gain ar9285_2_0_tx_gain_high_power = {
	nitems(ar9285_1_2_tx_gain_regs),
	ar9285_1_2_tx_gain_regs,
	NULL,	/* 2GHz only. */
	ar9285_2_0_tx_gain_high_power_vals_2g
};
