/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.struts2;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.Annotations;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Struts2Factory
extends ObjectFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Struts2Factory.class.getName());
    private static final String ERROR_NO_INJECTOR = "Cannot find a Guice injector.  Are you sure you registered a GuiceServletContextListener that uses the Struts2GuicePluginModule in your application's web.xml?";
    @Inject
    private static Injector injector;
    private final List<ProvidedInterceptor> interceptors = new ArrayList<ProvidedInterceptor>();
    private volatile Injector strutsInjector;
    Set<Class<?>> boundClasses = new HashSet();

    public boolean isNoArgConstructorRequired() {
        return false;
    }

    @com.opensymphony.xwork2.inject.Inject(value="guice.module", required=false)
    void setModule(String moduleClassName) {
        throw new RuntimeException("The struts2 plugin no longer supports specifying a module via the 'guice.module' property in XML. Please install your module via a GuiceServletContextListener instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClassInstance(String name) throws ClassNotFoundException {
        Class clazz = super.getClassInstance(name);
        Struts2Factory struts2Factory = this;
        synchronized (struts2Factory) {
            if (this.strutsInjector == null && !this.boundClasses.contains(clazz)) {
                try {
                    clazz.getDeclaredFields();
                    clazz.getDeclaredMethods();
                    this.boundClasses.add(clazz);
                }
                catch (Throwable t) {
                    return clazz;
                }
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildBean(Class clazz, Map<String, Object> extraContext) {
        if (this.strutsInjector == null) {
            Struts2Factory struts2Factory = this;
            synchronized (struts2Factory) {
                if (this.strutsInjector == null) {
                    this.createInjector();
                }
            }
        }
        return this.strutsInjector.getInstance(clazz);
    }

    private void createInjector() {
        logger.info("Loading struts2 Guice support...");
        if (injector == null) {
            logger.severe(ERROR_NO_INJECTOR);
            throw new RuntimeException(ERROR_NO_INJECTOR);
        }
        this.strutsInjector = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                for (Class<?> boundClass : Struts2Factory.this.boundClasses) {
                    this.bind(boundClass);
                }
                for (ProvidedInterceptor interceptor : Struts2Factory.this.interceptors) {
                    interceptor.validate(this.binder());
                }
            }
        }});
        for (ProvidedInterceptor interceptor : this.interceptors) {
            interceptor.inject();
        }
        logger.info("Injector created successfully.");
    }

    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map interceptorRefParams) throws ConfigurationException {
        Class<?> interceptorClass;
        try {
            interceptorClass = this.getClassInstance(interceptorConfig.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ProvidedInterceptor providedInterceptor = new ProvidedInterceptor(interceptorConfig, interceptorRefParams, interceptorClass);
        this.interceptors.add(providedInterceptor);
        return providedInterceptor;
    }

    private Interceptor superBuildInterceptor(InterceptorConfig interceptorConfig, Map<String, String> interceptorRefParams) throws ConfigurationException {
        return super.buildInterceptor(interceptorConfig, interceptorRefParams);
    }

    private static boolean hasScope(Class<? extends Interceptor> interceptorClass) {
        for (Annotation annotation : interceptorClass.getAnnotations()) {
            if (!Annotations.isScopeAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProvidedInterceptor
    implements Interceptor {
        private static final long serialVersionUID = 1L;
        private final InterceptorConfig config;
        private final Map<String, String> params;
        private final Class<? extends Interceptor> interceptorClass;
        private Interceptor delegate;

        ProvidedInterceptor(InterceptorConfig config, Map<String, String> params, Class<? extends Interceptor> interceptorClass) {
            this.config = config;
            this.params = params;
            this.interceptorClass = interceptorClass;
        }

        void validate(Binder binder) {
            if (Struts2Factory.hasScope(this.interceptorClass)) {
                binder.addError("Scoping interceptors is not currently supported. Please remove the scope annotation from " + this.interceptorClass.getName() + ".", new Object[0]);
            }
            if (!Interceptor.class.isAssignableFrom(this.interceptorClass)) {
                binder.addError(this.interceptorClass.getName() + " must implement " + Interceptor.class.getName() + ".", new Object[0]);
            }
        }

        void inject() {
            this.delegate = Struts2Factory.this.superBuildInterceptor(this.config, this.params);
        }

        public void destroy() {
            if (null != this.delegate) {
                this.delegate.destroy();
            }
        }

        public void init() {
            throw new AssertionError();
        }

        public String intercept(ActionInvocation invocation) throws Exception {
            return this.delegate.intercept(invocation);
        }
    }
}

