import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

//import org.csvdb.lang.CsvDbException;
//import org.csvdb.io.DataDefineConfig;

public class CsvSQLMain {

    public static void main(String[] args) {
        CsvSQLMain me = new CsvSQLMain();
        me.exec(args);
    }

    public void exec(String[] args) {
        try {
            String[] work = args[0].split(";");

            StatementCompileData statementCompileData = new StatementCompileData(work[0]);
            statementCompileData.compile();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

private class StatementCompileData {

    // Xe[gg^CvԍiSELECT)
    private static final int ST_TYPE_SELECT = 1;
    // Xe[gg^CvԍiERROR)
    private static final int ST_TYPE_ERR = 2;

    // Xe[gg^Cv̔fp
    private static final String ST_TYPE_SELECT_STR = "select";

    // Xe[ggp̃f~^
    private static final String ST_TOKEN_DELIM = " ";


    // ẃu=v
    public static final String WHERE_TYPE_EQUAL = "1";

    // ẃu<>v
    public static final String WHERE_TYPE_NOT_EQUAL = "2";

    // ẃulikev
    public static final String WHERE_TYPE_LIKE = "3";

    // ẃu<v
    public static final String WHERE_TYPE_RIGHT_BIG = "4";

    // ẃu>v
    public static final String WHERE_TYPE_LEFT_BIG = "5";

    // ẃuinv
    public static final String WHERE_TYPE_IN = "6";


    // WHERE̗ӂ̌^uv
    public static final String WHERE_VALUE_TYPE_STRING = "STRING";

    // WHERE̗ӂ̌^ulv
    public static final String WHERE_VALUE_TYPE_NUMBER = "NUMBER";

    // WHERE̗ӂ̌^ue[uv
    public static final String WHERE_VALUE_TYPE_TABLE = "TABLE";


    // RpC̃G[Li[
    private boolean compErrFlg;

    // RpC̃G[
    private String compErrMsg;


    // gXe[gg
    private String statement;

    // gRpCĂXe[gg̃^Cv 1=SELECT 2=UPDATE 3=INSERT 4=DELETE -1=G[
    public static final int ST_TYPE_NUMBER_SELECT = 1;
    public static final int ST_TYPE_NUMBER_UPDATE = 2;
    public static final int ST_TYPE_NUMBER_INSERT = 3;
    public static final int ST_TYPE_NUMBER_DELETE = 4;
    public static final int ST_TYPE_NUMBER_ERROR = -1;
    private int stTypeNumber = ST_TYPE_NUMBER_ERROR;


    /**
     * SELECT̃JXg.<br>
     * SELECT̃J̏ڍ׏i[.<br>
     * eHashMap<br>
     * ArrayList{(0) HashMap{"COLUMN_NAME", "COL_A"},<br>
     *           (1) HashMap{"COLUMN_NAME", "COL_B"}<br>
     *          }<br>
     */
    private ArrayList selectColsDtList;


    /**
     * FROM̃e[uXg.<br>
     * FROM̃e[ȕڍ׏i[.<br>
     * eHashMap<br>
     * ArrayList{(0) HashMap{"TABLE_NAME", "TABLE_A"},<br>
     *           (1) HashMap{"TABLE_NAME", "TABLE_B"}<br>
     *          }<br>
     *
     */
    private ArrayList fromTablesDtList;

    /**
     * WHERȄڍ׃Xg(eORoĂ܂ł̏WƂāA<br>
     * ArrayListɂĊi[.<br>
     * ArrayList̒gHashMap<br>
     * ArrayList{(0) ArrayList{HashMap{["LEFT", "COLUMN_A"],<br>
     *                                 ["LEFT_TYPE", "COLUMN"], <br>
     *                                 ["RIGHT", "'A'"], <br>
     *                                 ["RIGHT_TYPE", "STRING"], <br>
     *                                 ["TYPE", "="]<br>
     *                                },<br>
     *                        },<br>
     *                        {HashMap{["LEFT", "COLUMN_B"],<br>
     *                                 ["LEFT_TYPE", "COLUMN"], <br>
     *                                 ["RIGHT", "1"], <br>
     *                                 ["RIGHT_TYPE", "NUMBER"], <br>
     *                                 ["TYPE", "<>"]<br>
     *                                },<br>
     *                        },<br>
     *           (1) ArrayList{HashMap{["LEFT", "COLUMN_A"],<br>
     *                                 ["LEFT_TYPE", "COLUMN"], <br>
     *                                 ["RIGHT", "'B'"], <br>
     *                                 ["RIGHT_TYPE", "STRING"], <br>
     *                                 ["TYPE", "="]<br>
     *                                },<br>
     *                        },<br>
     *                        {HashMap{["LEFT", "COLUMN_B"],<br>
     *                                 ["LEFT_TYPE", "COLUMN"], <br>
     *                                 ["RIGHT", "2"], <br>
     *                                 ["RIGHT_TYPE", "NUMBER"], <br>
     *                                 ["TYPE", "<>"]<br>
     *                                },<br>
     *                        }<br>
     */ 
    private ArrayList whereDtList;


    /**
     * IvVR}hi[.<br>
     * HashMap{["OPTION_CMD", "OUT"],<br>
     *         ["OPTION_STR", "STR"]<br>
     *        }<br>
     *
     * OPTION_CMDɃIvVw蕶i[<br>
     * ݃T|[gĂ͉̂L<br>
     * "OUT" => ʂt@Cɏo<br>
     *
     * OPTION_STRɃIvVi[<br>
     * ݃T|[gĂ͉̂L<br>
     * "OUT"ɑ΂ => /etc/CSV_RET.csv<br>
     *
     */
    private HashMap optionCmdMap;


    /**
     * RXgN^
     * @param statement ₢킹
     */
    public StatementCompileData(String statement) {
        this.statement = statement;
        this.compErrFlg = false;
        this.compErrMsg = null;
        this.selectColsDtList = new ArrayList();
        this.fromTablesDtList = new ArrayList();
        this.whereDtList = new ArrayList();
        this.optionCmdMap = new HashMap();
    }

    /**
     * StatementRpC.<br>
     *
     */
    public void compile() throws Exception {
        String targetStr = null;
        try {
            switch (this.checkStatementType()) {
                case ST_TYPE_SELECT:
                    // SELECTXe[gg

                    // SELECT啪
                    targetStr = this.parseSelectColumn();

                    if (this.compErrFlg) break;

                    // FROM啪
                    targetStr = this.parseFrom(targetStr);

                    if (this.compErrFlg) break;

                    // WHERE啪
                    targetStr = this.parseWhere(targetStr);
                    if (this.compErrFlg) break;

                    // `FbN
                    //this.checkAll();
                    //if (this.compErrFlg) break;

                    this.stTypeNumber = ST_TYPE_NUMBER_SELECT;
                    break;
                case ST_TYPE_ERR:
                    // ȊO ̂ƂȂ
                    this.compErrFlg = true;
                    this.compErrMsg = "ΉĂȂXe[ggł =[" + this.statement + "]";
                    this.stTypeNumber = ST_TYPE_NUMBER_ERROR;
                break;
            }
            
        
        } catch (Exception e) {
            throw e;
        }
        System.out.println("selectColsDtList = [" + selectColsDtList + "]");
        System.out.println("fromTablesDtList = [" + fromTablesDtList + "]");
        System.out.println("whereDtList = [" + whereDtList + "]");
    }

    public ArrayList getSelectColsDtList() {
        return this.selectColsDtList;
    }

    public ArrayList getFromTablesDtList() {
        return this.fromTablesDtList;
    }

    public ArrayList getWhereDtList() {
        return this.whereDtList;
    }

    /**
     * Xe[gg̃^Cv𒲂ׂ.<br>
     * 1=SELECT<br>
     * 2=ȊO ܂̂ƂȂ<br>
     * @return int 1=SELECT 2=ȊO ܂̂ƂȂ
     */
    public int checkStatementType() throws Exception {

        int ret = ST_TYPE_ERR;
        String firstToken = null;

        // g
        String workSt = this.statement.trim();

        // g[N
        StringTokenizer token = new StringTokenizer(workSt, ST_TOKEN_DELIM);

        try {
            if (token.hasMoreTokens()) {
                firstToken = token.nextToken(ST_TOKEN_DELIM);
            }

            if (firstToken != null && firstToken.trim().toLowerCase().equals(ST_TYPE_SELECT_STR)) {
                ret = ST_TYPE_SELECT;
            }
        } catch (Exception e) {
            throw e;
        }
        return ret;
    }


    /**
     * SELECT𕪉.<br>
     * ","ŕĈ؂ɂ.<br>
     * AA"'""("oĂꍇ͎"'"")"oĂ܂ł̋؂ɂ.<br>
     * {\bg͉͌̎c蕶Ԃ.<br>
     *
     */
    private String parseSelectColumn() {
        HashMap colsDtMap = null;
        ArrayList addStrList = new ArrayList(50);
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;
        String workStr = "";

        String targetSt = null;
        char[] selectChars = null;
        String[] fromSplitList = null;

        // uselectv폜
        targetSt = this.deleteSelectStr(this.statement);

        if (targetSt.trim().length() == 0) {
            // SELECT傪݂Ȃ
            this.compErrFlg = true;
            this.compErrMsg = "SELECT傪݂܂:" + this.statement;
            return null;
        } 

        // ufromvŕ
        fromSplitList = this.splitSqlFrom(targetSt);

        // FROMȑOi[
        targetSt = fromSplitList[0];

        // SELECT̍Ōオ","ŏIĂꍇpɈꕶvX
        // [vɍŌ܂œ
        targetSt = targetSt + " ";
        selectChars = targetSt.toCharArray();

        // u , voĂ܂ňړ
        for(int charIndex = 0;charIndex < selectChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false){
                if(charIndex + 1 < selectChars.length){
                    if(selectChars[charIndex] == ','){
                        // u,vȂ̂ł܂ł̕i[
                        addStrList.add(workStr);
                        workStr = "";
                        charIndex = charIndex + 1;
                    }
                }
            }

            if(selectChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(selectChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(selectChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(selectChars[charIndex]);
        }

        addStrList.add(workStr);

        for(int i = 0;i < addStrList.size();i++){
            colsDtMap = new HashMap();

            // ̂ƂĴ݊i[
            // KvȂ炱ōēx͂Ă
            colsDtMap.put("COLUMN_NAME", ((String)addStrList.get(i)).trim());

            if (((String)addStrList.get(i)).trim().equals("")) {
                // SELECTɕs
                this.compErrFlg = true;
                this.compErrMsg = "SELECT傪słB:" + this.statement;
                return null;
            }

            selectColsDtList.add(colsDtMap);
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
                this.compErrFlg = true;
                this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return fromSplitList[1];
    }


    /**
     * FROMe[uPʂŕ.<br>
     * ","ŕĈ؂ɂ.<br>
     * AA"'""("oĂꍇ͎"'"")"oĂ܂ł̋؂ɂ.<br>
     * {\bg͉͌̎c蕶Ԃ.<br>
     * 
     */
    private String parseFrom(String targetSt) {
        HashMap tableDtMap = null;
        ArrayList addStrList = new ArrayList(50);
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;
        String workStr = "";

        char[] fromChars = null;
        String[] whereSplitList = null;

        // FROM呶݊mF
        if (targetSt == null || targetSt.trim().length() == 0) {
            // FROM傪݂Ȃ
            this.compErrFlg = true;
            this.compErrMsg = "FROM傪݂܂:" + this.statement;
            return null;
        } 

        // uwherevŕ
        whereSplitList = this.splitSqlWhere(targetSt);

        // FROMȑOi[
        targetSt = whereSplitList[0];

        // FROM̍Ōオ","ŏIĂꍇpɈꕶvX
        // [vɍŌ܂œ
        targetSt = targetSt + " ";
        fromChars = targetSt.toCharArray();

        // u , voĂ܂ňړ
        for(int charIndex = 0;charIndex < fromChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false){
                if(charIndex + 1 < fromChars.length){
                    if(fromChars[charIndex] == ','){
                        // u,vȂ̂ł܂ł̕i[
                        addStrList.add(workStr);
                        workStr = "";
                        charIndex = charIndex + 1;
                    }
                }
            }

            if(fromChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(fromChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(fromChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(fromChars[charIndex]);
        }

        addStrList.add(workStr);

        for(int i = 0;i < addStrList.size();i++){
            tableDtMap = new HashMap();

            // ̂Ƃe[û݊i[
            // KvȂ炱ōēx͂Ă
            tableDtMap.put("TABLE_NAME", ((String)addStrList.get(i)).trim());

            if (((String)addStrList.get(i)).trim().equals("")) {
                // FROMɕs
                this.compErrFlg = true;
                this.compErrMsg = "FROM傪słB:" + this.statement;
                return null;
            }

            this.fromTablesDtList.add(tableDtMap);
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
            this.compErrFlg = true;
            this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
            return null;
        }

        return whereSplitList[1];
    }


    /**
     * where𕪐
     *
     */
    public String parseWhere(String targetSt) {
        HashMap whereDtMap = null;
        ArrayList whereAndList = null;

        String[] orSplitList = null;
        String[] andSplitList = null;
        String[] groupBySplitList = null;

        // WHEREȍ~݊mF
        if (targetSt == null || targetSt.trim().length() == 0) {
           // WHEREȍ~݂Ȃ
           return null;
        } 

        // uorder byvŕ 
        // TODO:Ŏ
        //groupBySplitList = this.splitSqlOrderBy(targetSt);
        groupBySplitList = new String[2];

        // FROMȑOi[
        // TODO:Ŏ
        //targetSt = groupBySplitList[0];
        // TODO:
        targetSt = targetSt;

        // ORŕ
        orSplitList = this.splitSqlOr(targetSt);

        // ORPʂŕ
        for (int orIndex = 0; orIndex < orSplitList.length; orIndex++) {

            // AND̂܂Ƃ܂胊Xg
            whereAndList = new ArrayList();

            // ANDŕ
            andSplitList = this.splitSqlAnd(orSplitList[orIndex]);

            // ANDPʂŕ
            for (int andIndex = 0; andIndex < andSplitList.length; andIndex++) {
                // ̏𕪐
                whereDtMap = this.parseWhereOneDt(andSplitList[andIndex]);
                // nullꍇ͎s
                if (whereDtMap == null) break;
                whereAndList.add(whereDtMap);
            }
            this.whereDtList.add(whereAndList);
        }

        return groupBySplitList[1];
    }


    /**
     * SQLWhere̏͂
     * RIGHT = Eӂ̍ڂi[
     * RIGHT_TYPE = Eӂ̍ڂ̃^Cv(STRING, NUMBER, COLUMN)
     * LEFT = ӂ̍ڂi[
     * LEFT_TYPE = ӂ̍ڂ̃^Cv(STRING, NUMBER, COLUMN)
     * TYPE = 
     *
     * ) utable1.Acolumn = '2'v
     *                               
     *      [RIGHT='2', RIGHT_TYPE='STRING', LEFT='table1.Acolumn', LEFT_TYPE='COLUMN', TYPE='='}
     *
     * @param oneStr 
     * @return HashMap ͌̃}bv
     */
    private HashMap parseWhereOneDt(String str) {
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;
        String[] retList;
        str = str.trim();
        char[] lineChars = str.toCharArray();
        String type = "";
        StringBuffer workStrBuf = new StringBuffer();
        StringBuffer rightStrBuf = null;
        String leftStr = null;

        HashMap retMap = new HashMap();

        // u = voĂ܂ňړ
        if(str.indexOf("=") != -1){
            for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                // ݁u'v̒f
                if(singleQuotationFlg == false && bracketsFlg == false){
                    if(lineChars[charIndex] == '='){
                        // u=voĂ̂ł܂ł̕A
                        leftStr = workStrBuf.toString();
                        rightStrBuf = new StringBuffer();
                        for(int lastIndex = charIndex + 1;lastIndex < lineChars.length;lastIndex++){
                            rightStrBuf.append(lineChars[lastIndex]);
                        }
                        type = WHERE_TYPE_EQUAL;
                        break;
                    }
                }

                if(lineChars[charIndex] == '\''){
                    if(singleQuotationFlg == false){
                        singleQuotationFlg = true;
                    }else{
                        singleQuotationFlg = false;
                    }
                }

                if(singleQuotationFlg == false){
                    if(lineChars[charIndex] == '('){
                        bracketsFlgCount++;
                        bracketsFlg = true;
                    }

                    if(lineChars[charIndex] == ')'){
                        bracketsFlgCount--;
                        if(bracketsFlgCount == 0)  bracketsFlg = false;
                    }
                }

                workStrBuf.append(String.valueOf(lineChars[charIndex]));
            }
        }

        // u <> voĂ܂ňړ
        if(type.equals("")){
            workStrBuf = new StringBuffer();
            if(str.indexOf("<>") != -1){
                for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                // ݁u'v̒f
                if(singleQuotationFlg == false && bracketsFlg == false){

                    if(lineChars[charIndex] == '<' && 
                        lineChars[charIndex + 1] == '>'){
                        // u<>voĂ̂ł܂ł̕A
                        leftStr = workStrBuf.toString();
                        rightStrBuf = new StringBuffer();
                        for(int lastIndex = charIndex + 2;lastIndex < lineChars.length;lastIndex++){
                            rightStrBuf.append(lineChars[lastIndex]);

                        }
                        type = WHERE_TYPE_NOT_EQUAL;
                        break;
                    }
                }

                if(lineChars[charIndex] == '\''){
                    if(singleQuotationFlg == false){
                        singleQuotationFlg = true;
                    }else{
                        singleQuotationFlg = false;
                    }
                }

                if(singleQuotationFlg == false){
                    if(lineChars[charIndex] == '('){
                        bracketsFlgCount++;
                        bracketsFlg = true;
                    }

                    if(lineChars[charIndex] == ')'){
                        bracketsFlgCount--;
                        if(bracketsFlgCount == 0)  bracketsFlg = false;
                    }
                }

                workStrBuf.append(lineChars[charIndex]);
                }
            }
        }


        // u > voĂ܂ňړ
        if(type.equals("")){
            workStrBuf = new StringBuffer();
            if(str.indexOf(">") != -1){
                for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                // ݁u'v̒f
                    if(singleQuotationFlg == false && bracketsFlg == false){
                        if(lineChars[charIndex] == '>'){
                            // u>voĂ̂ł܂ł̕A
                            leftStr = workStrBuf.toString();
                            rightStrBuf = new StringBuffer();
                            for(int lastIndex = charIndex + 1;lastIndex < lineChars.length;lastIndex++){
                                rightStrBuf.append(lineChars[lastIndex]);
                            }
                            type = WHERE_TYPE_LEFT_BIG;
                            break;
                        }
                    }

                    if(lineChars[charIndex] == '\''){
                        if(singleQuotationFlg == false){
                            singleQuotationFlg = true;
                        }else{
                            singleQuotationFlg = false;
                        }
                    }

                    if(singleQuotationFlg == false){
                        if(lineChars[charIndex] == '('){
                            bracketsFlgCount++;
                            bracketsFlg = true;
                        }

                        if(lineChars[charIndex] == ')'){
                            bracketsFlgCount--;
                            if(bracketsFlgCount == 0)  bracketsFlg = false;
                        }
                    }

                    workStrBuf.append(lineChars[charIndex]);
                }
            }
        }


        // u < voĂ܂ňړ
        if(type.equals("")){
            workStrBuf = new StringBuffer();
            if(str.indexOf("<") != -1){
                for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                    // ݁u'v̒f
                    if(singleQuotationFlg == false && bracketsFlg == false){
                        if(lineChars[charIndex] == '<'){
                            // u<voĂ̂ł܂ł̕A
                            leftStr = workStrBuf.toString();
                            rightStrBuf = new StringBuffer();
                            for(int lastIndex = charIndex + 1;lastIndex < lineChars.length;lastIndex++){
                                rightStrBuf.append(lineChars[lastIndex]);
                            }
                            type = WHERE_TYPE_RIGHT_BIG;
                            break;
                        }
                    }

                    if(lineChars[charIndex] == '\''){
                        if(singleQuotationFlg == false){
                            singleQuotationFlg = true;
                        }else{
                            singleQuotationFlg = false;
                        }
                    }

                    if(singleQuotationFlg == false){
                        if(lineChars[charIndex] == '('){
                            bracketsFlgCount++;
                            bracketsFlg = true;
                        }

                        if(lineChars[charIndex] == ')'){
                            bracketsFlgCount--;
                            if(bracketsFlgCount == 0)  bracketsFlg = false;
                        }
                    }

                    workStrBuf.append(lineChars[charIndex]);
                }
            }
        }


        // u like voĂ܂ňړ
        if(type.equals("")){
            workStrBuf = new StringBuffer();
            if(str.toLowerCase().indexOf("like") != -1){
                for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                    // ݁u'v̒f
                    if(singleQuotationFlg == false && bracketsFlg == false){

                        if(lineChars[charIndex] == ' ' && 
                            (lineChars[charIndex + 1] == 'l' || lineChars[charIndex + 1] == 'L') && 
                            (lineChars[charIndex + 2] == 'i' || lineChars[charIndex + 2] == 'I') && 
                            (lineChars[charIndex + 3] == 'k' || lineChars[charIndex + 3] == 'K') && 
                            (lineChars[charIndex + 4] == 'e' || lineChars[charIndex + 4] == 'E') && 
                            (lineChars[charIndex + 5] == ' ' || lineChars[charIndex + 5] == '\'')){
                            // ulikevoĂ̂ł܂ł̕A
                            leftStr = workStrBuf.toString();
                            rightStrBuf = new StringBuffer();

                            for(int lastIndex = charIndex + 6;lastIndex < lineChars.length;lastIndex++){
                                rightStrBuf.append(lineChars[lastIndex]);
                            }
                            type = WHERE_TYPE_LIKE;
                            break;
                        }
                    }

                    if(lineChars[charIndex] == '\''){
                        if(singleQuotationFlg == false){
                            singleQuotationFlg = true;
                        }else{
                            singleQuotationFlg = false;
                        }
                    }

                    if(singleQuotationFlg == false){
                        if(lineChars[charIndex] == '('){
                            bracketsFlgCount++;
                            bracketsFlg = true;
                        }

                        if(lineChars[charIndex] == ')'){
                            bracketsFlgCount--;
                            if(bracketsFlgCount == 0)  bracketsFlg = false;
                        }
                    }

                    workStrBuf.append(lineChars[charIndex]);
                }
            }
        }

        // u in voĂ܂ňړ
        if(type.equals("")){
            workStrBuf = new StringBuffer();
            if(str.toLowerCase().indexOf("in") != -1){
                for(int charIndex = 0;charIndex < lineChars.length;charIndex++){
                // ݁u'v̒f
                if(singleQuotationFlg == false && bracketsFlg == false){

                    if(lineChars[charIndex] == ' ' && 
                       (lineChars[charIndex + 1] == 'i' || lineChars[charIndex + 1] == 'I') && 
                       (lineChars[charIndex + 2] == 'n' || lineChars[charIndex + 2] == 'N')){
                        // uinvoĂ̂ł܂ł̕A
                        leftStr = workStrBuf.toString();
                        rightStrBuf = new StringBuffer();

                        for(int lastIndex = charIndex + 3;lastIndex < lineChars.length;lastIndex++){
                            rightStrBuf.append(lineChars[lastIndex]);
                        }

                        rightStrBuf = new StringBuffer(rightStrBuf.toString().trim());

                        lineChars = rightStrBuf.toString().toCharArray();

                        // in傪w肳Ă邩`FbN
                        if(!(lineChars[0] == '(' && lineChars[lineChars.length - 1] == ')')) break;

                        type = WHERE_TYPE_IN;
                        break;
                    }
                }

                if(lineChars[charIndex] == '\''){
                    if(singleQuotationFlg == false){
                        singleQuotationFlg = true;
                    }else{
                        singleQuotationFlg = false;
                    }
                }

                if(singleQuotationFlg == false){
                    if(lineChars[charIndex] == '('){
                        bracketsFlgCount++;
                        bracketsFlg = true;
                    }

                    if(lineChars[charIndex] == ')'){
                        bracketsFlgCount--;
                        if(bracketsFlgCount == 0)  bracketsFlg = false;
                    }
                }

                workStrBuf.append(lineChars[charIndex]);
                }
            }
        }

        // ͂Ɏsꍇ̓G[s
        if(type.equals("") || 
           (leftStr == null || leftStr.trim().equals("")) || 
           (rightStrBuf == null || rightStrBuf.toString().trim().equals(""))){
            this.compErrFlg = true;
            this.compErrMsg = "WHERE傪sł:" + str;
            return null;
        }

        // 쐬i[
        retMap.put("TYPE",type);

        retMap.put("LEFT",leftStr.trim());
        // ӂ̌^𒲂ׂ
        retMap.put("LEFT_TYPE", this.checkStrType(leftStr.trim()));

        retMap.put("RIGHT", rightStrBuf.toString().trim());
        // where傪"in"ł͖ꍇEӂ̌^𒲂ׂ
        if (!type.equals(WHERE_TYPE_IN)) {
            retMap.put("RIGHT_TYPE", this.checkStrType(rightStrBuf.toString().trim()));
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
            this.compErrFlg = true;
            this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return retMap;
    }


    /**
     * `FbNWbN
     *
     */
    /*private void checkAll() {
        HashMap selectDt = null;
        HashMap fromDt = null;
        ArrayList whereDtList = null;
        HashMap whereDt = null;

        // SELECT`FbN
        // J`FbN
        if (this.selectColsDtList.size() < 1) {
            this.compErrFlg = true;
            this.compErrMsg = "SELECTɂ͍Œ1̓Jw肪Kvł:" + this.statement;
            return;
        }
        // J݃`FbN
        for (int i = 0; i < this.selectColsDtList.size(); i++) {
            selectDt = (HashMap)this.selectColsDtList.get(i);
            if (!DataDefineConfig.isExistColumn((String)selectDt.get("COLUMN_NAME"))) {
                this.compErrFlg = true;
                this.compErrMsg = "SELECTɑ݂ȂJw肳܂:" + (String)selectDt.get("COLUMN_NAME");
                return;
            }
        }


        // FROM`FbN
        // e[u`FbN
        if (this.fromTablesDtList.size() != 1) {
            this.compErrFlg = true;
            this.compErrMsg = "FROMɂ1e[uw肵o܂:" + this.statement;
            return;
        }
        // e[u݃`FbN
        // TODO:荇e[u"csv"Œɂ
        for (int i = 0; i < this.fromTablesDtList.size(); i++) {
            fromDt = (HashMap)this.fromTablesDtList.get(i);
            if (!((String)fromDt.get("TABLE_NAME")).toLowerCase().equals("csv")) {
                this.compErrFlg = true;
                this.compErrMsg = "FROMɂ́ucsvvƂe[ûݎwł܂:" + (String)fromDt.get("TABLE_NAME");
                return;
            }
        }


    }
*/

    /**
     * SQLFROMŕA̔zɂĕԂ
     * )uselect * from Atable,Btablev
     *                    
     *    String[0] = select * , String[1] = Atable,Btable
     * @param String sql SQL
     * @return String[] ̔z
     */
     private String[] splitSqlFrom(String targetStr) {

        String workSt = targetStr.trim();
        boolean checkFromStr = false;
        char[] sqlChars = workSt.toCharArray();
        String[] retList = new String[2];
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;

        String workStr = "";

        // u from voĂ܂ňړ
        for(int charIndex = 0;charIndex < sqlChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false){
                if(charIndex + 5 < sqlChars.length){
                    if(sqlChars[charIndex] == ' ' && 
                         (sqlChars[charIndex + 1] == 'f' || sqlChars[charIndex + 1] == 'F') &&
                         (sqlChars[charIndex + 2] == 'r' || sqlChars[charIndex + 2] == 'R')&&
                         (sqlChars[charIndex + 3] == 'o' || sqlChars[charIndex + 3] == 'O')&& 
                         (sqlChars[charIndex + 4] == 'm' || sqlChars[charIndex + 4] == 'M')&& 
                         sqlChars[charIndex + 5] == ' ' ){
                        // ufromvȂ̂ł܂ł̕i[
                        retList[0] = workStr;
                        workStr = "";
                        charIndex = charIndex + 5;
                        checkFromStr = true;
                    }
                }
            }

            if(sqlChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(sqlChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(sqlChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(sqlChars[charIndex]);
        }

        if(checkFromStr == false) {
            retList[0] = workStr;
            retList[1] = null;
        } else {
            retList[1] = workStr;
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
                this.compErrFlg = true;
                this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return retList;
    }


    /**
     * SQLwhereŕA̔zɂĕԂ
     * )uselect * from Atable,Btable where Atable.A = 'a'v
     *                    
     *    String[0] = select * from Atable,Btable, String[1] = Atable.A = 'a'
     * @param String sql SQL
     * @return String[] ̔z
     */
     private String[] splitSqlWhere(String targetStr) {
        targetStr = targetStr.trim();
        char[] sqlChars = targetStr.toCharArray();
        String[] workRet = new String[2];
        String[] retList = null;
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        boolean whereSplitedFlg = false;
        int bracketsFlgCount = 0;

        String workStr = "";

        // u where voĂ܂ňړ
        for(int charIndex = 0;charIndex < sqlChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false && whereSplitedFlg == false){
                if(charIndex + 6 < sqlChars.length){
                    if(sqlChars[charIndex] == ' ' && 
                      (sqlChars[charIndex + 1] == 'w' || sqlChars[charIndex + 1] == 'W') &&
                      (sqlChars[charIndex + 2] == 'h' || sqlChars[charIndex + 2] == 'H') &&
                      (sqlChars[charIndex + 3] == 'e' || sqlChars[charIndex + 3] == 'E') && 
                      (sqlChars[charIndex + 4] == 'r' || sqlChars[charIndex + 4] == 'R') && 
                      (sqlChars[charIndex + 5] == 'e' || sqlChars[charIndex + 5] == 'E') &&
                      sqlChars[charIndex + 6] == ' ' ){
                        // uwherevȂ̂ł܂ł̕i[
                        workRet[0] = workStr;
                        workStr = "";
                        charIndex = charIndex + 6;
                        whereSplitedFlg = true;
                    }
                }
            }

            if(sqlChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(sqlChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(sqlChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(sqlChars[charIndex]);
        }

        // "where"݂̑mF
        if(workRet[0] == null){

            // "where"Ȃ
            retList = new String[2];
            retList[0] = workStr;
            retList[1] = null;
        }else{
            retList = new String[2];
            retList[0] = workRet[0];
            retList[1] = workStr;
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
                this.compErrFlg = true;
                this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return retList;
    }


    /**
     * SQLORAwŕA̔zɂĕԂ
     * )ut1.ACODE = 'B' or t2.BCODE = 'C' and t2.CCODE = 'D' or t1.NAME = 'AA'v
     *                    
     *    String[0] = t1.ACODE = 'B' , String[1] = t2.BCODE = 'C' and t2.CCODE = 'D' , String[2] = t1.NAME = 'AA'
     * @param String sql SQL
     * @return String[] ̔z
     */
     public String[] splitSqlOr(String sql){

        ArrayList addStrList = new ArrayList(10);
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;

        String workStr = "";
        String[] retList;
        sql = sql.trim();
        char[] whereChars = sql.toCharArray();

        // u or voĂ܂ňړ
        for(int charIndex = 0;charIndex < whereChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false){
                if(charIndex + 3 < whereChars.length){
    
                    if(whereChars[charIndex] == ' ' && 
                       (whereChars[charIndex + 1] == 'o' || whereChars[charIndex + 1] == 'O') &&
                       (whereChars[charIndex + 2] == 'r' || whereChars[charIndex + 2] == 'R') &&
                       whereChars[charIndex + 3] == ' ' ){
                        // uandvȂ̂ł܂ł̕i[
                        addStrList.add(workStr);
                        workStr = "";
                        charIndex = charIndex + 3;
                    }
                }
            }
  
            if(whereChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(whereChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(whereChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(whereChars[charIndex]);
        }

        addStrList.add(workStr);
        retList = new String[addStrList.size()];
        for(int i = 0;i < addStrList.size();i++){
            retList[i] = (String)addStrList.get(i);
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
                this.compErrFlg = true;
                this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return retList;
    }


    /**
     * SQLANDAwŕA̔zɂĕԂ.<br>
     * ORAw݂͑Ȃ̂Ƃď
     * )ut1.ACODE = 'B' AND t2.BCODE = 'C' and t2.CCODE = 'D' AND t1.NAME = 'AA'v
     *                    
     *    String[0] = t1.ACODE = 'B' , String[1] = t2.BCODE = 'C' and t2.CCODE = 'D' , String[2] = t1.NAME = 'AA'
     * @param String sql SQL
     * @return String[] ̔z
     */
     public String[] splitSqlAnd(String whereSql){
        ArrayList addStrList = new ArrayList(10);
        boolean singleQuotationFlg = false;
        boolean bracketsFlg = false;
        int bracketsFlgCount = 0;

        String workStr = "";
        String[] retList;
        whereSql = whereSql.trim();
        char[] whereChars = whereSql.toCharArray();

        // u and voĂ܂ňړ
        for(int charIndex = 0;charIndex < whereChars.length;charIndex++){
            // ݁u'v̒f
            if(singleQuotationFlg == false && bracketsFlg == false){
                if(charIndex + 4 < whereChars.length){
                    if(whereChars[charIndex] == ' ' && 
                       (whereChars[charIndex + 1] == 'a' || whereChars[charIndex + 1] == 'A') &&
                       (whereChars[charIndex + 2] == 'n' || whereChars[charIndex + 2] == 'N') &&
                       (whereChars[charIndex + 3] == 'd' || whereChars[charIndex + 3] == 'D') && 
                       whereChars[charIndex + 4] == ' ' ){
                        // uandvȂ̂ł܂ł̕i[
                        addStrList.add(workStr);
                        workStr = "";
                        charIndex = charIndex + 4;
                    }
                }
            }

            if(whereChars[charIndex] == '\''){
                if(singleQuotationFlg == false){
                    singleQuotationFlg = true;
                }else{
                    singleQuotationFlg = false;
                }
            }

            if(singleQuotationFlg == false){
                if(whereChars[charIndex] == '('){
                    bracketsFlgCount++;
                    bracketsFlg = true;
                }

                if(whereChars[charIndex] == ')'){
                    bracketsFlgCount--;
                    if(bracketsFlgCount == 0)  bracketsFlg = false;
                }
            }

            workStr = workStr + String.valueOf(whereChars[charIndex]);
        }

        addStrList.add(workStr);
        retList = new String[addStrList.size()];
        for(int i = 0;i < addStrList.size();i++){
            retList[i] = (String)addStrList.get(i);
        }

        // "'""("IɏIĂȂ`FbN
        if (singleQuotationFlg == true || bracketsFlg == true) {
                this.compErrFlg = true;
                this.compErrMsg = "Xe[ggIĂ܂B:" + this.statement;
        }

        return retList;
    }


    /**
     * where̍ӕ񂪃e[u\Ă̂Al\Ă̂A\Ă̂Ԃ
     * ) utableA.column1v => "TABLE"
     *     u'AAA'v => "STRING"
     *     u100v => "NUMBER"
     *
     * @param String str fΏۂ̕
     * @return String f
     */
    public String checkStrType(String str){
        String ret = "";
        str = str.trim();
        int strLen = str.length();

        // ̐擪Ɩ𒲂ׂ
        if(str.indexOf("'") == 0 && (str.lastIndexOf("'") == (strLen-1))){
            // w
            ret = WHERE_VALUE_TYPE_STRING;
        }else{
            // float^ɃLXgALXgłȂꍇ̓e[uw
            try{
                float f = Float.parseFloat(str);
                ret = WHERE_VALUE_TYPE_NUMBER;

            }catch(Exception e){
                // Ȃ
                ret = WHERE_VALUE_TYPE_TABLE;
            }
        }
        return ret;
    }


    /**
     * SELECT폜.<br>
     */
    private String deleteSelectStr(String str) {
        str = str.trim();

        return str.substring(6, str.length());
        
    }


    /**
     * RpCG[̗LԂ.<br>
     * @return boolean true:G[ false:G[
     */
    public boolean isCompileErr() {
        return this.compErrFlg;
    }

    /**
     * RpCG[̃bZ[WԂ.<br>
     * @return String bZ[W
     */
    public String getCompileErrMsg() {
        return this.compErrMsg;
    }


    /**
     * gRpCXe[gg̃^CvԂ.<br>
     *
     * @return int ޔԍ
     */
    public int getStType() {
        return this.stTypeNumber;
    }
}
}