/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs.util;

import fuse.zipfs.util.Node;

public class Tree {
    Node rootNode = new Node();

    public Tree() {
        this.rootNode.setName("$ROOT");
        this.rootNode.setParent(this.rootNode);
    }

    public void addNode(String path, Object value) {
        Node node = this.rootNode;
        String[] pathParts = path.split("/");
        for (int i = 0; i < pathParts.length; ++i) {
            String pathPart = pathParts[i];
            if (pathPart.equals("") || pathPart.equals(".")) continue;
            if (pathPart.equals("..")) {
                node = node.getParent();
                continue;
            }
            Node childNode = node.getChild(pathPart);
            if (childNode == null) {
                childNode = new Node();
                childNode.setName(pathPart);
                childNode.setParent(node);
                node.addChild(childNode);
            }
            node = childNode;
        }
        node.setValue(value);
    }

    public Node lookupNode(String path) {
        Node node = this.rootNode;
        String[] pathParts = path.split("/");
        for (int i = 0; i < pathParts.length; ++i) {
            String pathPart = pathParts[i];
            if (pathPart.equals("") || pathPart.equals(".")) continue;
            if (pathPart.equals("..")) {
                node = node.getParent();
                continue;
            }
            if ((node = node.getChild(pathPart)) == null) break;
        }
        return node;
    }
}

