/*
 * Decompiled with CFR 0.152.
 */
package fuse.zipfs;

import fuse.FuseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipEntryDataReader {
    private static final Log log = LogFactory.getLog(ZipEntryDataReader.class);
    private static final int bufferSize = 8192;
    private ZipFile zipFile;
    private ZipEntry zipEntry;
    private BufferedInputStream zipStream;
    private long zipPos;
    private long zipMarkPos;

    public ZipEntryDataReader(ZipFile zipFile, ZipEntry zipEntry) {
        this.zipFile = zipFile;
        this.zipEntry = zipEntry;
    }

    public synchronized void read(ByteBuffer bb, long offset) throws FuseException {
        int nread;
        BufferedInputStream in = this.getZipStream(offset, bb.capacity());
        if (in == null) {
            return;
        }
        byte[] buff = new byte[bb.capacity()];
        try {
            nread = in.read(buff);
        }
        catch (IOException e) {
            throw new FuseException("IO error", e).initErrno(5);
        }
        if (nread > 0) {
            this.zipPos += (long)nread;
            bb.put(buff, 0, nread);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("read " + bb.position() + "/" + bb.capacity() + " requested bytes"));
        }
    }

    private BufferedInputStream getZipStream(long offset, int length) throws FuseException {
        try {
            while (true) {
                if (this.zipStream == null) {
                    this.zipStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipEntry), 8192);
                    this.zipPos = 0L;
                    this.zipStream.mark(8192);
                    this.zipMarkPos = 0L;
                }
                if (offset == this.zipPos) {
                    this.zipStream.mark(8192);
                    this.zipMarkPos = this.zipPos;
                    return this.zipStream;
                }
                while (offset > this.zipPos) {
                    this.zipStream.mark(8192);
                    this.zipMarkPos = this.zipPos;
                    long nSkiped = this.zipStream.skip(offset - this.zipPos);
                    if (nSkiped == 0L) {
                        return null;
                    }
                    this.zipPos += nSkiped;
                }
                if (offset == this.zipPos) {
                    return this.zipStream;
                }
                if (offset >= this.zipMarkPos) {
                    try {
                        this.zipStream.reset();
                        this.zipPos = this.zipMarkPos;
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.zipStream.close();
                this.zipStream = null;
            }
        }
        catch (IOException e) {
            throw new FuseException("IO error", e).initErrno(5);
        }
    }
}

