/*
 * Decompiled with CFR 0.152.
 */
package fuse.staticfs;

import fuse.FuseException;
import fuse.compat.FuseStat;
import fuse.staticfs.FileNode;
import java.nio.ByteBuffer;

public class ReadOnlyFileNode
extends FileNode {
    private byte[] content;

    public ReadOnlyFileNode(String name) {
        this(name, new byte[0]);
    }

    public ReadOnlyFileNode(String name, byte[] content) {
        super(name);
        this.setContent(content);
    }

    protected FuseStat createStat() {
        FuseStat stat = new FuseStat();
        stat.mode = 33060;
        stat.gid = 0;
        stat.uid = 0;
        stat.mtime = stat.atime = (int)(System.currentTimeMillis() / 1000L);
        stat.ctime = stat.atime;
        stat.size = 0L;
        stat.blocks = 0;
        return stat;
    }

    public synchronized void read(ByteBuffer buff, long offset) throws FuseException {
        if (offset >= (long)this.content.length) {
            return;
        }
        int length = buff.capacity();
        if (offset + (long)length > (long)this.content.length) {
            length = this.content.length - (int)offset;
        }
        buff.put(this.content, (int)offset, length);
    }

    public void write(ByteBuffer buff, long offset) throws FuseException {
        throw new FuseException("Read Only").initErrno(30);
    }

    public void open(int flags) throws FuseException {
        if (flags == 2 || flags == 1) {
            throw new FuseException("Read Only").initErrno(30);
        }
    }

    public void release(int flags) throws FuseException {
    }

    public void truncate(long size) throws FuseException {
        throw new FuseException("Read Only").initErrno(30);
    }

    public void utime(int atime, int mtime) throws FuseException {
    }

    public synchronized byte[] getContent() {
        return this.content;
    }

    public synchronized void setContent(byte[] content) {
        FuseStat stat = (FuseStat)super.getStat().clone();
        if (this.content == null) {
            stat.ctime = (int)(System.currentTimeMillis() / 1000L);
        }
        this.content = content;
        stat.mtime = stat.atime = (int)(System.currentTimeMillis() / 1000L);
        stat.size = content.length;
        stat.blocks = (content.length + 511) / 512;
        super.setStat(stat);
    }
}

