/*
 * Decompiled with CFR 0.152.
 */
package fuse.staticfs;

import fuse.compat.FuseStat;
import fuse.staticfs.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DirectoryNode
extends Node {
    private Map children = new HashMap();

    public DirectoryNode(String name) {
        super(name);
    }

    protected FuseStat createStat() {
        FuseStat stat = new FuseStat();
        stat.mode = 16877;
        stat.gid = 0;
        stat.uid = 0;
        stat.mtime = stat.atime = (int)(System.currentTimeMillis() / 1000L);
        stat.ctime = stat.atime;
        stat.size = 0L;
        stat.blocks = 0;
        return stat;
    }

    public synchronized Node addChild(Node node) {
        Node previousNode = this.children.put(node.getName(), node);
        node.setParent(this);
        FuseStat stat = (FuseStat)this.getStat().clone();
        stat.mtime = stat.atime = (int)(System.currentTimeMillis() / 1000L);
        this.setStat(stat);
        if (previousNode != null) {
            previousNode.setParent(null);
        }
        return previousNode;
    }

    public synchronized Node removeChild(String name) {
        Node removedNode = (Node)this.children.remove(name);
        if (removedNode != null) {
            FuseStat stat = (FuseStat)this.getStat().clone();
            stat.mtime = stat.atime = (int)(System.currentTimeMillis() / 1000L);
            this.setStat(stat);
            removedNode.setParent(null);
        }
        return removedNode;
    }

    public synchronized Node getChild(String name) {
        return (Node)this.children.get(name);
    }

    public synchronized Node[] getChildren() {
        Collection childNodes = this.children.values();
        return childNodes.toArray(new Node[childNodes.size()]);
    }
}

