/*
 * Decompiled with CFR 0.152.
 */
package fuse.compat;

import fuse.Filesystem3;
import fuse.FuseDirFiller;
import fuse.FuseException;
import fuse.FuseGetattrSetter;
import fuse.FuseOpenSetter;
import fuse.FuseStatfs;
import fuse.FuseStatfsSetter;
import fuse.compat.Filesystem2;
import fuse.compat.FuseDirEnt;
import fuse.compat.FuseStat;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class Filesystem2ToFilesystem3Adapter
implements Filesystem3 {
    private Filesystem2 fs2;

    public Filesystem2ToFilesystem3Adapter(Filesystem2 fs2) {
        this.fs2 = fs2;
    }

    public int getattr(String path, FuseGetattrSetter getattrSetter) throws FuseException {
        FuseStat stat = this.fs2.getattr(path);
        getattrSetter.set(stat.inode, stat.mode, stat.nlink, stat.uid, stat.gid, 0, stat.size, stat.blocks, stat.atime, stat.mtime, stat.ctime);
        return 0;
    }

    public int chmod(String path, int mode) throws FuseException {
        this.fs2.chmod(path, mode);
        return 0;
    }

    public int chown(String path, int uid, int gid) throws FuseException {
        this.fs2.chown(path, uid, gid);
        return 0;
    }

    public int flush(String path, Object fh) throws FuseException {
        this.fs2.flush(path, fh == null ? 0L : (Long)fh);
        return 0;
    }

    public int fsync(String path, Object fh, boolean isDatasync) throws FuseException {
        this.fs2.fsync(path, fh == null ? 0L : (Long)fh, isDatasync);
        return 0;
    }

    public int getdir(String path, FuseDirFiller filler) throws FuseException {
        for (FuseDirEnt entry : this.fs2.getdir(path)) {
            filler.add(entry.name, entry.inode, entry.mode);
        }
        return 0;
    }

    public int link(String from, String to) throws FuseException {
        this.fs2.link(from, to);
        return 0;
    }

    public int mkdir(String path, int mode) throws FuseException {
        this.fs2.mkdir(path, mode);
        return 0;
    }

    public int mknod(String path, int mode, int rdev) throws FuseException {
        this.fs2.mknod(path, mode, rdev);
        return 0;
    }

    public int open(String path, int flags, FuseOpenSetter openSetter) throws FuseException {
        openSetter.setFh(new Long(this.fs2.open(path, flags)));
        return 0;
    }

    public int read(String path, Object fh, ByteBuffer buf, long offset) throws FuseException {
        this.fs2.read(path, fh == null ? 0L : (Long)fh, buf, offset);
        return 0;
    }

    public int readlink(String path, CharBuffer link) throws FuseException {
        link.put(this.fs2.readlink(path));
        return 0;
    }

    public int release(String path, Object fh, int flags) throws FuseException {
        this.fs2.release(path, fh == null ? 0L : (Long)fh, flags);
        return 0;
    }

    public int rename(String from, String to) throws FuseException {
        this.fs2.rename(from, to);
        return 0;
    }

    public int rmdir(String path) throws FuseException {
        this.fs2.rmdir(path);
        return 0;
    }

    public int statfs(FuseStatfsSetter statfsSetter) throws FuseException {
        FuseStatfs statfs = this.fs2.statfs();
        statfsSetter.set(statfs.blockSize, statfs.blocks, statfs.blocksFree, statfs.blocksAvail, statfs.files, statfs.filesFree, statfs.namelen);
        return 0;
    }

    public int symlink(String from, String to) throws FuseException {
        this.fs2.symlink(from, to);
        return 0;
    }

    public int truncate(String path, long size) throws FuseException {
        this.fs2.truncate(path, size);
        return 0;
    }

    public int unlink(String path) throws FuseException {
        this.fs2.unlink(path);
        return 0;
    }

    public int utime(String path, int atime, int mtime) throws FuseException {
        this.fs2.utime(path, atime, mtime);
        return 0;
    }

    public int write(String path, Object fh, boolean isWritepage, ByteBuffer buf, long offset) throws FuseException {
        this.fs2.write(path, fh == null ? 0L : (Long)fh, isWritepage, buf, offset);
        return 0;
    }
}

