/*
 * Decompiled with CFR 0.152.
 */
package fuse.okuyamafs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okuyama.imdst.client.OkuyamaClient;
import okuyama.imdst.client.OkuyamaClientFactory;
import okuyama.imdst.util.SystemUtil;

public class ExpireCacheMap
extends LinkedHashMap {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private int maxCacheSize = 8192;
    private long cacheExpireTime = 15001L;
    private OkuyamaClientFactory factory = null;
    private boolean compress = true;

    public ExpireCacheMap() {
        super(1024, 0.75f, true);
    }

    public ExpireCacheMap(int maxCacheCapacity) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
    }

    public ExpireCacheMap(int maxCacheCapacity, long expireTime) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.cacheExpireTime = expireTime;
    }

    public ExpireCacheMap(int maxCacheCapacity, long expireTime, boolean compress) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.cacheExpireTime = expireTime;
        this.compress = compress;
    }

    public ExpireCacheMap(int maxCacheCapacity, long expireTime, OkuyamaClientFactory factory) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.cacheExpireTime = expireTime;
        this.factory = factory;
    }

    public ExpireCacheMap(int maxCacheCapacity, long expireTime, OkuyamaClientFactory factory, boolean compress) {
        super(maxCacheCapacity, 0.75f, true);
        this.maxCacheSize = maxCacheCapacity;
        this.cacheExpireTime = expireTime;
        this.factory = factory;
        this.compress = compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.w.lock();
        try {
            if (value instanceof byte[]) {
                Object[] valSt = new Object[]{this.compress ? (Object)SystemUtil.dataCompress((byte[])((byte[])value)) : (Object)((byte[])value), new Long(System.currentTimeMillis())};
                Object[] objectArray = super.put(key, valSt);
                return objectArray;
            }
            Object[] valSt = new Object[]{value, new Long(System.currentTimeMillis())};
            Object[] objectArray = super.put(key, valSt);
            return objectArray;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, Integer realStartPoint, long cacheSetTime) {
        this.w.lock();
        try {
            Object[] valSt = (Object[])super.get(key);
            if (valSt != null) {
                byte[] replaceBytes = null;
                replaceBytes = this.compress ? SystemUtil.dataDecompress((byte[])((byte[])valSt[0])) : (byte[])valSt[0];
                int realStartPointInt = realStartPoint;
                System.arraycopy((byte[])value, realStartPointInt, replaceBytes, realStartPointInt, ((byte[])value).length - realStartPointInt);
                value = replaceBytes;
                if (valSt.length > 2) {
                    int beforeRealStP = (Integer)valSt[2];
                    if (realStartPointInt > realStartPointInt) {
                        realStartPoint = (Integer)valSt[2];
                    }
                }
            }
            valSt = new Object[]{this.compress ? (Object)SystemUtil.dataCompress((byte[])((byte[])value)) : (Object)((byte[])value), new Long(cacheSetTime), realStartPoint};
            Object[] objectArray = super.put(key, valSt);
            return objectArray;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            Object[] valSt = (Object[])super.get(key);
            if (valSt == null) {
                boolean bl = false;
                return bl;
            }
            Long cacheTime = (Long)valSt[1];
            if (System.currentTimeMillis() - cacheTime < this.cacheExpireTime) {
                boolean bl = true;
                return bl;
            }
            super.remove(key);
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (!super.containsKey(key)) {
            return null;
        }
        this.r.lock();
        try {
            Object[] valSt = (Object[])super.get(key);
            if (valSt == null) {
                Object var3_4 = null;
                return var3_4;
            }
            Long cacheTime = (Long)valSt[1];
            if (valSt.length < 3) {
                if (System.currentTimeMillis() - cacheTime < this.cacheExpireTime) {
                    if (valSt[0] instanceof byte[]) {
                        if (this.compress) {
                            byte[] byArray = SystemUtil.dataDecompress((byte[])((byte[])valSt[0]));
                            return byArray;
                        }
                        byte[] byArray = (byte[])valSt[0];
                        return byArray;
                    }
                    Object object = valSt[0];
                    return object;
                }
                super.remove(key);
                Object var4_9 = null;
                return var4_9;
            }
            Integer realStartPoint = (Integer)valSt[2];
            OkuyamaClient client = this.factory.getClient(300000);
            Object[] replaceRet = client.readByteValue((String)key);
            byte[] value = null;
            value = this.compress ? SystemUtil.dataDecompress((byte[])((byte[])valSt[0])) : (byte[])valSt[0];
            byte[] replaceBytes = null;
            if (replaceRet[0].equals("true")) {
                replaceBytes = (byte[])replaceRet[1];
                if (replaceBytes != null) {
                    int realStartPointInt = realStartPoint;
                    System.arraycopy(value, realStartPointInt, replaceBytes, realStartPointInt, value.length - realStartPointInt);
                } else {
                    replaceBytes = value;
                }
            }
            if (replaceBytes == null) {
                Object var9_16 = null;
                return var9_16;
            }
            valSt = new Object[]{this.compress ? (Object)SystemUtil.dataCompress((byte[])replaceBytes) : (Object)replaceBytes, cacheTime};
            super.put(key, valSt);
            byte[] byArray = replaceBytes;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        this.w.lock();
        try {
            Object ret;
            Object v = ret = super.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoreTmpCache(Object key, long storeTime) {
        this.w.lock();
        try {
            Long cacheSetTime;
            Object[] cache = (Object[])super.get(key);
            if (cache != null && (cacheSetTime = (Long)cache[1]) == storeTime) {
                super.remove(key);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            super.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        Object[] valSt = (Object[])eldest.getValue();
        if (valSt != null && valSt.length == 3) {
            return false;
        }
        if (this.maxCacheSize < super.size()) {
            return true;
        }
        if (valSt == null) {
            return true;
        }
        Long cacheTime = (Long)valSt[1];
        return System.currentTimeMillis() - cacheTime >= this.cacheExpireTime;
    }
}

