/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okuyama.imdst.util.ImdstDefine;
import okuyama.imdst.util.ValueCacheMap;

public abstract class AbstractDataRandomAccess
extends RandomAccessFile {
    protected File dataFile = null;
    protected DataFilePageCacheMapper dataCacheMapper = null;
    protected ValueCacheMap highReferenceFrequencyMap = null;
    protected ConcurrentHashMap highReferencedMapCopy = null;
    protected boolean execMappingFlg = ImdstDefine.pageCacheMappendFlg;
    protected static int pageCacheMappendSize = ImdstDefine.pageCacheMappendSize;

    public AbstractDataRandomAccess(File target, String type) throws FileNotFoundException {
        super(target, type);
        this.dataFile = target;
        try {
            if (this.execMappingFlg) {
                this.highReferencedMapCopy = new ConcurrentHashMap(pageCacheMappendSize);
                this.highReferenceFrequencyMap = new ValueCacheMap(pageCacheMappendSize, this.highReferencedMapCopy);
                this.dataCacheMapper = new DataFilePageCacheMapper(target);
                this.dataCacheMapper.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void setDataPointMap(Map var1);

    public abstract void requestSeekPoint(long var1, int var3, int var4);

    public abstract int seekAndRead(long var1, byte[] var3, int var4, int var5, Object var6) throws IOException;

    @Override
    public void close() throws IOException {
        try {
            if (this.execMappingFlg) {
                this.dataCacheMapper.close();
                this.dataCacheMapper.join(3000L);
            }
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void putHighReferenceData(long seekPoint) {
        if (this.execMappingFlg) {
            this.highReferenceFrequencyMap.put(new Long(seekPoint), (Object)null);
        }
    }

    class DataFilePageCacheMapper
    extends Thread {
        private boolean runFlg = false;
        private File dataFile = null;

        public DataFilePageCacheMapper(File dataFile) {
            this.dataFile = dataFile;
            this.runFlg = true;
        }

        @Override
        public void run() {
            while (this.runFlg) {
                try {
                    Thread.sleep(2500L);
                    long start = System.nanoTime();
                    RandomAccessFile raf = new RandomAccessFile(this.dataFile, "r");
                    byte[] data = new byte[ImdstDefine.dataFileWriteMaxSize];
                    Set entrySet = AbstractDataRandomAccess.this.highReferencedMapCopy.entrySet();
                    Iterator entryIte = entrySet.iterator();
                    int count = 0;
                    while (entryIte.hasNext()) {
                        Map.Entry obj = entryIte.next();
                        if (obj == null) continue;
                        try {
                            Long seekPoint = (Long)obj.getKey();
                            raf.seek(seekPoint);
                            raf.read(data, 0, ImdstDefine.dataFileWriteMaxSize);
                            if (count % 10 == 0) {
                                if (!this.runFlg) break;
                                Thread.sleep(30L);
                            }
                        }
                        catch (IOException e) {
                            AbstractDataRandomAccess.this.highReferenceFrequencyMap.remove(obj.getKey());
                            AbstractDataRandomAccess.this.highReferencedMapCopy.remove(obj.getKey());
                        }
                        ++count;
                    }
                    data = null;
                    raf.close();
                    raf = null;
                    long end = System.nanoTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.runFlg = false;
        }
    }
}

