/*
 * Decompiled with CFR 0.152.
 */
package okuyama.imdst.util;

import java.io.BufferedWriter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import okuyama.imdst.util.SystemUtil;

class DataTransactionFileFlushDaemon
extends Thread {
    private volatile ArrayBlockingQueue delayWriteQueue = new ArrayBlockingQueue(4096);
    public volatile boolean execFlg = true;
    public volatile String tFilePath = null;
    public volatile BufferedWriter tBw = null;
    public Object daemonSyncObj = new Object();
    public volatile boolean executeEnd = false;

    DataTransactionFileFlushDaemon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean writeCount = false;
        String writeStr = null;
        boolean bufferUseCount = false;
        int maxBufferUseCount = 1000000;
        while (this.execFlg) {
            try {
                Object strBuf;
                if (writeStr == null) {
                    strBuf = new StringBuilder();
                    for (int i = 0; i < 10; ++i) {
                        String tmp = (String)this.delayWriteQueue.poll(200L, TimeUnit.MILLISECONDS);
                        if (tmp == null) continue;
                        ((StringBuilder)strBuf).append(tmp);
                    }
                    writeStr = ((StringBuilder)strBuf).toString();
                    if (writeStr == null || writeStr.equals("")) {
                        writeStr = null;
                    }
                }
                strBuf = this.daemonSyncObj;
                synchronized (strBuf) {
                    if (this.tBw != null && writeStr != null) {
                        this.tBw.write(writeStr);
                        SystemUtil.diskAccessSync(this.tBw);
                        writeStr = null;
                    }
                }
            }
            catch (Throwable te) {
                te.printStackTrace();
            }
        }
        this.executeEnd = true;
    }

    public ArrayBlockingQueue getDataTransactionFileQueue() {
        return this.delayWriteQueue;
    }

    public void setDataTransactionFileQueue(ArrayBlockingQueue queue) {
        this.delayWriteQueue = queue;
    }

    public boolean getExecuteEnd() {
        return this.executeEnd;
    }

    public void addDataTransaction(String str) {
        while (true) {
            try {
                this.delayWriteQueue.put(str);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.daemonSyncObj;
        synchronized (object) {
            if (this.tBw != null) {
                try {
                    SystemUtil.diskAccessSync(this.tBw);
                }
                catch (Throwable te) {
                    te.printStackTrace();
                }
                finally {
                    try {
                        this.tBw.close();
                    }
                    catch (Throwable te2) {
                        te2.printStackTrace();
                    }
                    this.tBw = null;
                    this.tFilePath = null;
                }
            }
        }
    }
}

