/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;

class MapOutput<K, V> {
    private static final Log LOG = LogFactory.getLog(MapOutput.class);
    private static AtomicInteger ID = new AtomicInteger(0);
    private final int id = ID.incrementAndGet();
    private final MergeManager<K, V> merger;
    private final TaskAttemptID mapId;
    private final long size;
    private final byte[] memory;
    private BoundedByteArrayOutputStream byteStream;
    private final FileSystem localFS;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final OutputStream disk;
    private final Type type;
    private final boolean primaryMapOutput;

    MapOutput(TaskAttemptID mapId, MergeManager<K, V> merger, long size, JobConf conf, LocalDirAllocator localDirAllocator, int fetcher, boolean primaryMapOutput) throws IOException {
        this.mapId = mapId;
        this.merger = merger;
        this.type = Type.DISK;
        this.memory = null;
        this.byteStream = null;
        this.size = size;
        this.localFS = FileSystem.getLocal((Configuration)conf);
        String filename = "map_" + mapId.getTaskID().getId() + ".out";
        String tmpOutput = "/" + TaskTracker.getJobCacheSubdir(conf.getUser()) + "/" + mapId.getJobID() + "/" + merger.getReduceId() + "/" + "output" + "/" + filename + "." + fetcher;
        this.tmpOutputPath = localDirAllocator.getLocalPathForWrite(tmpOutput, size, (Configuration)conf);
        this.outputPath = new Path(this.tmpOutputPath.getParent(), filename);
        this.disk = this.localFS.create(this.tmpOutputPath);
        this.primaryMapOutput = primaryMapOutput;
    }

    MapOutput(TaskAttemptID mapId, MergeManager<K, V> merger, int size, boolean primaryMapOutput) {
        this.mapId = mapId;
        this.merger = merger;
        this.type = Type.MEMORY;
        this.byteStream = new BoundedByteArrayOutputStream(size);
        this.memory = this.byteStream.getBuffer();
        this.size = size;
        this.localFS = null;
        this.disk = null;
        this.outputPath = null;
        this.tmpOutputPath = null;
        this.primaryMapOutput = primaryMapOutput;
    }

    public MapOutput(TaskAttemptID mapId) {
        this.mapId = mapId;
        this.type = Type.WAIT;
        this.merger = null;
        this.memory = null;
        this.byteStream = null;
        this.size = -1L;
        this.localFS = null;
        this.disk = null;
        this.outputPath = null;
        this.tmpOutputPath = null;
        this.primaryMapOutput = false;
    }

    public boolean isPrimaryMapOutput() {
        return this.primaryMapOutput;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapOutput) {
            return this.id == ((MapOutput)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public byte[] getMemory() {
        return this.memory;
    }

    public BoundedByteArrayOutputStream getArrayStream() {
        return this.byteStream;
    }

    public OutputStream getDisk() {
        return this.disk;
    }

    public TaskAttemptID getMapId() {
        return this.mapId;
    }

    public Type getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public void commit() throws IOException {
        if (this.type == Type.MEMORY) {
            this.merger.closeInMemoryFile(this);
        } else if (this.type == Type.DISK) {
            this.localFS.rename(this.tmpOutputPath, this.outputPath);
            this.merger.closeOnDiskFile(this.outputPath);
        } else {
            throw new IOException("Cannot commit MapOutput of type WAIT!");
        }
    }

    public void abort() {
        if (this.type == Type.MEMORY) {
            this.merger.unreserve(this.memory.length);
        } else if (this.type == Type.DISK) {
            try {
                this.localFS.delete(this.tmpOutputPath, false);
            }
            catch (IOException ie) {
                LOG.info((Object)("failure to clean up " + this.tmpOutputPath), (Throwable)ie);
            }
        } else {
            throw new IllegalArgumentException("Cannot commit MapOutput with of type WAIT!");
        }
    }

    public String toString() {
        return "MapOutput(" + this.mapId + ", " + (Object)((Object)this.type) + ")";
    }

    public static class MapOutputComparator<K, V>
    implements Comparator<MapOutput<K, V>> {
        @Override
        public int compare(MapOutput<K, V> o1, MapOutput<K, V> o2) {
            if (((MapOutput)o1).id == ((MapOutput)o2).id) {
                return 0;
            }
            if (((MapOutput)o1).size < ((MapOutput)o2).size) {
                return -1;
            }
            if (((MapOutput)o1).size > ((MapOutput)o2).size) {
                return 1;
            }
            if (((MapOutput)o1).id < ((MapOutput)o2).id) {
                return -1;
            }
            return 1;
        }
    }

    public static enum Type {
        WAIT,
        MEMORY,
        DISK;

    }
}

