/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TaskInputOutputContextImpl<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends TaskAttemptContextImpl
implements TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private RecordWriter<KEYOUT, VALUEOUT> output;
    private StatusReporter reporter;
    private OutputCommitter committer;

    public TaskInputOutputContextImpl(Configuration conf, TaskAttemptID taskid, RecordWriter<KEYOUT, VALUEOUT> output, OutputCommitter committer, StatusReporter reporter) {
        super(conf, taskid);
        this.output = output;
        this.reporter = reporter;
        this.committer = committer;
    }

    @Override
    public abstract boolean nextKeyValue() throws IOException, InterruptedException;

    @Override
    public abstract KEYIN getCurrentKey() throws IOException, InterruptedException;

    @Override
    public abstract VALUEIN getCurrentValue() throws IOException, InterruptedException;

    @Override
    public void write(KEYOUT key, VALUEOUT value) throws IOException, InterruptedException {
        this.output.write(key, value);
    }

    @Override
    public Counter getCounter(Enum<?> counterName) {
        return this.reporter.getCounter(counterName);
    }

    @Override
    public Counter getCounter(String groupName, String counterName) {
        return this.reporter.getCounter(groupName, counterName);
    }

    @Override
    public OutputCommitter getOutputCommitter() {
        return this.committer;
    }
}

