/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.DataInput;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    private static TokenStorage tokenStorage;
    @InterfaceAudience.Private
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    @InterfaceAudience.Private
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN;

    public static byte[] getSecretKey(Text alias) {
        if (tokenStorage == null) {
            return null;
        }
        return tokenStorage.getSecretKey(alias);
    }

    public static void addSecretKey(Text alias, byte[] key) {
        TokenCache.getTokenStorage().addSecretKey(alias, key);
    }

    public static void addDelegationToken(String namenode, Token<? extends TokenIdentifier> t) {
        TokenCache.getTokenStorage().addToken(new Text(namenode), t);
    }

    public static Collection<Token<? extends TokenIdentifier>> getAllTokens() {
        return TokenCache.getTokenStorage().getAllTokens();
    }

    public static void obtainTokensForNamenodes(Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(ps, conf);
    }

    static void obtainTokensForNamenodesInternal(Path[] ps, Configuration conf) throws IOException {
        Text jtCreds = new Text(conf.get("mapreduce.job.kerberos.jtprinicipal", ""));
        for (Path p : ps) {
            FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)conf);
            if (!(fs instanceof DistributedFileSystem)) continue;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            URI uri = fs.getUri();
            String fs_addr = TokenCache.buildDTServiceName(uri);
            Token token = TokenCache.getDelegationToken(fs_addr);
            if (token != null) {
                LOG.debug((Object)("DT for " + token.getService() + " is already present"));
                continue;
            }
            token = dfs.getDelegationToken(jtCreds);
            if (token == null) {
                throw new IOException("Token from " + fs_addr + " is null");
            }
            token.setService(new Text(fs_addr));
            TokenCache.addDelegationToken(fs_addr, (Token<? extends TokenIdentifier>)token);
            LOG.info((Object)("getting dt for " + p.toString() + ";uri=" + fs_addr + ";t.service=" + token.getService()));
        }
    }

    @InterfaceAudience.Private
    public static Token<DelegationTokenIdentifier> getDelegationToken(String namenode) {
        return TokenCache.getTokenStorage().getToken(new Text(namenode));
    }

    @InterfaceAudience.Private
    public static TokenStorage getTokenStorage() {
        if (tokenStorage == null) {
            tokenStorage = new TokenStorage();
        }
        return tokenStorage;
    }

    @InterfaceAudience.Private
    public static void setTokenStorage(TokenStorage ts) {
        if (tokenStorage != null) {
            LOG.warn((Object)("Overwriting existing token storage with # keys=" + tokenStorage.numberOfSecretKeys()));
        }
        tokenStorage = ts;
    }

    @InterfaceAudience.Private
    public static TokenStorage loadTaskTokenStorage(String fileName, JobConf conf) throws IOException {
        if (tokenStorage != null) {
            return tokenStorage;
        }
        tokenStorage = TokenCache.loadTokens(fileName, conf);
        return tokenStorage;
    }

    @InterfaceAudience.Private
    public static TokenStorage loadTokens(String jobTokenFile, JobConf conf) throws IOException {
        Path localJobTokenFile = new Path(jobTokenFile);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream in = localFS.open(localJobTokenFile);
        TokenStorage ts = new TokenStorage();
        ts.readFields((DataInput)in);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys()));
        }
        in.close();
        return ts;
    }

    @InterfaceAudience.Private
    public static void setJobToken(Token<? extends TokenIdentifier> t, TokenStorage ts) {
        ts.addToken(JOB_TOKEN, t);
    }

    @InterfaceAudience.Private
    public static Token<JobTokenIdentifier> getJobToken(TokenStorage ts) {
        return ts.getToken(JOB_TOKEN);
    }

    static String buildDTServiceName(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = 8020;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(NetUtils.normalizeHostName((String)uri.getHost())).append(":").append(port);
        return sb.toString();
    }

    static {
        JOB_TOKEN = new Text("ShuffleAndJobToken");
    }
}

