/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinished;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobFinishedEvent
implements HistoryEvent {
    private JobFinished datum = new JobFinished();

    public JobFinishedEvent(JobID id, long finishTime, int finishedMaps, int finishedReduces, int failedMaps, int failedReduces, Counters mapCounters, Counters reduceCounters, Counters totalCounters) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.finishTime = finishTime;
        this.datum.finishedMaps = finishedMaps;
        this.datum.finishedReduces = finishedReduces;
        this.datum.failedMaps = failedMaps;
        this.datum.failedReduces = failedReduces;
        this.datum.mapCounters = EventWriter.toAvro(mapCounters, "MAP_COUNTERS");
        this.datum.reduceCounters = EventWriter.toAvro(reduceCounters, "REDUCE_COUNTERS");
        this.datum.totalCounters = EventWriter.toAvro(totalCounters, "TOTAL_COUNTERS");
    }

    JobFinishedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobFinished)((Object)datum);
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_FINISHED;
    }

    public JobID getJobid() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public long getFinishTime() {
        return this.datum.finishTime;
    }

    public int getFinishedMaps() {
        return this.datum.finishedMaps;
    }

    public int getFinishedReduces() {
        return this.datum.finishedReduces;
    }

    public int getFailedMaps() {
        return this.datum.failedMaps;
    }

    public int getFailedReduces() {
        return this.datum.failedReduces;
    }

    public Counters getTotalCounters() {
        return EventReader.fromAvro(this.datum.totalCounters);
    }

    public Counters getMapCounters() {
        return EventReader.fromAvro(this.datum.mapCounters);
    }

    public Counters getReduceCounters() {
        return EventReader.fromAvro(this.datum.reduceCounters);
    }
}

