/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.util.ProcessTree;
import org.apache.hadoop.mapreduce.util.ProcfsBasedProcessTree;
import org.apache.hadoop.util.StringUtils;

class TaskMemoryManagerThread
extends Thread {
    private static Log LOG = LogFactory.getLog(TaskMemoryManagerThread.class);
    private TaskTracker taskTracker;
    private long monitoringInterval;
    private long maxMemoryAllowedForAllTasks;
    private long maxRssMemoryAllowedForAllTasks;
    private Map<TaskAttemptID, ProcessTreeInfo> processTreeInfoMap;
    private Map<TaskAttemptID, ProcessTreeInfo> tasksToBeAdded;
    private List<TaskAttemptID> tasksToBeRemoved;
    private static final String MEMORY_USAGE_STRING = "Memory usage of ProcessTree %s for task-id %s : Virutal %d bytes, limit : %d bytes; Physical %d bytes, limit %d bytes";

    public TaskMemoryManagerThread(TaskTracker taskTracker) {
        this(taskTracker.getTotalMemoryAllottedForTasksOnTT() * 1024L * 1024L, taskTracker.getJobConf().getLong("mapreduce.tasktracker.taskmemorymanager.monitoringinterval", 5000L));
        this.taskTracker = taskTracker;
        long reservedRssMemory = taskTracker.getReservedPhysicalMemoryOnTT();
        long totalPhysicalMemoryOnTT = taskTracker.getTotalPhysicalMemoryOnTT();
        this.maxRssMemoryAllowedForAllTasks = reservedRssMemory == -1L || totalPhysicalMemoryOnTT == -1L ? -1L : totalPhysicalMemoryOnTT - reservedRssMemory;
    }

    TaskMemoryManagerThread(long maxMemoryAllowedForAllTasks, long monitoringInterval) {
        this.setName(this.getClass().getName());
        this.processTreeInfoMap = new HashMap<TaskAttemptID, ProcessTreeInfo>();
        this.tasksToBeAdded = new HashMap<TaskAttemptID, ProcessTreeInfo>();
        this.tasksToBeRemoved = new ArrayList<TaskAttemptID>();
        this.maxMemoryAllowedForAllTasks = maxMemoryAllowedForAllTasks < 0L ? -1L : maxMemoryAllowedForAllTasks;
        this.monitoringInterval = monitoringInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(TaskAttemptID tid, long memLimit, long memLimitPhysical) {
        Map<TaskAttemptID, ProcessTreeInfo> map = this.tasksToBeAdded;
        synchronized (map) {
            LOG.debug((Object)("Tracking ProcessTree " + tid + " for the first time"));
            ProcessTreeInfo ptInfo = new ProcessTreeInfo(tid, null, null, memLimit, memLimitPhysical);
            this.tasksToBeAdded.put(tid, ptInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(TaskAttemptID tid) {
        List<TaskAttemptID> list = this.tasksToBeRemoved;
        synchronized (list) {
            this.tasksToBeRemoved.add(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info((Object)("Starting thread: " + this.getClass()));
        while (true) {
            List<TaskAttemptID> tmp;
            if (LOG.isDebugEnabled()) {
                tmp = new StringBuffer("[ ");
                for (ProcessTreeInfo p : this.processTreeInfoMap.values()) {
                    ((StringBuffer)((Object)tmp)).append(p.getPID());
                    ((StringBuffer)((Object)tmp)).append(" ");
                }
                LOG.debug((Object)("Current ProcessTree list : " + ((StringBuffer)((Object)tmp)).substring(0, ((StringBuffer)((Object)tmp)).length()) + "]"));
            }
            tmp = this.tasksToBeAdded;
            synchronized (tmp) {
                this.processTreeInfoMap.putAll(this.tasksToBeAdded);
                this.tasksToBeAdded.clear();
            }
            tmp = this.tasksToBeRemoved;
            synchronized (tmp) {
                for (TaskAttemptID tid : this.tasksToBeRemoved) {
                    this.processTreeInfoMap.remove(tid);
                }
                this.tasksToBeRemoved.clear();
            }
            long memoryStillInUsage = 0L;
            long rssMemoryStillInUsage = 0L;
            Iterator<Map.Entry<TaskAttemptID, ProcessTreeInfo>> it = this.processTreeInfoMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TaskAttemptID, ProcessTreeInfo> entry = it.next();
                TaskAttemptID tid = entry.getKey();
                ProcessTreeInfo ptInfo = entry.getValue();
                try {
                    String pId = ptInfo.getPID();
                    if (pId == null && (pId = this.taskTracker.getPid(ptInfo.getTID())) != null) {
                        long sleeptimeBeforeSigkill = this.taskTracker.getJobConf().getLong("mapreduce.tasktracker.tasks.sleeptimebeforesigkill", 5000L);
                        ProcfsBasedProcessTree pt = new ProcfsBasedProcessTree(pId, ProcessTree.isSetsidAvailable, sleeptimeBeforeSigkill);
                        LOG.debug((Object)("Tracking ProcessTree " + pId + " for the first time"));
                        ptInfo.setPid(pId);
                        ptInfo.setProcessTree(pt);
                    }
                    if (pId == null || this.taskTracker.runningTasks.get(tid).wasKilled()) continue;
                    LOG.debug((Object)("Constructing ProcessTree for : PID = " + pId + " TID = " + tid));
                    ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
                    pTree = pTree.getProcessTree();
                    ptInfo.setProcessTree(pTree);
                    long currentMemUsage = pTree.getCumulativeVmem();
                    long currentRssMemUsage = pTree.getCumulativeRssmem();
                    long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
                    long curRssMemUsageOfAgedProcesses = pTree.getCumulativeRssmem(1);
                    long limit = ptInfo.getMemLimit();
                    long limitPhysical = ptInfo.getMemLimitPhysical();
                    LOG.info((Object)String.format(MEMORY_USAGE_STRING, pId, tid.toString(), currentMemUsage, limit, currentRssMemUsage, limitPhysical));
                    boolean isMemoryOverLimit = false;
                    String msg = "";
                    if (this.doCheckVirtualMemory() && this.isProcessTreeOverLimit(tid.toString(), currentMemUsage, curMemUsageOfAgedProcesses, limit)) {
                        msg = "TaskTree [pid=" + pId + ",tipID=" + tid + "] is running beyond memory-limits. Current usage : " + currentMemUsage + "bytes. Limit : " + limit + "bytes. Killing task. \nDump of the process-tree for " + tid + " : \n" + pTree.getProcessTreeDump();
                        isMemoryOverLimit = true;
                    } else if (this.doCheckPhysicalMemory() && this.isProcessTreeOverLimit(tid.toString(), currentRssMemUsage, curRssMemUsageOfAgedProcesses, limitPhysical)) {
                        msg = "TaskTree [pid=" + pId + ",tipID=" + tid + "] is running beyond physical memory-limits." + " Current usage : " + currentRssMemUsage + "bytes. Limit : " + limitPhysical + "bytes. Killing task. \nDump of the process-tree for " + tid + " : \n" + pTree.getProcessTreeDump();
                        isMemoryOverLimit = true;
                    }
                    if (isMemoryOverLimit) {
                        LOG.warn((Object)msg);
                        this.taskTracker.cleanUpOverMemoryTask(tid, true, msg);
                        pTree.destroy(true);
                        it.remove();
                        LOG.info((Object)("Removed ProcessTree with root " + pId));
                        continue;
                    }
                    memoryStillInUsage += currentMemUsage;
                    rssMemoryStillInUsage += currentRssMemUsage;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Uncaught exception in TaskMemoryManager while managing memory of " + tid + " : " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            if (this.doCheckVirtualMemory() && memoryStillInUsage > this.maxMemoryAllowedForAllTasks) {
                LOG.warn((Object)("The total memory in usage " + memoryStillInUsage + " is still overflowing TTs limits " + this.maxMemoryAllowedForAllTasks + ". Trying to kill a few tasks with the least progress."));
                this.killTasksWithLeastProgress(memoryStillInUsage);
            }
            if (this.doCheckPhysicalMemory() && rssMemoryStillInUsage > this.maxRssMemoryAllowedForAllTasks) {
                LOG.warn((Object)("The total physical memory in usage " + rssMemoryStillInUsage + " is still overflowing TTs limits " + this.maxRssMemoryAllowedForAllTasks + ". Trying to kill a few tasks with the highest memory."));
                this.killTasksWithMaxRssMemory(rssMemoryStillInUsage);
            }
            try {
                LOG.debug((Object)(this.getClass() + " : Sleeping for " + this.monitoringInterval + " ms"));
                Thread.sleep(this.monitoringInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)(this.getClass() + " interrupted. Finishing the thread and returning."));
                return;
            }
        }
    }

    private boolean doCheckPhysicalMemory() {
        return this.maxRssMemoryAllowedForAllTasks != -1L;
    }

    private boolean doCheckVirtualMemory() {
        return this.maxMemoryAllowedForAllTasks != -1L;
    }

    boolean isProcessTreeOverLimit(String tId, long currentMemUsage, long curMemUsageOfAgedProcesses, long limit) {
        boolean isOverLimit = false;
        if (currentMemUsage > 2L * limit) {
            LOG.warn((Object)("Process tree for task: " + tId + " running over twice " + "the configured limit. Limit=" + limit + ", current usage = " + currentMemUsage));
            isOverLimit = true;
        } else if (curMemUsageOfAgedProcesses > limit) {
            LOG.warn((Object)("Process tree for task: " + tId + " has processes older than 1 " + "iteration running over the configured limit. Limit=" + limit + ", current usage = " + curMemUsageOfAgedProcesses));
            isOverLimit = true;
        }
        return isOverLimit;
    }

    boolean isProcessTreeOverLimit(ProcfsBasedProcessTree pTree, String tId, long limit) {
        long currentMemUsage = pTree.getCumulativeVmem();
        long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
        return this.isProcessTreeOverLimit(tId, currentMemUsage, curMemUsageOfAgedProcesses, limit);
    }

    private void killTasksWithLeastProgress(long memoryStillInUsage) {
        TaskTracker.TaskInProgress task;
        ArrayList<TaskAttemptID> tasksToKill = new ArrayList<TaskAttemptID>();
        ArrayList<TaskAttemptID> tasksToExclude = new ArrayList<TaskAttemptID>();
        while (memoryStillInUsage > this.maxMemoryAllowedForAllTasks && (task = this.taskTracker.findTaskToKill(tasksToExclude)) != null) {
            TaskAttemptID tid = task.getTask().getTaskID();
            if (this.processTreeInfoMap.containsKey(tid)) {
                ProcessTreeInfo ptInfo = this.processTreeInfoMap.get(tid);
                ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
                memoryStillInUsage -= pTree.getCumulativeVmem();
                tasksToKill.add(tid);
            }
            tasksToExclude.add(tid);
        }
        if (!tasksToKill.isEmpty()) {
            for (TaskAttemptID tid : tasksToKill) {
                String msg = "Killing one of the least progress tasks - " + tid + ", as the cumulative memory usage of all the tasks on " + "the TaskTracker exceeds virtual memory limit " + this.maxMemoryAllowedForAllTasks + ".";
                LOG.warn((Object)msg);
                this.killTask(tid, msg);
            }
        } else {
            LOG.info((Object)"The total memory usage is overflowing TTs limits. But found no alive task to kill for freeing memory.");
        }
    }

    private long getTaskCumulativeRssmem(TaskAttemptID tid) {
        ProcessTreeInfo ptInfo = this.processTreeInfoMap.get(tid);
        ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
        return pTree == null ? 0L : pTree.getCumulativeVmem();
    }

    private void killTasksWithMaxRssMemory(long rssMemoryInUsage) {
        ArrayList<TaskAttemptID> tasksToKill = new ArrayList<TaskAttemptID>();
        ArrayList<TaskAttemptID> allTasks = new ArrayList<TaskAttemptID>();
        allTasks.addAll(this.processTreeInfoMap.keySet());
        Collections.sort(allTasks, new Comparator<TaskAttemptID>(){

            @Override
            public int compare(TaskAttemptID tid1, TaskAttemptID tid2) {
                return TaskMemoryManagerThread.this.getTaskCumulativeRssmem(tid1) < TaskMemoryManagerThread.this.getTaskCumulativeRssmem(tid2) ? -1 : 1;
            }
        });
        while (rssMemoryInUsage > this.maxRssMemoryAllowedForAllTasks && !allTasks.isEmpty()) {
            TaskAttemptID tid = (TaskAttemptID)allTasks.remove(allTasks.size() - 1);
            if (!this.isKillable(tid)) continue;
            long rssmem = this.getTaskCumulativeRssmem(tid);
            if (rssmem == 0L) break;
            tasksToKill.add(tid);
            rssMemoryInUsage -= rssmem;
        }
        if (!tasksToKill.isEmpty()) {
            for (TaskAttemptID tid : tasksToKill) {
                String msg = "Killing one of the memory-consuming tasks - " + tid + ", as the cumulative RSS memory usage of all the tasks on " + "the TaskTracker exceeds physical memory limit " + this.maxRssMemoryAllowedForAllTasks + ".";
                LOG.warn((Object)msg);
                this.killTask(tid, msg);
            }
        } else {
            LOG.info((Object)"The total physical memory usage is overflowing TTs limits. But found no alive task to kill for freeing memory.");
        }
    }

    private void killTask(TaskAttemptID tid, String msg) {
        this.taskTracker.cleanUpOverMemoryTask(tid, false, msg);
        ProcessTreeInfo ptInfo = this.processTreeInfoMap.get(tid);
        ProcfsBasedProcessTree pTree = ptInfo.getProcessTree();
        pTree.destroy(true);
        this.processTreeInfoMap.remove(tid);
        LOG.info((Object)("Removed ProcessTree with root " + ptInfo.getPID()));
    }

    private boolean isKillable(TaskAttemptID tid) {
        TaskTracker.TaskInProgress tip = this.taskTracker.runningTasks.get(tid);
        return tip != null && !tip.wasKilled() && (tip.getRunState() == TaskStatus.State.RUNNING || tip.getRunState() == TaskStatus.State.COMMIT_PENDING);
    }

    private static class ProcessTreeInfo {
        private TaskAttemptID tid;
        private String pid;
        private ProcfsBasedProcessTree pTree;
        private long memLimit;
        private long memLimitPhysical;

        public ProcessTreeInfo(TaskAttemptID tid, String pid, ProcfsBasedProcessTree pTree, long memLimit, long memLimitPhysical) {
            this.tid = tid;
            this.pid = pid;
            this.pTree = pTree;
            this.memLimit = memLimit;
            this.memLimitPhysical = memLimitPhysical;
        }

        public TaskAttemptID getTID() {
            return this.tid;
        }

        public String getPID() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public ProcfsBasedProcessTree getProcessTree() {
            return this.pTree;
        }

        public void setProcessTree(ProcfsBasedProcessTree pTree) {
            this.pTree = pTree;
        }

        public long getMemLimit() {
            return this.memLimit;
        }

        public long getMemLimitPhysical() {
            return this.memLimitPhysical;
        }
    }
}

