/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
public abstract class JobACLsManager {
    static final Log LOG = LogFactory.getLog(JobACLsManager.class);
    public static final String UNAUTHORIZED_JOB_ACCESS_ERROR = " is not authorized for performing the operation ";

    protected abstract boolean isJobLevelAuthorizationEnabled();

    protected abstract boolean isSuperUserOrSuperGroup(UserGroupInformation var1);

    Map<JobACL, AccessControlList> constructJobACLs(JobConf conf) {
        HashMap<JobACL, AccessControlList> acls = new HashMap<JobACL, AccessControlList>();
        if (!this.isJobLevelAuthorizationEnabled()) {
            return acls;
        }
        for (JobACL aclName : JobACL.values()) {
            String aclConfigName = aclName.getAclName();
            String aclConfigured = conf.get(aclConfigName);
            if (aclConfigured == null) {
                aclConfigured = "";
            }
            acls.put(aclName, new AccessControlList(aclConfigured));
        }
        return acls;
    }

    void checkAccess(JobStatus jobStatus, UserGroupInformation callerUGI, JobACL jobOperation) throws AccessControlException {
        JobID jobId = jobStatus.getJobID();
        String jobOwner = jobStatus.getUsername();
        AccessControlList acl = jobStatus.getJobACLs().get((Object)jobOperation);
        this.checkAccess(jobId, callerUGI, jobOperation, jobOwner, acl);
    }

    void checkAccess(JobID jobId, UserGroupInformation callerUGI, JobACL jobOperation, String jobOwner, AccessControlList jobACL) throws AccessControlException {
        if (!this.isJobLevelAuthorizationEnabled()) {
            return;
        }
        if (this.isSuperUserOrSuperGroup(callerUGI)) {
            LOG.info((Object)("superuser/supergroupMember " + callerUGI.getShortUserName() + " trying to perform " + jobOperation.toString() + " on " + jobId));
            return;
        }
        if (callerUGI.getShortUserName().equals(jobOwner)) {
            LOG.info((Object)("Jobowner " + callerUGI.getShortUserName() + " trying to perform " + jobOperation.toString() + " on " + jobId));
            return;
        }
        if (jobACL.isUserAllowed(callerUGI)) {
            LOG.info((Object)("Normal user " + callerUGI.getShortUserName() + " trying to perform " + jobOperation.toString() + " on " + jobId));
            return;
        }
        throw new AccessControlException(callerUGI + UNAUTHORIZED_JOB_ACCESS_ERROR + jobOperation.toString() + " on " + jobId + ". " + jobOperation.toString() + " Access control list configured for this job : " + jobACL.toString());
    }
}

