/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamenodeRegistration
extends StorageInfo
implements NodeRegistration {
    String rpcAddress;
    String httpAddress;
    HdfsConstants.NamenodeRole role;
    long checkpointTime = -1L;
    public static final String __PARANAMER_DATA = "<init> java.lang.String,java.lang.String,org.apache.hadoop.hdfs.server.common.StorageInfo,org.apache.hadoop.hdfs.server.common.HdfsConstants.NamenodeRole,long address,httpAddress,storageInfo,role,checkpointTime \nisRole org.apache.hadoop.hdfs.server.common.HdfsConstants.NamenodeRole that \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public NamenodeRegistration() {
    }

    public NamenodeRegistration(String address, String httpAddress, StorageInfo storageInfo, HdfsConstants.NamenodeRole role, long checkpointTime) {
        this.rpcAddress = address;
        this.httpAddress = httpAddress;
        this.setStorageInfo(storageInfo);
        this.role = role;
        this.checkpointTime = checkpointTime;
    }

    @Override
    public String getAddress() {
        return this.rpcAddress;
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this);
    }

    @Override
    public int getVersion() {
        return super.getLayoutVersion();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.rpcAddress + ", role=" + (Object)((Object)this.getRole()) + ")";
    }

    public HdfsConstants.NamenodeRole getRole() {
        return this.role;
    }

    public boolean isRole(HdfsConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    public long getCheckpointTime() {
        return this.checkpointTime;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.rpcAddress);
        Text.writeString((DataOutput)out, (String)this.httpAddress);
        Text.writeString((DataOutput)out, (String)this.role.name());
        super.write(out);
        out.writeLong(this.checkpointTime);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.rpcAddress = Text.readString((DataInput)in);
        this.httpAddress = Text.readString((DataInput)in);
        this.role = HdfsConstants.NamenodeRole.valueOf(Text.readString((DataInput)in));
        super.readFields(in);
        this.checkpointTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(NamenodeRegistration.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new NamenodeRegistration();
            }
        });
    }
}

