/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INode;

class INodeFile
extends INode {
    static final FsPermission UMASK = FsPermission.createImmutable((short)73);
    protected BlockInfo[] blocks = null;
    protected short blockReplication;
    protected long preferredBlockSize;

    INodeFile(PermissionStatus permissions, int nrBlocks, short replication, long modificationTime, long atime, long preferredBlockSize) {
        this(permissions, new BlockInfo[nrBlocks], replication, modificationTime, atime, preferredBlockSize);
    }

    protected INodeFile() {
        this.blocks = null;
        this.blockReplication = 0;
        this.preferredBlockSize = 0L;
    }

    protected INodeFile(PermissionStatus permissions, BlockInfo[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize) {
        super(permissions, modificationTime, atime);
        this.blockReplication = replication;
        this.preferredBlockSize = preferredBlockSize;
        this.blocks = blklist;
    }

    @Override
    protected void setPermission(FsPermission permission) {
        super.setPermission(permission.applyUMask(UMASK));
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    void setReplication(short replication) {
        this.blockReplication = replication;
    }

    BlockInfo[] getBlocks() {
        return this.blocks;
    }

    void appendBlocks(INodeFile[] inodes, int totalAddedBlocks) {
        int size = this.blocks.length;
        BlockInfo[] newlist = new BlockInfo[size + totalAddedBlocks];
        System.arraycopy(this.blocks, 0, newlist, 0, size);
        for (INodeFile iNodeFile : inodes) {
            System.arraycopy(iNodeFile.blocks, 0, newlist, size, iNodeFile.blocks.length);
            size += iNodeFile.blocks.length;
        }
        for (Comparable<byte[]> comparable : this.blocks) {
            ((BlockInfo)comparable).setINode(this);
        }
        this.blocks = newlist;
    }

    void addBlock(BlockInfo newblock) {
        if (this.blocks == null) {
            this.blocks = new BlockInfo[1];
            this.blocks[0] = newblock;
        } else {
            int size = this.blocks.length;
            BlockInfo[] newlist = new BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.blocks = newlist;
        }
    }

    void setBlock(int idx, BlockInfo blk) {
        this.blocks[idx] = blk;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        this.parent = null;
        if (this.blocks != null && v != null) {
            for (BlockInfo blk : this.blocks) {
                v.add(blk);
                blk.setINode(null);
            }
        }
        this.blocks = null;
        return 1;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        summary[0] = summary[0] + this.computeFileSize(true);
        summary[1] = summary[1] + 1L;
        summary[3] = summary[3] + this.diskspaceConsumed();
        return summary;
    }

    long computeFileSize(boolean includesBlockInfoUnderConstruction) {
        if (this.blocks == null || this.blocks.length == 0) {
            return 0L;
        }
        int last = this.blocks.length - 1;
        long bytes = this.blocks[last] instanceof BlockInfoUnderConstruction && !includesBlockInfoUnderConstruction ? 0L : this.blocks[last].getNumBytes();
        for (int i = 0; i < last; ++i) {
            bytes += this.blocks[i].getNumBytes();
        }
        return bytes;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        counts.dsCount += this.diskspaceConsumed();
        return counts;
    }

    long diskspaceConsumed() {
        return this.diskspaceConsumed(this.blocks);
    }

    long diskspaceConsumed(Block[] blkArr) {
        long size = 0L;
        if (blkArr == null) {
            return 0L;
        }
        for (Block blk : blkArr) {
            if (blk == null) continue;
            size += blk.getNumBytes();
        }
        if (blkArr.length > 0 && blkArr[blkArr.length - 1] != null && this.isUnderConstruction()) {
            size += this.preferredBlockSize - this.blocks[this.blocks.length - 1].getNumBytes();
        }
        return size * (long)this.blockReplication;
    }

    public long getPreferredBlockSize() {
        return this.preferredBlockSize;
    }

    BlockInfo getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    <T extends BlockInfo> T getLastBlock() throws IOException {
        if (this.blocks == null || this.blocks.length == 0) {
            return null;
        }
        BlockInfo returnBlock = null;
        try {
            BlockInfo tBlock;
            returnBlock = tBlock = this.blocks[this.blocks.length - 1];
        }
        catch (ClassCastException cce) {
            throw new IOException("Unexpected last block type: " + this.blocks[this.blocks.length - 1].getClass().getSimpleName());
        }
        return (T)returnBlock;
    }

    int numBlocks() {
        return this.blocks == null ? 0 : this.blocks.length;
    }
}

