/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.security.BlockAccessToken;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock
implements Writable {
    private Block b;
    private long offset;
    private DatanodeInfo[] locs;
    private boolean corrupt;
    private BlockAccessToken accessToken = new BlockAccessToken();
    public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.DatanodeInfo[] b,locs \n<init> org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],long b,locs,startOffset \n<init> org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],long,boolean b,locs,startOffset,corrupt \nread java.io.DataInput in \nreadFields java.io.DataInput in \nsetAccessToken org.apache.hadoop.hdfs.security.BlockAccessToken token \nsetCorrupt boolean corrupt \nsetStartOffset long value \nwrite java.io.DataOutput out \n";

    public LocatedBlock() {
        this(new Block(), new DatanodeInfo[0], 0L, false);
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs) {
        this(b, locs, -1L, false);
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs, long startOffset) {
        this(b, locs, startOffset, false);
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs, long startOffset, boolean corrupt) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        this.locs = locs == null ? new DatanodeInfo[0] : locs;
    }

    public BlockAccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(BlockAccessToken token) {
        this.accessToken = token;
    }

    public Block getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value) {
        this.offset = value;
    }

    void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void write(DataOutput out) throws IOException {
        this.accessToken.write(out);
        out.writeBoolean(this.corrupt);
        out.writeLong(this.offset);
        this.b.write(out);
        out.writeInt(this.locs.length);
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.accessToken.readFields(in);
        this.corrupt = in.readBoolean();
        this.offset = in.readLong();
        this.b = new Block();
        this.b.readFields(in);
        int count = in.readInt();
        this.locs = new DatanodeInfo[count];
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i] = new DatanodeInfo();
            this.locs[i].readFields(in);
        }
    }

    public static LocatedBlock read(DataInput in) throws IOException {
        LocatedBlock lb = new LocatedBlock();
        lb.readFields(in);
        return lb;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "}";
    }

    static {
        WritableFactories.setFactory(LocatedBlock.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new LocatedBlock();
            }
        });
    }
}

